/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFTimeUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;

class TimeCoordinateVariable
extends CoordinateVariable<Date> {
    private static final Logger LOGGER = Logger.getLogger(TimeCoordinateVariable.class.toString());
    private String units;
    private int baseTimeUnits;
    private Date epoch;

    public TimeCoordinateVariable(CoordinateAxis coordinateAxis) {
        super(Date.class, coordinateAxis);
        this.units = coordinateAxis.getUnitsString();
        String origin = null;
        String[] unitsParts = this.units.split("(?i)\\s+since\\s+");
        if (unitsParts.length == 2) {
            this.units = unitsParts[0].trim();
            origin = unitsParts[1].trim();
        } else {
            Attribute attribute = coordinateAxis.findAttribute("time_origin");
            if (attribute != null) {
                origin = attribute.getStringValue();
            }
        }
        this.baseTimeUnits = NetCDFTimeUtilities.getTimeUnits(this.units, null);
        if (this.baseTimeUnits == -1) {
            throw new IllegalArgumentException("Couldn't determine time units from unit string '" + this.units + "'");
        }
        if (origin != null) {
            origin = NetCDFTimeUtilities.trimFractionalPart(origin);
            origin = NetCDFTimeUtilities.checkDateDigits(origin);
            try {
                this.epoch = (Date)NetCDFUtilities.getAxisFormat(AxisType.Time, origin).parseObject(origin);
            }
            catch (ParseException e) {
                LOGGER.warning("Error while parsing time Axis. Skip setting the TemporalExtent from coordinateAxis");
            }
        }
        this.init();
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    protected synchronized CoordinateReferenceSystem buildCoordinateReferenceSystem() {
        return NetCDFCRSUtilities.buildTemporalCrs(this.coordinateAxis);
    }

    @Override
    protected Date convertValue(Object o) {
        GregorianCalendar cal = new GregorianCalendar();
        if (this.epoch != null) {
            cal.setTime(this.epoch);
        } else {
            cal.setTimeInMillis(0L);
        }
        ((Calendar)cal).setTimeZone(NetCDFTimeUtilities.UTC_TIMEZONE);
        double coordValue = ((Number)o).doubleValue();
        long vi = (long)Math.floor(coordValue);
        double vd = coordValue - (double)vi;
        NetCDFTimeUtilities.addTimeUnit((Calendar)cal, this.baseTimeUnits, vi);
        if (vd != 0.0) {
            NetCDFTimeUtilities.addTimeUnit((Calendar)cal, NetCDFTimeUtilities.getTimeUnits(this.units, vd), NetCDFTimeUtilities.getTimeSubUnitsValue(this.units, vd));
        }
        return cal.getTime();
    }
}

