/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.geotools.io.MemoryMappedRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class MemoryMappedFileCache
implements FileCacheIF {
    protected static final Logger log = LoggerFactory.getLogger(MemoryMappedFileCache.class);
    protected static final Logger cacheLog = LoggerFactory.getLogger((String)"MemoryMappedFileCacheLogger");
    private static Timer timer;
    private static Object lock;
    protected String name;
    protected final int softLimit;
    protected final int minElements;
    protected final int hardLimit;
    protected final long period;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    protected final AtomicBoolean hasScheduled = new AtomicBoolean(false);
    protected final ConcurrentHashMap<Object, CacheElement> cache;
    protected final ConcurrentHashMap<FileCacheable, CacheElement.CacheFile> files;
    protected final AtomicInteger cleanups = new AtomicInteger();
    protected final AtomicInteger hits = new AtomicInteger();
    protected final AtomicInteger miss = new AtomicInteger();
    protected ConcurrentHashMap<Object, CacheTracking> track;
    protected boolean trackAll = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = lock;
        synchronized (object) {
            if (timer != null) {
                timer.cancel();
                cacheLog.info("MemoryMappedFileCache.shutdown called%n");
            }
            timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        Object object = lock;
        synchronized (object) {
            if (timer == null) {
                timer = new Timer("MemoryMappedFileCache");
            }
            timer.scheduleAtFixedRate(task, delay, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void schedule(TimerTask task, long delay) {
        Object object = lock;
        synchronized (object) {
            if (timer == null) {
                timer = new Timer("MemoryMappedFileCache");
            }
            timer.schedule(task, delay);
        }
    }

    public MemoryMappedFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        this("", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public MemoryMappedFileCache(int minElementsInMemory, int softLimit, int hardLimit, int period) {
        this("", minElementsInMemory, softLimit, hardLimit, period);
    }

    public MemoryMappedFileCache(String name, int minElementsInMemory, int softLimit, int hardLimit, int period) {
        boolean wantsCleanup;
        this.name = name;
        this.minElements = minElementsInMemory;
        this.softLimit = softLimit;
        this.hardLimit = hardLimit;
        this.period = 1000L * (long)period;
        this.cache = new ConcurrentHashMap(2 * softLimit, 0.75f, 8);
        this.files = new ConcurrentHashMap(4 * softLimit, 0.75f, 8);
        boolean bl = wantsCleanup = period > 0;
        if (wantsCleanup) {
            MemoryMappedFileCache.scheduleAtFixedRate(new CleanupTask(), this.period, this.period);
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("MemoryMappedFileCache " + name + " cleanup every " + period + " secs");
            }
        }
        if (this.trackAll) {
            this.track = new ConcurrentHashMap(5000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRaf(String uriString, MemoryMappedRandomAccessFile mmraf) {
        CacheElement elem = this.cache.putIfAbsent(uriString, new CacheElement((FileCacheable)mmraf, uriString));
        if (elem != null) {
            CacheElement cacheElement = elem;
            synchronized (cacheElement) {
                elem.addFile((FileCacheable)mmraf);
            }
        }
    }

    public void disable() {
        this.disabled.set(true);
        this.clearCache(true);
    }

    public void enable() {
        this.disabled.set(false);
    }

    public FileCacheable acquire(FileFactory factory, DatasetUrl durl) throws IOException {
        return this.acquire(factory, durl.getTrueurl(), durl, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCacheable acquire(FileFactory factory, Object hashKey, DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        String uriString;
        Object ncfile;
        CacheTracking prev;
        if (null == hashKey) {
            hashKey = location.getTrueurl();
        }
        if (null == hashKey) {
            throw new IllegalArgumentException();
        }
        CacheTracking t = null;
        if (this.trackAll && (prev = this.track.putIfAbsent(hashKey, t = new CacheTracking(hashKey))) != null) {
            t = prev;
        }
        if ((ncfile = this.acquireCacheOnly(hashKey)) != null) {
            this.hits.incrementAndGet();
            if (t != null) {
                ++t.hit;
            }
            return ncfile;
        }
        this.miss.incrementAndGet();
        if (t != null) {
            ++t.miss;
        }
        if ((uriString = StringUtil2.replace((String)location.getTrueurl(), (char)'\\', (String)"/")).startsWith("file:")) {
            uriString = StringUtil2.unescape((String)uriString.substring(5));
        }
        ncfile = new MemoryMappedRandomAccessFile(uriString, "r");
        if (cacheLog.isDebugEnabled()) {
            cacheLog.debug("MemoryMappedFileCache " + this.name + " acquire " + hashKey + " " + ncfile.getLocation());
        }
        if (cancelTask != null && cancelTask.isCancel()) {
            if (ncfile != null) {
                ncfile.close();
            }
            return null;
        }
        if (this.disabled.get()) {
            return ncfile;
        }
        CacheElement elem = this.cache.putIfAbsent(hashKey, new CacheElement((FileCacheable)ncfile, hashKey));
        if (elem != null) {
            CacheElement cacheElement = elem;
            synchronized (cacheElement) {
                elem.addFile((FileCacheable)ncfile);
            }
        }
        boolean needHard = false;
        boolean needSoft = false;
        if (!this.hasScheduled.get()) {
            int count = this.files.size();
            if (count > this.hardLimit && this.hardLimit > 0) {
                needHard = true;
                this.hasScheduled.getAndSet(true);
            } else if (count > this.softLimit && this.softLimit > 0) {
                this.hasScheduled.getAndSet(true);
                needSoft = true;
            }
        }
        if (needHard) {
            this.cleanup(this.hardLimit);
        } else if (needSoft) {
            MemoryMappedFileCache.schedule(new CleanupTask(), 100L);
        }
        return ncfile;
    }

    private FileCacheable acquireCacheOnly(Object hashKey) {
        if (this.disabled.get()) {
            return null;
        }
        CacheElement wantCacheElem = this.cache.get(hashKey);
        if (wantCacheElem == null) {
            return null;
        }
        CacheElement.CacheFile want = null;
        for (CacheElement.CacheFile file : wantCacheElem.list) {
            if (!file.isLocked.compareAndSet(false, true)) continue;
            want = file;
            break;
        }
        if (want == null) {
            return null;
        }
        if (want.ncfile != null) {
            boolean changed;
            long lastModified = want.ncfile.getLastModified();
            boolean bl = changed = lastModified != want.lastModified;
            if (cacheLog.isDebugEnabled() && changed) {
                cacheLog.debug("MemoryMappedFileCache " + this.name + ": acquire from cache " + hashKey + " " + want.ncfile.getLocation() + " was changed; discard");
            }
            if (changed) {
                this.remove(want);
            }
        }
        if (want.ncfile != null) {
            try {
                want.ncfile.reacquire();
            }
            catch (IOException ioe) {
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("MemoryMappedFileCache " + this.name + " acquire from cache " + hashKey + " " + want.ncfile.getLocation() + " failed: " + ioe.getMessage());
                }
                this.remove(want);
            }
        }
        return want.ncfile;
    }

    private void remove(CacheElement.CacheFile want) {
        want.remove();
        this.files.remove(want.ncfile);
        try {
            want.ncfile.setFileCache(null);
            want.ncfile.close();
        }
        catch (IOException ioe) {
            log.error("close failed on " + want.ncfile.getLocation(), (Throwable)ioe);
        }
        want.ncfile = null;
    }

    public void eject(Object hashKey) {
        CacheElement wantCacheElem;
        if (!this.disabled.get() && (wantCacheElem = this.cache.get(hashKey)) != null) {
            Iterator<CacheElement.CacheFile> listIt = wantCacheElem.list.iterator();
            while (true) {
                if (!listIt.hasNext()) break;
                CacheElement.CacheFile want = listIt.next();
                this.files.remove(want.ncfile);
                try {
                    want.ncfile.setFileCache(null);
                    want.ncfile.close();
                    log.debug("close " + want.ncfile.getLocation());
                }
                catch (IOException ioe) {
                    log.error("close failed on " + want.ncfile.getLocation(), (Throwable)ioe);
                }
                want.ncfile = null;
            }
            wantCacheElem.list.clear();
            this.cache.remove(hashKey);
        }
    }

    public boolean release(FileCacheable ncfile) throws IOException {
        if (ncfile == null) {
            return false;
        }
        if (this.disabled.get()) {
            ncfile.setFileCache(null);
            ncfile.close();
            return false;
        }
        CacheElement.CacheFile file = this.files.get(ncfile);
        if (file != null) {
            if (!file.isLocked.get()) {
                cacheLog.warn("MemoryMappedFileCache " + this.name + " release " + ncfile.getLocation() + " not locked; hash= " + ncfile.hashCode());
            }
            file.lastAccessed = System.currentTimeMillis();
            ++file.countAccessed;
            try {
                file.ncfile.release();
                file.isLocked.set(false);
            }
            catch (IOException ioe) {
                cacheLog.error("MemoryMappedFileCache {} release failed on {} - will try to remove from cache. Failure due to:", new Object[]{this.name, file.getCacheName(), ioe});
                this.remove(file);
            }
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("MemoryMappedFileCache " + this.name + " release " + ncfile.getLocation() + "; hash= " + ncfile.hashCode());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache(boolean force) {
        ArrayList<CacheElement.CacheFile> deleteList = new ArrayList<CacheElement.CacheFile>(2 * this.cache.size());
        if (force) {
            this.cache.clear();
            deleteList.addAll(this.files.values());
            this.files.clear();
        } else {
            Iterator<CacheElement.CacheFile> iter = this.files.values().iterator();
            while (iter.hasNext()) {
                CacheElement.CacheFile file = iter.next();
                if (!file.isLocked.compareAndSet(false, true)) continue;
                file.remove();
                deleteList.add(file);
                iter.remove();
            }
            Iterator<CacheElement> iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                CacheElement elem;
                CacheElement cacheElement = elem = iterator.next();
                synchronized (cacheElement) {
                    if (elem.list.isEmpty()) {
                        iterator.remove();
                    }
                }
            }
        }
        for (CacheElement.CacheFile file : deleteList) {
            if (force && file.isLocked.get()) {
                cacheLog.warn("MemoryMappedFileCache " + this.name + " force close locked file= " + file);
            }
            try {
                if (file != null && file.ncfile != null) {
                    file.ncfile.setFileCache(null);
                    file.ncfile.close();
                } else {
                    log.error(String.format("MemoryMappedFileCache %s: null file or null ncfile", this.name));
                }
                if (file == null) continue;
                file.ncfile = null;
            }
            catch (IOException ioe) {
                log.error("MemoryMappedFileCache " + this.name + " close failed on " + file);
            }
        }
        if (cacheLog.isDebugEnabled()) {
            cacheLog.debug("*MemoryMappedFileCache " + this.name + " clearCache force= " + force + " deleted= " + deleteList.size() + " left=" + this.files.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCache(Formatter format) {
        ArrayList<CacheElement.CacheFile> allFiles = new ArrayList<CacheElement.CacheFile>(this.files.size());
        Iterator<CacheElement> it = this.cache.values().iterator();
        while (it.hasNext()) {
            CacheElement elem;
            CacheElement cacheElement = elem = it.next();
            synchronized (cacheElement) {
                allFiles.addAll(elem.list);
            }
        }
        Collections.sort(allFiles);
        format.format("%nFileCache %s (min=%d softLimit=%d hardLimit=%d scour=%d secs):%n", this.name, this.minElements, this.softLimit, this.hardLimit, this.period / 1000L);
        format.format(" isLocked  accesses lastAccess                   location %n", new Object[0]);
        for (CacheElement.CacheFile file : allFiles) {
            String loc = file.ncfile != null ? file.ncfile.getLocation() : "null";
            format.format("%8s %9d %s == %s %n", file.isLocked, file.countAccessed, CalendarDateFormatter.toDateTimeStringISO((long)file.lastAccessed), loc);
        }
        this.showStats(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> showCache() {
        ArrayList<CacheElement.CacheFile> allFiles = new ArrayList<CacheElement.CacheFile>(this.files.size());
        Iterator<CacheElement> valIt = this.cache.values().iterator();
        while (valIt.hasNext()) {
            CacheElement elem;
            CacheElement cacheElement = elem = valIt.next();
            synchronized (cacheElement) {
                allFiles.addAll(elem.list);
            }
        }
        Collections.sort(allFiles);
        ArrayList<String> result = new ArrayList<String>(allFiles.size());
        for (CacheElement.CacheFile file : allFiles) {
            result.add(file.toString());
        }
        return result;
    }

    public void showStats(Formatter format) {
        format.format("  hits= %d miss= %d nfiles= %d elems= %d%n", this.hits.get(), this.miss.get(), this.files.size(), this.cache.values().size());
    }

    public void showTracking(Formatter format) {
        if (this.track != null) {
            ArrayList<CacheTracking> all = new ArrayList<CacheTracking>(this.track.size());
            all.addAll(this.track.values());
            Collections.sort(all);
            int seq = 0;
            int countAll = 0;
            int countHits = 0;
            int countMiss = 0;
            format.format("%nTracking All files in cache %s%n", this.name);
            format.format("    #    accum       hit    miss  file%n", new Object[0]);
            for (CacheTracking t : all) {
                countHits += t.hit;
                countMiss += t.miss;
                format.format("%6d  %7d : %6d %6d %s%n", ++seq, countAll += t.hit + t.miss, t.hit, t.miss, t.key);
            }
            float r = countAll == 0 ? 0.0f : (float)countHits / (float)countAll;
            format.format("  total=%7d : %6d %6d hit ratio=%f%n", countAll, countHits, countMiss, Float.valueOf(r));
        }
    }

    public void resetTracking() {
        this.track = new ConcurrentHashMap(5000);
        this.trackAll = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanup(int maxElements) {
        try {
            int size = this.files.size();
            if (size > this.minElements) {
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("MemoryMappedFileCache {} cleanup started at {} for maxElements={}", new Object[]{this.name, CalendarDate.present(), maxElements});
                }
                this.cleanups.incrementAndGet();
                ArrayList<CacheFileSorter> unlockedFiles = new ArrayList<CacheFileSorter>();
                for (CacheElement.CacheFile file : this.files.values()) {
                    if (file.isLocked.get()) continue;
                    unlockedFiles.add(new CacheFileSorter(file));
                }
                Collections.sort(unlockedFiles);
                int need2delete = size - this.minElements;
                int minDelete = size - maxElements;
                ArrayList<CacheElement.CacheFile> deleteList = new ArrayList<CacheElement.CacheFile>(need2delete);
                int count = 0;
                Iterator iter = unlockedFiles.iterator();
                while (iter.hasNext() && count < need2delete) {
                    CacheElement.CacheFile file = ((CacheFileSorter)iter.next()).cacheFile;
                    if (!file.isLocked.compareAndSet(false, true)) continue;
                    file.remove();
                    deleteList.add(file);
                    ++count;
                }
                if (count < minDelete) {
                    cacheLog.warn("MemoryMappedFileCache " + this.name + " cleanup couldnt remove enough to keep under the maximum= " + maxElements + " due to locked files; currently at = " + (size - count));
                }
                Iterator<CacheElement> iterator = this.cache.values().iterator();
                while (iterator.hasNext()) {
                    CacheElement elem;
                    CacheElement cacheElement = elem = iterator.next();
                    synchronized (cacheElement) {
                        if (elem.list.isEmpty()) {
                            iterator.remove();
                        }
                    }
                }
                long start = System.currentTimeMillis();
                for (CacheElement.CacheFile file : deleteList) {
                    if (null == this.files.remove(file.ncfile) && cacheLog.isDebugEnabled()) {
                        cacheLog.debug(" MemoryMappedFileCache {} cleanup failed to remove {}%n", (Object)this.name, (Object)file.ncfile.getLocation());
                    }
                    try {
                        file.ncfile.setFileCache(null);
                        file.ncfile.close();
                        file.ncfile = null;
                    }
                    catch (IOException ioe) {
                        log.error("MemoryMappedFileCache " + this.name + " close failed on " + file.getCacheName());
                    }
                }
                long took = System.currentTimeMillis() - start;
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug(" MemoryMappedFileCache {} cleanup had={} removed={} took={} msecs%n", new Object[]{this.name, size, deleteList.size(), took});
                }
            }
        }
        finally {
            this.hasScheduled.set(false);
        }
    }

    static {
        lock = new Object();
    }

    private static class CacheTracking
    implements Comparable<CacheTracking> {
        Object key;
        int hit;
        int miss;

        private CacheTracking(Object key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                CacheTracking tracker = (CacheTracking)o;
                return this.key.equals(tracker.key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public int compareTo(CacheTracking o) {
            return Integer.compare(this.hit + this.miss, o.hit + o.miss);
        }
    }

    class CacheElement {
        final ConcurrentLinkedDeque<CacheFile> list = new ConcurrentLinkedDeque();
        final Object key;

        CacheElement(FileCacheable ncfile, Object key) {
            this.key = key;
            CacheFile file = new CacheFile(ncfile);
            this.list.add(file);
            MemoryMappedFileCache.this.files.put(ncfile, file);
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("CacheElement add to cache " + key + " " + MemoryMappedFileCache.this.name);
            }
        }

        CacheFile addFile(FileCacheable ncfile) {
            CacheFile file = new CacheFile(ncfile);
            this.list.add(file);
            MemoryMappedFileCache.this.files.put(ncfile, file);
            return file;
        }

        public String toString() {
            return this.key + " count=" + this.list.size();
        }

        class CacheFile
        implements Comparable<CacheFile> {
            FileCacheable ncfile;
            final AtomicBoolean isLocked = new AtomicBoolean(true);
            int countAccessed;
            long lastModified;
            long lastAccessed;

            private CacheFile(FileCacheable ncfile) {
                this.ncfile = ncfile;
                this.lastModified = ncfile.getLastModified();
                this.lastAccessed = System.currentTimeMillis();
                ncfile.setFileCache((FileCacheIF)MemoryMappedFileCache.this);
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("MemoryMappedFileCache " + MemoryMappedFileCache.this.name + " add to cache " + CacheElement.this.key);
                }
            }

            String getCacheName() {
                return this.ncfile.getLocation();
            }

            void remove() {
                if (!CacheElement.this.list.remove(this)) {
                    cacheLog.warn("MemoryMappedFileCache " + MemoryMappedFileCache.this.name + " could not remove " + this.ncfile.getLocation());
                }
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("MemoryMappedFileCache " + MemoryMappedFileCache.this.name + " remove " + this.ncfile.getLocation());
                }
            }

            public String toString() {
                String name = this.ncfile == null ? "ncfile is null" : this.ncfile.getLocation();
                return this.isLocked + " " + this.countAccessed + " " + CalendarDateFormatter.toDateTimeStringISO((long)this.lastAccessed) + "   " + name;
            }

            @Override
            public int compareTo(CacheFile o) {
                return Long.compare(this.lastAccessed, o.lastAccessed);
            }
        }
    }

    private class CacheFileSorter
    implements Comparable<CacheFileSorter> {
        private final CacheElement.CacheFile cacheFile;
        private final long lastAccessed;

        CacheFileSorter(CacheElement.CacheFile cacheFile) {
            this.cacheFile = cacheFile;
            this.lastAccessed = cacheFile.lastAccessed;
        }

        @Override
        public int compareTo(CacheFileSorter o) {
            return Long.compare(this.lastAccessed, o.lastAccessed);
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        @Override
        public void run() {
            if (!MemoryMappedFileCache.this.disabled.get()) {
                MemoryMappedFileCache.this.cleanup(MemoryMappedFileCache.this.softLimit);
            }
        }
    }
}

