/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.geotools.data.ogr.GeometryMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class FeatureMapper {
    SimpleFeatureBuilder builder;
    SimpleFeatureType schema;
    GeometryMapper geomMapper;
    GeometryFactory geomFactory;
    DateFormat dateTimeFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    DateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
    HashMap<String, Integer> attributeIndexes;
    OGR ogr;
    static final DecimalFormatSymbols DECIMAL_SYMBOLS = new DecimalFormatSymbols();

    public FeatureMapper(SimpleFeatureType targetSchema, Object layer, GeometryFactory geomFactory, OGR ogr) {
        this.schema = targetSchema;
        this.builder = new SimpleFeatureBuilder(this.schema);
        this.geomMapper = new GeometryMapper.WKB(geomFactory, ogr);
        this.geomFactory = geomFactory;
        this.ogr = ogr;
        this.attributeIndexes = new HashMap();
        Object layerDefinition = ogr.LayerGetLayerDefn(layer);
        int size = ogr.LayerGetFieldCount(layerDefinition);
        for (int i = 0; i < size; ++i) {
            Object field = ogr.LayerGetFieldDefn(layerDefinition, i);
            String name = ogr.FieldGetName(field);
            if (targetSchema.getDescriptor(name) == null) continue;
            this.attributeIndexes.put(name, i);
        }
    }

    SimpleFeature convertOgrFeature(Object ogrFeature) throws IOException {
        Object[] attributes = new Object[this.schema.getAttributeCount()];
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor at = this.schema.getDescriptor(i);
            this.builder.add(this.getOgrField(at, ogrFeature));
        }
        String fid = this.convertOGRFID(this.schema, ogrFeature);
        return this.builder.buildFeature(fid);
    }

    Object convertGTFeature(Object featureDefinition, SimpleFeature feature) throws IOException {
        Object ogrFeature = this.ogr.LayerNewFeature(featureDefinition);
        SimpleFeatureType schema = feature.getFeatureType();
        int j = 0;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            Object attribute = feature.getAttribute(i);
            if (attribute instanceof Geometry) {
                Object geometry = this.geomMapper.parseGTGeometry((Geometry)attribute);
                this.ogr.FeatureSetGeometryDirectly(ogrFeature, geometry);
                continue;
            }
            FeatureMapper.setFieldValue(featureDefinition, ogrFeature, j, attribute, this.ogr);
            ++j;
        }
        return ogrFeature;
    }

    static void setFieldValue(Object featureDefinition, Object ogrFeature, int fieldIdx, Object value, OGR ogr) throws IOException {
        if (value == null) {
            ogr.FeatureUnsetField(ogrFeature, fieldIdx);
        } else {
            Object fieldDefinition = ogr.LayerGetFieldDefn(featureDefinition, fieldIdx);
            long ogrType = ogr.FieldGetType(fieldDefinition);
            if (ogr.FieldIsIntegerType(ogrType)) {
                ogr.FeatureSetFieldInteger(ogrFeature, fieldIdx, ((Number)value).intValue());
            } else if (ogr.FieldIsRealType(ogrType)) {
                ogr.FeatureSetFieldDouble(ogrFeature, fieldIdx, ((Number)value).doubleValue());
            } else if (ogr.FieldIsBinaryType(ogrType)) {
                byte[] attValue = (byte[])value;
                ogr.FeatureSetFieldBinary(ogrFeature, fieldIdx, attValue.length, attValue);
            } else if (ogr.FieldIsDateType(ogrType)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                ogr.FeatureSetFieldDateTime(ogrFeature, fieldIdx, year, month, day, 0, 0, 0, 0);
            } else if (ogr.FieldIsTimeType(ogrType)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                int hour = cal.get(11);
                int minute = cal.get(12);
                int second = cal.get(13);
                ogr.FeatureSetFieldDateTime(ogrFeature, fieldIdx, 0, 0, 0, hour, minute, second, 0);
            } else if (ogr.FieldIsDateTimeType(ogrType)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int hour = cal.get(11);
                int minute = cal.get(12);
                int second = cal.get(13);
                ogr.FeatureSetFieldDateTime(ogrFeature, fieldIdx, year, month, day, hour, minute, second, 0);
            } else {
                String str = (String)Converters.convert((Object)value, String.class);
                ogr.FeatureSetFieldString(ogrFeature, fieldIdx, str);
            }
        }
    }

    Geometry fixGeometryType(Geometry ogrGeometry, AttributeDescriptor ad) {
        if (MultiPolygon.class.equals((Object)ad.getType().getBinding())) {
            if (ogrGeometry instanceof MultiPolygon) {
                return ogrGeometry;
            }
            return this.geomFactory.createMultiPolygon(new Polygon[]{(Polygon)ogrGeometry});
        }
        if (MultiLineString.class.equals((Object)ad.getType().getBinding())) {
            if (ogrGeometry instanceof MultiLineString) {
                return ogrGeometry;
            }
            return this.geomFactory.createMultiLineString(new LineString[]{(LineString)ogrGeometry});
        }
        return ogrGeometry;
    }

    Object getOgrField(AttributeDescriptor ad, Object ogrFeature) throws IOException {
        if (ad instanceof GeometryDescriptor) {
            Object ogrGeometry = this.ogr.FeatureGetGeometry(ogrFeature);
            return this.fixGeometryType(this.geomMapper.parseOgrGeometry(ogrGeometry), ad);
        }
        Integer idx = this.attributeIndexes.get(ad.getLocalName());
        if (idx == null || !this.ogr.FeatureIsFieldSet(ogrFeature, idx)) {
            return null;
        }
        Class clazz = ad.getType().getBinding();
        if (clazz.equals(String.class)) {
            return this.ogr.FeatureGetFieldAsString(ogrFeature, idx);
        }
        if (clazz.equals(Byte.class)) {
            return (byte)this.ogr.FeatureGetFieldAsInteger(ogrFeature, idx);
        }
        if (clazz.equals(Short.class)) {
            return (short)this.ogr.FeatureGetFieldAsInteger(ogrFeature, idx);
        }
        if (clazz.equals(Integer.class)) {
            return this.ogr.FeatureGetFieldAsInteger(ogrFeature, idx);
        }
        if (clazz.equals(Long.class)) {
            String value = this.ogr.FeatureGetFieldAsString(ogrFeature, idx);
            return Long.valueOf(value);
        }
        if (clazz.equals(BigInteger.class)) {
            String value = this.ogr.FeatureGetFieldAsString(ogrFeature, idx);
            return new BigInteger(value);
        }
        if (clazz.equals(Double.class)) {
            return this.ogr.FeatureGetFieldAsDouble(ogrFeature, idx);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf((float)this.ogr.FeatureGetFieldAsDouble(ogrFeature, idx));
        }
        if (clazz.equals(BigDecimal.class)) {
            String value = this.ogr.FeatureGetFieldAsString(ogrFeature, idx).trim();
            char separator = DECIMAL_SYMBOLS.getDecimalSeparator();
            if (separator != '.') {
                value = value.replace(separator, '.');
            }
            return new BigDecimal(value);
        }
        if (clazz.equals(Date.class)) {
            Calendar cal = this.getDateField(ogrFeature, idx);
            cal.clear(11);
            cal.clear(12);
            cal.clear(13);
            return new Date(cal.getTimeInMillis());
        }
        if (clazz.equals(Time.class)) {
            Calendar cal = this.getDateField(ogrFeature, idx);
            cal.clear(1);
            cal.clear(2);
            cal.clear(5);
            return new Time(cal.getTimeInMillis());
        }
        if (clazz.equals(Timestamp.class)) {
            Calendar cal = this.getDateField(ogrFeature, idx);
            return new Time(cal.getTimeInMillis());
        }
        if (clazz.equals(java.util.Date.class)) {
            Calendar cal = this.getDateField(ogrFeature, idx);
            return cal.getTime();
        }
        throw new IllegalArgumentException("Don't know how to read " + clazz.getName() + " fields");
    }

    private Calendar getDateField(Object ogrFeature, Integer idx) {
        int[] year = new int[1];
        int[] month = new int[1];
        int[] day = new int[1];
        int[] hour = new int[1];
        int[] minute = new int[1];
        int[] second = new int[1];
        int[] timeZone = new int[1];
        this.ogr.FeatureGetFieldAsDateTime(ogrFeature, idx, year, month, day, hour, minute, second, timeZone);
        Calendar cal = Calendar.getInstance();
        int tz = timeZone[0];
        if (tz != 0 && tz != 1) {
            int offset = tz - 25;
            if (offset < 0) {
                cal.setTimeZone(TimeZone.getTimeZone("GMT" + offset));
            } else if (offset == 0) {
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                cal.setTimeZone(TimeZone.getTimeZone("GMT+" + offset));
            }
        }
        cal.clear();
        cal.set(1, year[0]);
        cal.set(2, month[0]);
        cal.set(5, day[0]);
        cal.set(11, hour[0]);
        cal.set(12, minute[0]);
        cal.set(13, second[0]);
        return cal;
    }

    String convertOGRFID(SimpleFeatureType schema, Object ogrFeature) {
        long id = this.ogr.FeatureGetFID(ogrFeature);
        return schema.getTypeName() + "." + id;
    }

    long convertGTFID(SimpleFeature feature) {
        String id = feature.getID();
        return Long.parseLong(id.substring(id.indexOf(".") + 1));
    }
}

