/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import org.geotools.data.ogr.GeometryMapper;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.data.ogr.TestCaseSupport;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;

public abstract class GeometryMapperTest
extends TestCaseSupport {
    GeometryFactory gf = new GeometryFactory();

    protected GeometryMapperTest(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        super(dataStoreFactoryClass);
    }

    public void testLine() throws Exception {
        this.checkRoundTrip("LINESTRING(0 0, 10 10)");
    }

    public void testPolygon() throws Exception {
        this.checkRoundTrip("POLYGON((0 0, 0 10, 10 10, 10 0, 0 0))");
    }

    public void testPoint() throws Exception {
        this.checkRoundTrip("POINT(0 0)");
    }

    void checkRoundTrip(String geometryWkt) throws Exception {
        this.checkRoundTrip(geometryWkt, (GeometryMapper)new GeometryMapper.WKB(this.gf, this.dataStoreFactory.createOGR()));
        this.checkRoundTrip(geometryWkt, (GeometryMapper)new GeometryMapper.WKT(this.gf, this.dataStoreFactory.createOGR()));
    }

    void checkRoundTrip(String geometryWkt, GeometryMapper mapper) throws Exception {
        Geometry geometry = new WKTReader().read(geometryWkt);
        OGR ogr = this.dataStoreFactory.createOGR();
        Object ogrGeometry = mapper.parseGTGeometry(geometry);
        Geometry remapped = mapper.parseOgrGeometry(ogrGeometry);
        ogr.GeometryDestroy(ogrGeometry);
        GeometryMapperTest.assertEquals((Object)geometry, (Object)remapped);
    }
}

