/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.TestData;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDataStoreFactory;
import org.geotools.data.ogr.TestCaseSupport;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;

public abstract class OGRDataStoreTest
extends TestCaseSupport {
    static final Logger LOGGER = Logging.getLogger(OGRDataStoreTest.class);
    private List<OGRDataStore> stores = new ArrayList<OGRDataStore>();

    protected OGRDataStoreTest(Class<? extends OGRDataStoreFactory> dataStoreFactoryClass) {
        super(dataStoreFactoryClass);
    }

    @Override
    protected void tearDown() throws Exception {
        for (OGRDataStore store : this.stores) {
            store.dispose();
        }
    }

    public void testGetTypeNames() throws FileNotFoundException, IOException {
        OGRDataStore store = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        OGRDataStoreTest.assertEquals((int)1, (int)store.getTypeNames().length);
        OGRDataStoreTest.assertEquals((String)"statepop", (String)store.getTypeNames()[0]);
        store = this.createDataStore(this.getAbsolutePath("mif/mixed.MIF"), null);
        OGRDataStoreTest.assertEquals((int)1, (int)store.getTypeNames().length);
        OGRDataStoreTest.assertEquals((String)"mixed", (String)store.getTypeNames()[0]);
    }

    public void testSchemaPop() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        SimpleFeatureType schema = s.getSchema(s.getTypeNames()[0]);
        OGRDataStoreTest.assertEquals((String)"Number of Attributes", (int)253, (int)schema.getAttributeCount());
        OGRDataStoreTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4269", (boolean)true), (Object)schema.getGeometryDescriptor().getCoordinateReferenceSystem()));
    }

    public void testSchemaMix() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("mif/mixed.MIF"), null);
        SimpleFeatureType schema = s.getSchema(s.getTypeNames()[0]);
        OGRDataStoreTest.assertEquals((String)"Number of Attributes", (int)11, (int)schema.getAttributeCount());
        OGRDataStoreTest.assertEquals(Geometry.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
    }

    public void testOptimizedEnvelope() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        ReferencedEnvelope expectedBounds = sds.getFeatureSource().getBounds();
        ReferencedEnvelope actualBounds = s.getFeatureSource(typeName).getBounds();
        OGRDataStoreTest.assertEquals((Object)expectedBounds, (Object)actualBounds);
        OGRDataStoreTest.assertNotNull((Object)actualBounds);
    }

    public void testCountWithOffsetLimit() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        ContentFeatureSource featureSource = s.getFeatureSource(typeName);
        Query query = new Query();
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        OGRDataStoreTest.assertEquals((int)1, (int)featureSource.getCount(query));
    }

    public void testOptimizedCount() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        String typeName = s.getTypeNames()[0];
        OGRDataStoreTest.assertEquals((long)sds.getCount(Query.ALL), (long)s.getFeatureSource(typeName).getCount(Query.ALL));
    }

    public void testLoadAndVerify() throws Exception {
        SimpleFeatureCollection features = this.loadFeatures("shapes/statepop.shp", Query.ALL);
        int count = features.size();
        OGRDataStoreTest.assertTrue((String)"Have features", (count > 0 ? 1 : 0) != 0);
        OGRDataStoreTest.assertEquals((String)"Number of Features loaded", (int)49, (int)features.size());
        OGRDataStoreTest.assertEquals((int)49, (int)this.countFeatures(features));
        SimpleFeatureType schema = this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getFeatureType();
        OGRDataStoreTest.assertNotNull((Object)schema.getGeometryDescriptor());
        OGRDataStoreTest.assertEquals((String)"Number of Attributes", (int)253, (int)schema.getAttributeCount());
        OGRDataStoreTest.assertEquals((String)"Value of statename is wrong", (Object)this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getAttribute("STATE_NAME"), (Object)"Illinois");
        OGRDataStoreTest.assertEquals((String)"Value of land area is wrong", (double)((Double)this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getAttribute("LAND_KM")), (double)143986.61, (double)0.001);
    }

    public void testLoadAndCheckParentTypeIsPolygon() throws Exception {
        SimpleFeatureCollection features = this.loadFeatures("shapes/statepop.shp", Query.ALL);
        SimpleFeatureType schema = this.firstFeature((FeatureCollection<SimpleFeatureType, SimpleFeature>)features).getFeatureType();
        OGRDataStoreTest.assertEquals((Object)schema.getSuper(), (Object)BasicFeatureTypes.POLYGON);
    }

    public void testShapefileComparison() throws Exception {
        URL url = TestData.url((String)"shapes/statepop.shp");
        ShapefileDataStore sds = new ShapefileDataStore(url);
        OGRDataStore ods = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        this.assertFeatureTypeEquals(sds.getSchema(), ods.getSchema(sds.getSchema().getTypeName()));
        Query query = new Query(sds.getSchema().getTypeName());
        FeatureReader sfr = sds.getFeatureReader(query, Transaction.AUTO_COMMIT);
        FeatureReader ofr = ods.getFeatureReader(query, Transaction.AUTO_COMMIT);
        SimpleFeature sf = null;
        SimpleFeature of = null;
        block0: while (true) {
            if (!sfr.hasNext()) {
                OGRDataStoreTest.assertTrue((!ofr.hasNext() ? 1 : 0) != 0);
                break;
            }
            sf = (SimpleFeature)sfr.next();
            of = (SimpleFeature)ofr.next();
            int i = 0;
            while (true) {
                if (i >= sds.getSchema().getAttributeCount()) continue block0;
                Object shapeAtt = sf.getAttribute(i);
                Object ogrAtt = of.getAttribute(i);
                OGRDataStoreTest.assertEquals((Object)shapeAtt, (Object)ogrAtt);
                ++i;
            }
            break;
        }
        sfr.close();
        ofr.close();
        sds.dispose();
        ods.dispose();
    }

    public void testLoadGeometry() throws Exception {
        OGRDataStore ods = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = ods.getFeatureSource("statepop");
        Query query = new Query("statepop");
        query.setPropertyNames(new String[]{"the_geom"});
        SimpleFeatureCollection fc = fs.getFeatures(query);
        OGRDataStoreTest.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        OGRDataStoreTest.assertEquals((int)1, (int)schema.getDescriptors().size());
        OGRDataStoreTest.assertEquals(MultiPolygon.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
        SimpleFeatureIterator fi = fc.features();
        SimpleFeature feature = (SimpleFeature)fi.next();
        fi.close();
        schema = feature.getFeatureType();
        OGRDataStoreTest.assertEquals((int)1, (int)schema.getDescriptors().size());
        OGRDataStoreTest.assertEquals(MultiPolygon.class, (Object)schema.getGeometryDescriptor().getType().getBinding());
        OGRDataStoreTest.assertNotNull((Object)feature.getDefaultGeometry());
    }

    private void assertFeatureTypeEquals(SimpleFeatureType type1, SimpleFeatureType type2) {
        OGRDataStoreTest.assertEquals((String)type1.getTypeName(), (String)type2.getTypeName());
        OGRDataStoreTest.assertEquals((Object)type1.getSuper(), (Object)type2.getSuper());
        OGRDataStoreTest.assertEquals((int)type1.getAttributeCount(), (int)type2.getAttributeCount());
        for (int i = 0; i < type1.getAttributeCount(); ++i) {
            AttributeDescriptor ad1 = type1.getDescriptor(i);
            AttributeDescriptor ad2 = type2.getDescriptor(i);
            OGRDataStoreTest.assertEquals((Object)ad1.getName(), (Object)ad2.getName());
            OGRDataStoreTest.assertEquals((Object)ad1.getType().getBinding(), (Object)ad2.getType().getBinding());
            OGRDataStoreTest.assertEquals((boolean)ad1.isNillable(), (boolean)ad2.isNillable());
            OGRDataStoreTest.assertEquals((int)ad1.getMinOccurs(), (int)ad2.getMinOccurs());
            OGRDataStoreTest.assertEquals((int)ad1.getMaxOccurs(), (int)ad2.getMaxOccurs());
            if (!(ad1 instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd1 = (GeometryDescriptor)ad1;
            GeometryDescriptor gd2 = (GeometryDescriptor)ad2;
            OGRDataStoreTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)gd1.getCoordinateReferenceSystem(), (Object)gd2.getCoordinateReferenceSystem()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveFromFrontAndClose() throws Throwable {
        OGRDataStore sds = this.createDataStore();
        String typeName = sds.getTypeNames()[0];
        int idx = this.loadFeatures((DataStore)sds, typeName).size();
        while (idx > 0) {
            FeatureWriter writer = null;
            try {
                writer = sds.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
                writer.next();
                writer.remove();
            }
            finally {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
            }
            OGRDataStoreTest.assertEquals((int)(--idx), (int)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveFromBackAndClose() throws Throwable {
        OGRDataStore sds = this.createDataStore();
        String typeName = sds.getTypeNames()[0];
        int idx = this.loadFeatures((DataStore)sds, typeName).size();
        OGRDataStoreTest.assertEquals((int)idx, (int)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        while (idx > 0) {
            try (FeatureWriter writer = null;){
                writer = sds.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
                while (writer.hasNext()) {
                    writer.next();
                }
                writer.remove();
            }
            OGRDataStoreTest.assertEquals((int)(--idx), (int)this.countFeatures(this.loadFeatures((DataStore)sds, typeName)));
        }
    }

    public void testCreateSchema() throws Exception {
        String[] fileNames = this.shapeFileNames("test");
        this.cleanFiles(fileNames);
        String absolutePath = new File(fileNames[0]).getAbsolutePath();
        OGRDataStore ds = this.createDataStore(absolutePath, "ESRI shapefile");
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)"geom:MultiPolygon,count:int,level1:double,level2:float,chars:string");
        ds.createSchema(schema);
        OGRDataStoreTest.assertEquals((int)1, (int)ds.getTypeNames().length);
        OGRDataStoreTest.assertEquals((String)"test", (String)ds.getTypeNames()[0]);
        SimpleFeatureType ogrSchema = ds.getSchema(ds.getTypeNames()[0]);
        OGRDataStoreTest.assertEquals((Object)schema.getGeometryDescriptor().getType().getBinding(), (Object)ogrSchema.getGeometryDescriptor().getType().getBinding());
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor at = schema.getDescriptor(i);
            if (at == schema.getGeometryDescriptor()) continue;
            OGRDataStoreTest.assertEquals((Object)at.getName(), (Object)ogrSchema.getDescriptor(i).getName());
            OGRDataStoreTest.assertEquals((String)("Wrong type for attribute " + at.getName()), (Object)at.getType().getBinding(), (Object)ogrSchema.getDescriptor(i).getType().getBinding());
        }
    }

    public void testCreateWriteRead() throws Exception {
        String typeName = "testw";
        String[] files = this.shapeFileNames(typeName);
        this.cleanFiles(files);
        File file = new File(files[0]);
        OGRDataStore ds = this.createDataStore(file.getAbsolutePath(), "ESRI shapefile");
        SimpleFeatureType schema = DataUtilities.createType((String)typeName, (String)"geom:Point,cat:int,name:string");
        ds.createSchema(schema);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature[] features = new SimpleFeature[20];
        for (int i = 0; i < features.length; ++i) {
            features[i] = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{gf.createPoint(new Coordinate((double)i, (double)i)), i, "" + i}, null);
        }
        FeatureWriter writer = ds.getFeatureWriterAppend("testw", Transaction.AUTO_COMMIT);
        for (int i = 0; i < features.length; ++i) {
            OGRDataStoreTest.assertFalse((boolean)writer.hasNext());
            SimpleFeature f = (SimpleFeature)writer.next();
            f.setAttributes(features[i].getAttributes());
            writer.write();
        }
        writer.close();
        FeatureReader reader = ds.getFeatureReader(new Query("testw"), null);
        for (int i = 0; i < features.length; ++i) {
            OGRDataStoreTest.assertTrue((boolean)reader.hasNext());
            SimpleFeature f = (SimpleFeature)reader.next();
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                if (f.getAttribute(j) instanceof Geometry) {
                    Geometry a = (Geometry)f.getAttribute(j);
                    Geometry b = (Geometry)features[i].getAttribute(j);
                    OGRDataStoreTest.assertTrue((boolean)a.equals(b));
                    continue;
                }
                OGRDataStoreTest.assertEquals((Object)f.getAttribute(j), (Object)features[i].getAttribute(j));
            }
        }
        OGRDataStoreTest.assertFalse((boolean)reader.hasNext());
        reader.close();
    }

    public void testAttributesWritingShapefile() throws Exception {
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-shp", ".shp");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "ESRI shapefile");
        this.writeFeatures((DataStore)s, (FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingGeoJSON() throws Exception {
        if (!this.ogrSupports("GeoJSON")) {
            LOGGER.warning("Skipping GeoJSON writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-geojson", ".json");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GeoJSON");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource(s.getTypeNames()[0]).getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingCsv() throws Exception {
        if (!this.ogrSupports("CSV")) {
            LOGGER.warning("Skipping CSV writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-csv", ".csv");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "CSV");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"GEOMETRY=AS_WKT"});
        OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        String typeName = tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".csv"));
        ContentFeatureCollection fc = s.getFeatureSource(typeName).getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingGmt() throws Exception {
        if (!this.ogrSupports("GMT")) {
            LOGGER.warning("Skipping GMT writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gmt", ".gmt");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GMT");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        String typeName = tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".gmt"));
        ContentFeatureCollection fc = s.getFeatureSource(typeName).getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingGpx() throws Exception {
        if (!this.ogrSupports("GPX")) {
            LOGGER.warning("Skipping GPX writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gpx", ".gpx");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GPX");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"GPX_USE_EXTENSIONS=YES"});
        try {
            OGRDataStoreTest.assertEquals((int)5, (int)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("waypoints").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingGML() throws Exception {
        if (!this.ogrSupports("GML")) {
            LOGGER.warning("Skipping GML writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-gml", ".gml");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GML");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingKML() throws Exception {
        if (!this.ogrSupports("KML")) {
            LOGGER.warning("Skipping KML writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-kml", ".kml");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "KML");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        try {
            OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingGeoRSS() throws Exception {
        if (!this.ogrSupports("GeoRSS")) {
            LOGGER.warning("Skipping GeoRSS writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-georss", ".rss");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "GeoRSS");
        s.createSchema((SimpleFeatureCollection)features, true, new String[]{"FORMAT=RSS", "GEOM_DIALECT=SIMPLE", "USE_EXTENSIONS=YES", "TITLE=f", "DESCRIPTION=f"});
        try {
            OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("OGR could not open")) {
                LOGGER.log(Level.WARNING, "OGR is missing some support library, test skipped", e);
                return;
            }
            throw e;
        }
        ContentFeatureCollection fc = s.getFeatureSource("georss").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    public void testAttributeFilters() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = s.getFeatureSource(s.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equal((Expression)ff.property("STATE_NAME"), (Expression)ff.literal((Object)"New York"), true);
        OGRDataStoreTest.assertEquals((int)1, (int)fs.getFeatures((Filter)f).size());
        f = ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal(10000000));
        OGRDataStoreTest.assertEquals((int)6, (int)fs.getFeatures((Filter)f).size());
        f = ff.and((Filter)f, (Filter)ff.like((Expression)ff.property("STATE_NAME"), "C*"));
        OGRDataStoreTest.assertEquals((int)1, (int)fs.getFeatures((Filter)f).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingSqlite() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-sql", ".sqlite");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingSqliteWithSorting() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollection();
        File tmpFile = this.getTempFile("test-sql", ".sqlite");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Query query = new Query();
        query.setSortBy(new SortBy[]{ff.sort("float", SortOrder.ASCENDING)});
        ContentFeatureCollection fc = s.getFeatureSource("junk").getFeatures(query);
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributesWritingSqliteFromUpperCaseAttributes() throws Exception {
        if (!this.ogrSupports("SQLite")) {
            LOGGER.warning("Skipping SQLite writing test as OGR was not built to support it");
            return;
        }
        ListFeatureCollection features = this.createFeatureCollectionWithUpperCaseAttributes();
        File tmpFile = this.getTempFile("test-sqlite", ".db");
        tmpFile.delete();
        OGRDataStore s = this.createDataStore(tmpFile.getAbsolutePath(), "SQLite");
        s.createSchema((SimpleFeatureCollection)features, true, null);
        OGRDataStoreTest.assertEquals((int)1, (int)s.getTypeNames().length);
        ContentFeatureCollection fc = s.getFeatureSource("points").getFeatures();
        OGRDataStoreTest.assertEquals((int)features.size(), (int)fc.size());
        int c = 0;
        try (SimpleFeatureIterator it = fc.features();){
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                OGRDataStoreTest.assertNotNull((Object)f);
                OGRDataStoreTest.assertNotNull((Object)f.getDefaultGeometry());
                OGRDataStoreTest.assertNotNull((Object)f.getAttribute("name"));
                ++c;
            }
        }
        OGRDataStoreTest.assertEquals((int)fc.size(), (int)c);
    }

    protected ListFeatureCollection createFeatureCollectionWithUpperCaseAttributes() throws Exception {
        SimpleFeatureTypeBuilder tbuilder = new SimpleFeatureTypeBuilder();
        tbuilder.setName("points");
        tbuilder.add("geom", Point.class);
        tbuilder.add("NAME", String.class);
        SimpleFeatureType type = tbuilder.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        ListFeatureCollection features = new ListFeatureCollection(type);
        int ii = 20;
        for (int i = 0; i < ii; ++i) {
            features.add(fb.buildFeature(null, new Object[]{new GeometryFactory().createPoint(new Coordinate(1.0, -1.0)), "Point" + String.valueOf(i)}));
        }
        return features;
    }

    public void testGeometryFilters() throws Exception {
        OGRDataStore s = this.createDataStore(this.getAbsolutePath("shapes/statepop.shp"), null);
        ContentFeatureSource fs = s.getFeatureSource(s.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX f = ff.bbox("the_geom", -75.102613, 40.212597, -72.361859, 41.512517, null);
        int numberOfFeatures = fs.getFeatures((Filter)f).size();
        OGRDataStoreTest.assertEquals((int)(s.ogr.IsGEOSEnabled() ? 4 : 5), (int)numberOfFeatures);
        f = ff.and((Filter)f, (Filter)ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal((Object)"10000000")));
        OGRDataStoreTest.assertEquals((int)6, (int)fs.getFeatures((Filter)f).size());
    }

    public void testGeot5588() throws Exception {
        String tabFile = this.getAbsolutePath("geot5588/geot5588a.tab");
        OGRDataStore s = this.createDataStore(tabFile, "MapInfo File");
        SimpleFeatureType schema = s.getSchema("geot5588a");
        OGRDataStoreTest.assertEquals(Short.class, (Object)schema.getDescriptor("byte_field").getType().getBinding());
        OGRDataStoreTest.assertEquals(Integer.class, (Object)schema.getDescriptor("short_field").getType().getBinding());
        OGRDataStoreTest.assertEquals(BigInteger.class, (Object)schema.getDescriptor("int_field_0").getType().getBinding());
        ContentFeatureSource fs = s.getFeatureSource("geot5588a");
        try (FeatureIterator iterator = fs.getFeatures().features();){
            OGRDataStoreTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            OGRDataStoreTest.assertEquals((Object)999, (Object)feature.getAttribute("byte_field"));
            OGRDataStoreTest.assertEquals((Object)99999, (Object)feature.getAttribute("short_field"));
            OGRDataStoreTest.assertEquals((Object)BigInteger.valueOf(257L), (Object)feature.getAttribute("int_field_0"));
            OGRDataStoreTest.assertFalse((boolean)iterator.hasNext());
        }
    }

    public OGRDataStore createDataStore(String tabFile, String s) throws IOException {
        OGRDataStore store = new OGRDataStore(tabFile, s, null, this.ogr);
        this.stores.add(store);
        return store;
    }

    private int countFeatures(SimpleFeatureCollection features) {
        int count = 0;
        try (SimpleFeatureIterator fi = features.features();){
            while (fi.hasNext()) {
                fi.next();
                ++count;
            }
        }
        return count;
    }

    protected SimpleFeatureCollection loadFeatures(String resource, Query query) throws Exception {
        SimpleFeatureSource fs = this.loadSource(resource, query);
        return fs.getFeatures(query);
    }

    private SimpleFeatureSource loadSource(String resource, Query query) throws IOException {
        OGRDataStoreTest.assertNotNull((Object)query);
        OGRDataStore s = this.createDataStore(this.getAbsolutePath(resource), null);
        return s.getFeatureSource(s.getTypeNames()[0]);
    }

    protected SimpleFeatureCollection loadFeatures(DataStore store, String typeName) throws Exception {
        SimpleFeatureSource fs = store.getFeatureSource(typeName);
        return fs.getFeatures();
    }

    protected ListFeatureCollection createFeatureCollection() throws Exception {
        SimpleFeatureTypeBuilder tbuilder = new SimpleFeatureTypeBuilder();
        tbuilder.setName("junk");
        tbuilder.add("point", Point.class);
        tbuilder.add("byte", Byte.class);
        tbuilder.add("short", Short.class);
        tbuilder.add("double", Double.class);
        tbuilder.add("float", Float.class);
        tbuilder.add("string", String.class);
        tbuilder.add("date", Date.class);
        tbuilder.add("boolean", Boolean.class);
        tbuilder.add("number", Number.class);
        tbuilder.add("long", Long.class);
        tbuilder.add("bigdecimal", BigDecimal.class);
        tbuilder.add("biginteger", BigInteger.class);
        SimpleFeatureType type = tbuilder.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        ListFeatureCollection features = new ListFeatureCollection(type);
        int ii = 20;
        for (int i = 0; i < ii; ++i) {
            features.add(fb.buildFeature(null, new Object[]{new GeometryFactory().createPoint(new Coordinate(1.0, -1.0)), (byte)i, (short)i, (double)i, Float.valueOf(i), new String(i + " "), new Date(i), true, 22, 1234567890123456789L, new BigDecimal(new BigInteger("12345678901234567890123456789"), 2), new BigInteger("12345678901234567890123456789")}));
        }
        return features;
    }

    private void writeFeatures(DataStore s, FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        s.createSchema((FeatureType)schema);
        FeatureWriter fw = s.getFeatureWriter(s.getTypeNames()[0], Transaction.AUTO_COMMIT);
        FeatureIterator it = fc.features();
        while (it.hasNext()) {
            SimpleFeature sf = (SimpleFeature)it.next();
            ((SimpleFeature)fw.next()).setAttributes(sf.getAttributes());
            fw.write();
        }
        it.close();
        fw.close();
    }

    private OGRDataStore createDataStore(File f) throws Exception {
        ListFeatureCollection fc = this.createFeatureCollection();
        f.delete();
        OGRDataStore sds = this.createDataStore(f.getAbsolutePath(), "ESRI shapefile");
        this.writeFeatures((DataStore)sds, (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc);
        return sds;
    }

    private OGRDataStore createDataStore() throws Exception {
        return this.createDataStore(this.getTempFile("test-shp", ".shp"));
    }

    private String[] shapeFileNames(String typeName) {
        typeName = "target/" + typeName;
        return new String[]{typeName + ".shp", typeName + ".dbf", typeName + ".shp", typeName + ".shx", typeName + ".prj"};
    }

    private void cleanFiles(String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            if (!f.exists()) continue;
            f.delete();
        }
    }
}

