/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.geotools.data.ogr.OGRDataStoreFactory;

class OGRDataSourcePool
implements AutoCloseable {
    protected final GenericObjectPool readOnlyPool;
    private final String ogrSourceName;
    private final String ogrDriver;
    private final OGR ogr;
    private long lastClear;
    private final boolean primeDataSources;

    public OGRDataSourcePool(OGR ogr, String ogrSourceName, String ogrDriver, Map params) throws IOException {
        this.ogrSourceName = ogrSourceName;
        this.ogrDriver = ogrDriver;
        this.ogr = ogr;
        this.lastClear = System.nanoTime();
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = (Integer)this.lookup(OGRDataStoreFactory.MAXCONN, params);
        config.minIdle = (Integer)this.lookup(OGRDataStoreFactory.MINCONN, params);
        config.maxWait = (long)((Integer)this.lookup(OGRDataStoreFactory.MAXWAIT, params)).intValue() * 1000L;
        config.minEvictableIdleTimeMillis = (long)((Integer)this.lookup(OGRDataStoreFactory.MIN_EVICTABLE_TIME, params)).intValue() * 1000L;
        config.numTestsPerEvictionRun = (Integer)this.lookup(OGRDataStoreFactory.EVICTOR_TESTS_PER_RUN, params);
        this.readOnlyPool = new GenericObjectPool((PoolableObjectFactory)new PooledDataSourceFactory(), config);
        this.primeDataSources = (Boolean)this.lookup(OGRDataStoreFactory.PRIME_DATASOURCE, params);
    }

    private Object lookup(DataAccessFactory.Param param, Map params) throws IOException {
        return Optional.ofNullable(param.lookUp(params)).orElse(param.getDefaultValue());
    }

    public OGRDataSource getDataSource(boolean update) throws IOException {
        OGRDataSource result;
        if (!update) {
            try {
                result = (OGRDataSource)this.readOnlyPool.borrowObject();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            Object source = this.getRawDataSource(true);
            if (source == null) {
                return null;
            }
            result = new OGRDataSource(this.ogr, this, source, update);
        }
        return result;
    }

    OGRDataSource openOrCreateDataSource(String[] options) throws IOException {
        Object source = null;
        try {
            source = this.getRawDataSource(true);
        }
        catch (IOException e) {
            if (this.ogrDriver != null) {
                Object driver = this.ogr.GetDriverByName(this.ogrDriver);
                if (driver != null) {
                    source = this.ogr.DriverCreateDataSource(driver, this.ogrSourceName, options);
                    this.ogr.DriverRelease(driver);
                }
                if (source == null) {
                    throw new IOException("Could not create OGR data source with driver " + this.ogrDriver + " and options " + Arrays.toString(options));
                }
            }
            throw new DataSourceException("Driver not provided, and could not open data source neither");
        }
        return new OGRDataSource(this.ogr, this, source, true);
    }

    private Object getRawDataSource(boolean update) throws IOException {
        Object ds;
        int mode;
        int n = mode = update ? 1 : 0;
        if (this.ogrDriver != null) {
            Object driver = this.ogr.GetDriverByName(this.ogrDriver);
            if (driver == null) {
                throw new IOException("Could not find a driver named " + driver);
            }
            ds = this.ogr.DriverOpen(driver, this.ogrSourceName, mode);
            if (ds == null) {
                throw new IOException("OGR could not open '" + this.ogrSourceName + "' in " + (update ? "read-write" : "read-only") + " mode with driver " + this.ogrDriver);
            }
        } else {
            ds = this.ogr.OpenShared(this.ogrSourceName, mode);
            if (ds == null) {
                throw new IOException("OGR could not open '" + this.ogrSourceName + "' in " + (update ? "read-write" : "read-only") + " mode");
            }
        }
        return ds;
    }

    @Override
    public void close() {
        try {
            this.readOnlyPool.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.lastClear = System.nanoTime();
        this.readOnlyPool.clear();
    }

    public void returnObject(OGRDataSource ogrDataSource) {
        if (ogrDataSource.update) {
            this.clear();
        }
        if (ogrDataSource.creationTime < this.lastClear || ogrDataSource.update) {
            ogrDataSource.destroy();
        } else {
            try {
                this.readOnlyPool.returnObject((Object)ogrDataSource);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private class PooledDataSourceFactory
    extends BasePoolableObjectFactory {
        private PooledDataSourceFactory() {
        }

        public Object makeObject() throws Exception {
            Object source = OGRDataSourcePool.this.getRawDataSource(false);
            OGRDataSource ds = new OGRDataSource(OGRDataSourcePool.this.ogr, OGRDataSourcePool.this, source, false);
            ds.setPrimeLayersEnabled(OGRDataSourcePool.this.primeDataSources);
            return ds;
        }

        public void destroyObject(Object obj) throws Exception {
            OGRDataSource ds = (OGRDataSource)obj;
            ds.destroy();
        }
    }
}

