/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.ogr.OGR;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class FeatureTypeMapper {
    OGR ogr;

    public FeatureTypeMapper(OGR ogr) {
        this.ogr = ogr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFeatureType getFeatureType(Object layer, String typeName, String namespaceURI) throws IOException {
        Object definition = null;
        try {
            Class<? extends Geometry> geometryBinding;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName(typeName);
            tb.setNamespaceURI(namespaceURI);
            if (tb.getNamespaceURI() == null) {
                tb.setNamespaceURI("http://www.opengis.net/gml");
            }
            if ((geometryBinding = this.getGeometryBinding(definition = this.ogr.LayerGetLayerDefn(layer))) != null) {
                CoordinateReferenceSystem crs = this.getCRS(layer);
                tb.add("the_geom", geometryBinding, crs);
            }
            int count = this.ogr.LayerGetFieldCount(definition);
            for (int i = 0; i < count; ++i) {
                Object field = this.ogr.LayerGetFieldDefn(definition, i);
                String name = this.ogr.FieldGetName(field);
                Class binding = this.getBinding(field);
                int width = this.ogr.FieldGetWidth(field);
                if (width > 0) {
                    tb.length(width);
                }
                tb.add(name, binding);
            }
            if (geometryBinding == Point.class || geometryBinding == MultiPoint.class) {
                tb.setSuperType(BasicFeatureTypes.POINT);
            } else if (geometryBinding == Polygon.class || geometryBinding == MultiPolygon.class) {
                tb.setSuperType(BasicFeatureTypes.POLYGON);
            } else if (geometryBinding == LineString.class || geometryBinding == MultiLineString.class) {
                tb.setSuperType(BasicFeatureTypes.LINE);
            }
            SimpleFeatureType simpleFeatureType = tb.buildFeatureType();
            this.ogr.LayerReleaseLayerDefn(definition);
            return simpleFeatureType;
        }
        catch (Throwable throwable) {
            this.ogr.LayerReleaseLayerDefn(definition);
            throw throwable;
        }
    }

    private Class getBinding(Object field) {
        long type = this.ogr.FieldGetType(field);
        int width = this.ogr.FieldGetWidth(field);
        if (this.ogr.FieldIsIntegerType(type)) {
            if (width == 0) {
                return BigInteger.class;
            }
            if (width < 3) {
                return Byte.class;
            }
            if (width < 5) {
                return Short.class;
            }
            if (width < 10) {
                return Integer.class;
            }
            if (width < 19) {
                return Long.class;
            }
            return BigInteger.class;
        }
        if (this.ogr.FieldIsIntegerListType(type)) {
            return int[].class;
        }
        if (this.ogr.FieldIsRealType(type)) {
            if (width <= 12) {
                return Float.class;
            }
            if (width <= 22) {
                return Double.class;
            }
            return BigDecimal.class;
        }
        if (this.ogr.FieldIsRealListType(type)) {
            return double[].class;
        }
        if (this.ogr.FieldIsBinaryType(type)) {
            return byte[].class;
        }
        if (this.ogr.FieldIsDateType(type)) {
            return Date.class;
        }
        if (this.ogr.FieldIsTimeType(type)) {
            return Time.class;
        }
        if (this.ogr.FieldIsDateTimeType(type)) {
            return Timestamp.class;
        }
        return String.class;
    }

    public Object getOGRFieldDefinition(AttributeDescriptor ad) throws IOException {
        Object def;
        Class type = ad.getType().getBinding();
        String name = ad.getLocalName();
        if (Boolean.class.equals((Object)type)) {
            def = this.ogr.CreateStringField(name);
            this.ogr.FieldSetWidth(def, 5);
        } else if (Byte.class.equals((Object)type)) {
            def = this.ogr.CreateIntegerField(name);
            this.ogr.FieldSetWidth(def, 3);
            this.ogr.FieldSetJustifyRight(def);
        } else if (Short.class.equals((Object)type)) {
            def = this.ogr.CreateIntegerField(name);
            this.ogr.FieldSetWidth(def, 5);
            this.ogr.FieldSetJustifyRight(def);
        } else if (Integer.class.equals((Object)type)) {
            def = this.ogr.CreateIntegerField(name);
            this.ogr.FieldSetWidth(def, 9);
            this.ogr.FieldSetJustifyRight(def);
        } else if (Long.class.equals((Object)type)) {
            def = this.ogr.CreateIntegerField(name);
            this.ogr.FieldSetWidth(def, 19);
            this.ogr.FieldSetJustifyRight(def);
        } else if (BigInteger.class.equals((Object)type)) {
            def = this.ogr.CreateIntegerField(name);
            this.ogr.FieldSetWidth(def, 32);
            this.ogr.FieldSetJustifyRight(def);
        } else if (BigDecimal.class.equals((Object)type)) {
            def = this.ogr.CreateRealField(name);
            this.ogr.FieldSetWidth(def, 32);
            this.ogr.FieldSetPrecision(def, 15);
            this.ogr.FieldSetJustifyRight(def);
        } else if (Float.class.equals((Object)type)) {
            def = this.ogr.CreateRealField(name);
            this.ogr.FieldSetWidth(def, 12);
            this.ogr.FieldSetPrecision(def, 7);
            this.ogr.FieldSetJustifyRight(def);
        } else if (Double.class.equals((Object)type) || Number.class.isAssignableFrom(type)) {
            def = this.ogr.CreateRealField(name);
            this.ogr.FieldSetWidth(def, 22);
            this.ogr.FieldSetPrecision(def, 16);
            this.ogr.FieldSetJustifyRight(def);
        } else if (String.class.equals((Object)type)) {
            def = this.ogr.CreateStringField(name);
            int length = FeatureTypes.getFieldLength((PropertyDescriptor)ad);
            if (length <= 0) {
                length = 255;
            }
            this.ogr.FieldSetWidth(def, length);
        } else if (byte[].class.equals((Object)type)) {
            def = this.ogr.CreateBinaryField(name);
        } else if (Date.class.isAssignableFrom(type)) {
            def = this.ogr.CreateDateField(name);
        } else if (Time.class.isAssignableFrom(type)) {
            def = this.ogr.CreateTimeField(name);
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            def = this.ogr.CreateDateTimeField(name);
        } else {
            throw new IOException("Cannot map " + type + " to an OGR type");
        }
        return def;
    }

    public long getOGRGeometryType(GeometryDescriptor descriptor) throws IOException {
        Class binding = descriptor.getType().getBinding();
        if (GeometryCollection.class.isAssignableFrom(binding)) {
            if (MultiPoint.class.isAssignableFrom(binding)) {
                return this.ogr.GetMultiPointType();
            }
            if (MultiLineString.class.isAssignableFrom(binding)) {
                return this.ogr.GetMultiLineStringType();
            }
            if (MultiPolygon.class.isAssignableFrom(binding)) {
                return this.ogr.GetMultiPolygonType();
            }
            return this.ogr.GetGeometryCollectionType();
        }
        if (Point.class.isAssignableFrom(binding)) {
            return this.ogr.GetPointType();
        }
        if (LinearRing.class.isAssignableFrom(binding)) {
            return this.ogr.GetLinearRingType();
        }
        if (LineString.class.isAssignableFrom(binding)) {
            return this.ogr.GetLineStringType();
        }
        if (Polygon.class.isAssignableFrom(binding)) {
            return this.ogr.GetPolygonType();
        }
        return this.ogr.GetGeometryUnknownType();
    }

    private Class<? extends Geometry> getGeometryBinding(Object definition) throws IOException {
        long value = this.ogr.LayerGetGeometryType(definition);
        if (value == this.ogr.GetPointType() || value == this.ogr.GetPoint25DType()) {
            return Point.class;
        }
        if (value == this.ogr.GetLinearRingType()) {
            return LinearRing.class;
        }
        if (value == this.ogr.GetLineStringType() || value == this.ogr.GetLineString25DType() || value == this.ogr.GetMultiLineStringType() || value == this.ogr.GetMultiLineString25DType()) {
            return MultiLineString.class;
        }
        if (value == this.ogr.GetPolygonType() || value == this.ogr.GetPolygon25DType() || value == this.ogr.GetMultiPolygonType() || value == this.ogr.GetMultiPolygon25DType()) {
            return MultiPolygon.class;
        }
        if (value == this.ogr.GetGeometryCollectionType() || value == this.ogr.GetGeometryCollection25DType()) {
            return GeometryCollection.class;
        }
        if (value == this.ogr.GetGeometryNoneType()) {
            return null;
        }
        if (value == this.ogr.GetGeometryUnknownType()) {
            return Geometry.class;
        }
        throw new IOException("Unknown geometry type: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem getCRS(Object layer) throws IOException {
        Object spatialReference = null;
        CoordinateReferenceSystem crs = null;
        try {
            spatialReference = this.ogr.LayerGetSpatialRef(layer);
            if (spatialReference == null) {
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                return coordinateReferenceSystem;
            }
            try {
                String code = this.ogr.SpatialRefGetAuthorityCode(spatialReference, "EPSG");
                if (code != null) {
                    String fullCode = "EPSG:" + code;
                    crs = CRS.decode((String)fullCode);
                }
            }
            catch (Exception code) {
                // empty catch block
            }
            if (crs == null) {
                try {
                    String wkt = this.ogr.SpatialRefExportToWkt(spatialReference);
                    crs = CRS.parseWKT((String)wkt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CoordinateReferenceSystem coordinateReferenceSystem = crs;
            return coordinateReferenceSystem;
        }
        finally {
            if (spatialReference != null) {
                this.ogr.SpatialRefRelease(spatialReference);
            }
        }
    }

    public Object getSpatialReference(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        String wkt = crs.toString();
        return this.ogr.NewSpatialRef(wkt);
    }
}

