/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.OGRDataSource;
import org.geotools.data.ogr.OGRDataStore;
import org.geotools.data.ogr.OGRDirectFeatureWriter;
import org.geotools.data.ogr.OGRFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.GeometryFactory;

class OGRFeatureStore
extends ContentFeatureStore {
    OGRFeatureSource delegate;
    OGR ogr;

    public OGRFeatureStore(ContentEntry entry, Query query, OGR ogr) {
        super(entry, query);
        this.delegate = new OGRFeatureSource(entry, query, ogr);
        this.ogr = ogr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        OGRDataSource dataSource = null;
        Object layer = null;
        boolean cleanup = true;
        try {
            String typeName = this.getEntry().getTypeName();
            dataSource = this.getDataStore().openOGRDataSource(true);
            layer = this.getDataStore().openOGRLayer(dataSource, typeName, false);
            FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.delegate.getReaderInternal(dataSource, layer, query);
            GeometryFactory gf = this.delegate.getGeometryFactory(query);
            OGRDirectFeatureWriter result = new OGRDirectFeatureWriter(dataSource, layer, reader, this.getSchema(), gf, this.ogr);
            cleanup = false;
            OGRDirectFeatureWriter oGRDirectFeatureWriter = result;
            if (cleanup) {
                this.ogr.LayerRelease(layer);
                dataSource.close();
            }
            return oGRDirectFeatureWriter;
        }
        catch (Throwable throwable) {
            if (cleanup) {
                this.ogr.LayerRelease(layer);
                dataSource.close();
            }
            throw throwable;
        }
    }

    public OGRDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public ContentState getState() {
        return this.delegate.getState();
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    protected boolean canFilter(Query query) {
        return this.delegate.canFilter(query);
    }

    protected boolean canSort(Query query) {
        return this.delegate.canSort(query);
    }

    protected boolean canRetype(Query query) {
        return this.delegate.canRetype(query);
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }
}

