/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.referencing.operation;

import java.util.concurrent.Callable;
import org.opengis.referencing.operation.MathTransform;

public class TransformException
extends Exception {
    private static final long serialVersionUID = -8923944544398567533L;
    static final ThreadLocal<Boolean> FILL_STACK_TRACE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private MathTransform lastCompletedTransform;

    public TransformException() {
    }

    public TransformException(String message) {
        super(message);
    }

    public TransformException(String message, Throwable cause) {
        super(message, cause);
    }

    public MathTransform getLastCompletedTransform() {
        return this.lastCompletedTransform;
    }

    public void setLastCompletedTransform(MathTransform transform) {
        this.lastCompletedTransform = transform;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (FILL_STACK_TRACE.get().booleanValue()) {
            return super.fillInStackTrace();
        }
        return this;
    }

    public static <T> T runWithoutStackTraces(Callable<T> callable) {
        FILL_STACK_TRACE.set(Boolean.FALSE);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            FILL_STACK_TRACE.remove();
        }
    }
}

