/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.pgraster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.media.jai.TiledImage;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.pgraster.ReadRequest;
import org.geotools.gce.pgraster.Tile;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.locationtech.jts.geom.Envelope;

class Mosaic {
    final ReadRequest read;
    final GridCoverageFactory factory;
    Dimension size;
    Point2D.Double rescale;
    BufferedImage image;
    Envelope bounds;

    public Mosaic(ReadRequest read, GridCoverageFactory factory) {
        this.read = read;
        this.factory = factory;
        this.rescale = new Point2D.Double(read.raster.scale.x / read.resolution.x, read.raster.scale.y / read.resolution.y);
        this.size = new Dimension((int)Math.round((double)read.region.width / this.rescale.x), (int)Math.round((double)read.region.height / this.rescale.y));
        this.bounds = new Envelope();
        this.bounds.setToNull();
    }

    public void accept(Tile tile) {
        if (this.image == null) {
            this.image = this.initImage(tile);
            this.fillBackground(this.image);
        }
        int x = (int)((tile.bounds.getMinX() - this.read.nativeBounds.getMinX()) / this.read.raster.scale.x);
        int y = (int)((this.read.nativeBounds.getMaxY() - tile.bounds.getMaxY()) / this.read.raster.scale.y);
        this.image.getRaster().setRect(x, y, tile.image.getRaster());
        this.bounds.expandToInclude(tile.bounds);
    }

    BufferedImage initImage(Tile tile) {
        BufferedImage from = tile.image;
        Hashtable<String, Object> props = null;
        if (from.getPropertyNames() != null) {
            props = new Hashtable<String, Object>();
            for (String name : from.getPropertyNames()) {
                props.put(name, from.getProperty(name));
            }
        }
        SampleModel sm = from.getSampleModel().createCompatibleSampleModel((int)this.size.getWidth(), (int)this.size.getHeight());
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        ColorModel colorModel = from.getColorModel();
        return new BufferedImage(colorModel, raster, from.isAlphaPremultiplied(), props);
    }

    BufferedImage initImage(int type) {
        return new BufferedImage((int)this.size.getWidth(), (int)this.size.getHeight(), type);
    }

    void fillBackground(BufferedImage image) {
        if (this.read.backgroundColor != null) {
            Graphics2D g = (Graphics2D)image.getGraphics();
            Color current = g.getColor();
            g.setColor(this.read.backgroundColor);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            g.setColor(current);
        }
    }

    public GridCoverage2D coverage() {
        if (this.image == null) {
            return null;
        }
        RenderedImage finalImage = this.rescale(this.image);
        ReferencedEnvelope mapBounds = this.read.nativeBounds;
        if (mapBounds.covers(this.bounds)) {
            int x = (int)((double)finalImage.getWidth() * (this.bounds.getMinX() - mapBounds.getMinX()) / mapBounds.getWidth());
            int y = finalImage.getHeight() - (int)((double)finalImage.getHeight() * (this.bounds.getMaxY() - mapBounds.getMinY()) / mapBounds.getHeight());
            int h = (int)((double)finalImage.getHeight() * this.bounds.getHeight() / mapBounds.getHeight());
            int w = (int)((double)finalImage.getWidth() * this.bounds.getWidth() / mapBounds.getWidth());
            finalImage = this.crop(finalImage, x, y, w, h);
        }
        return this.factory.create((CharSequence)this.read.reader.name(), finalImage, (Bounds)new ReferencedEnvelope(this.bounds, mapBounds.getCoordinateReferenceSystem()));
    }

    RenderedImage crop(RenderedImage image, float x, float y, float w, float h) {
        return new ImageWorker(image).crop(x, y, w, h).getRenderedImage();
    }

    RenderedImage rescale(RenderedImage image) {
        TiledImage planar = new TiledImage(image, image.getWidth(), image.getHeight());
        ImageWorker w = new ImageWorker((RenderedImage)planar);
        w.scale((double)((float)this.rescale.x), (double)((float)this.rescale.y), 0.0, 0.0, this.read.interpolation());
        return w.getRenderedImage();
    }
}

