/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class Contours {
    private static final GeometryFactory GF = new GeometryFactory();
    private double[] levels;
    private boolean smooth = true;
    private boolean simplify = false;
    private ProgressListener progressListener;

    public SimpleFeatureCollection contour(FeatureCollection features, String elevation) {
        if (this.progressListener != null) {
            this.progressListener.started();
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        PointType ptype = PointType.Point;
        if (MultiPoint.class.equals((Object)features.getSchema().getGeometryDescriptor().getType().getBinding())) {
            ptype = PointType.MultiPoint;
        }
        try (SimpleFeatureIterator itr = (SimpleFeatureIterator)features.features();){
            while (itr.hasNext()) {
                SimpleFeature f = (SimpleFeature)itr.next();
                ArrayList<Point> points = new ArrayList<Point>();
                if (ptype == PointType.Point) {
                    points.add((Point)f.getDefaultGeometry());
                } else {
                    MultiPoint mp = (MultiPoint)f.getDefaultGeometry();
                    for (int i = 0; i < mp.getNumGeometries(); ++i) {
                        points.add((Point)mp.getGeometryN(i));
                    }
                }
                for (Point point : points) {
                    Coordinate coordinate = new Coordinate();
                    coordinate.setX(point.getCoordinate().x);
                    coordinate.setY(point.getCoordinate().y);
                    coordinate.setZ(((Number)f.getAttribute(elevation)).doubleValue());
                    coords.add(coordinate);
                }
            }
        }
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("contour");
        ftb.add("the_geom", LineString.class);
        ftb.add("elevation", Double.class);
        ftb.setCRS(features.getBounds().getCoordinateReferenceSystem());
        ftb.setDefaultGeometry("the_geom");
        SimpleFeatureType type = ftb.buildFeatureType();
        SimpleFeatureBuilder fBuilder = new SimpleFeatureBuilder(type);
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites(coords);
        QuadEdgeSubdivision quadEdgeSubdivision = builder.getSubdivision();
        List primaryEdges = quadEdgeSubdivision.getPrimaryEdges(false);
        ArrayList<SimpleFeature> feats = new ArrayList<SimpleFeature>();
        int percent = 1;
        int steps = this.levels.length;
        for (double contourValue : this.levels) {
            if (this.progressListener != null) {
                this.progressListener.progress((float)(100 / steps * percent));
            }
            ArrayList<LineString> lines = this.extractContour(primaryEdges, contourValue);
            MultiLineString ml = GF.createMultiLineString(lines.toArray(new LineString[0]));
            Geometry inter = ml.union();
            LineMerger merger = new LineMerger();
            for (int i = 0; i < inter.getNumGeometries(); ++i) {
                merger.add(inter.getGeometryN(i));
            }
            Collection collection = merger.getMergedLineStrings();
            for (LineString l : collection) {
                if (this.simplify) {
                    DouglasPeuckerSimplifier simplifier = new DouglasPeuckerSimplifier((Geometry)l);
                    l = (LineString)simplifier.getResultGeometry();
                }
                if (this.smooth) {
                    fBuilder.set("the_geom", (Object)JTS.smooth((Geometry)l, (double)0.4, (GeometryFactory)GF));
                } else {
                    fBuilder.set("the_geom", (Object)l);
                }
                fBuilder.set("elevation", (Object)contourValue);
                SimpleFeature f = fBuilder.buildFeature(null);
                feats.add(f);
            }
        }
        if (this.progressListener != null) {
            this.progressListener.complete();
        }
        return DataUtilities.collection(feats);
    }

    public ArrayList<LineString> extractContour(Collection<QuadEdge> primaryEdges, double contourValue) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (QuadEdge edge : primaryEdges) {
            int start;
            Vertex[] v = new Vertex[]{edge.orig(), edge.dest(), edge.oNext().dest()};
            ArrayList<Integer> low = new ArrayList<Integer>(3);
            ArrayList<Integer> high = new ArrayList<Integer>(3);
            for (int i = 0; i < 3; ++i) {
                if (v[i].getZ() < contourValue) {
                    low.add(i);
                    continue;
                }
                if (!(v[i].getZ() >= contourValue)) continue;
                high.add(i);
            }
            if (low.size() == 3 || high.size() == 3 || low.isEmpty() || high.isEmpty()) continue;
            QuadEdge[] edges = new QuadEdge[2];
            if (high.size() == 2 && low.size() == 1) {
                start = (Integer)low.get(0);
                edges[0] = QuadEdge.makeEdge((Vertex)v[start], (Vertex)v[(Integer)high.get(0)]);
                edges[1] = QuadEdge.makeEdge((Vertex)v[start], (Vertex)v[(Integer)high.get(1)]);
            } else {
                if (low.size() != 2 || high.size() != 1) continue;
                start = (Integer)high.get(0);
                edges[0] = QuadEdge.makeEdge((Vertex)v[(Integer)low.get(0)], (Vertex)v[start]);
                edges[1] = QuadEdge.makeEdge((Vertex)v[(Integer)low.get(1)], (Vertex)v[start]);
            }
            Coordinate[] pt = new Coordinate[2];
            for (int i = 0; i < 2; ++i) {
                double start2 = edges[i].orig().getZ();
                double end = edges[i].dest().getZ();
                LineSegment lineSegment = edges[i].toLineSegment();
                double delta = end - start2;
                double proportion = (contourValue - start2) / delta;
                pt[i] = lineSegment.pointAlong(proportion);
            }
            LineString l = GF.createLineString(pt);
            lines.add(l);
        }
        return lines;
    }

    public double[] getLevels() {
        return this.levels;
    }

    public void setLevels(double[] levels) {
        this.levels = levels;
    }

    public void setSmooth(boolean booleanValue) {
        this.smooth = booleanValue;
    }

    public void setSimplify(boolean booleanValue) {
        this.simplify = booleanValue;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private static enum PointType {
        Point,
        MultiPoint;

    }
}

