/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.ClipProcess;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="Rectangular Clip", description="Clips (crops) features to the specified rectangular extent")
public class RectangularClipProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Clipped feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="clip", description="Bounds of clipping rectangle") ReferencedEnvelope clip, @DescribeParameter(name="preserveZ", min=0, description="Attempt to preserve Z values from the original geometry (interpolate value for new points)") Boolean preserveZ) throws ProcessException {
        CoordinateReferenceSystem featuresCRS = ((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem();
        if (featuresCRS != null && clip.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)featuresCRS, (Object)clip.getCoordinateReferenceSystem())) {
            boolean lenient = true;
            try {
                clip = clip.transform(featuresCRS, lenient);
            }
            catch (FactoryException | TransformException e) {
                throw new ProcessException(e);
            }
        }
        return new ClipProcess().execute(features, (Geometry)JTS.toGeometry((ReferencedEnvelope)clip), preserveZ);
    }
}

