/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.List;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;

@DescribeProcess(title="Unique", description="Returns the unique values of a given attribute in a feature collection.")
public class UniqueProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Feature collection with an attribute containing the unique values")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="Attribute whose unique values are extracted") String attribute, ProgressListener progressListener) throws Exception {
        int attIndex = -1;
        List atts = ((SimpleFeatureType)features.getSchema()).getAttributeDescriptors();
        for (int i = 0; i < atts.size(); ++i) {
            if (!((AttributeDescriptor)atts.get(i)).getLocalName().equals(attribute)) continue;
            attIndex = i;
            break;
        }
        UniqueVisitor visitor = new UniqueVisitor(attIndex, (SimpleFeatureType)features.getSchema());
        features.accepts((FeatureVisitor)visitor, progressListener);
        List uniqueValues = visitor.getResult().toList();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("value", ((SimpleFeatureType)features.getSchema()).getDescriptor(attIndex).getType().getBinding());
        tb.setName("UniqueValue");
        SimpleFeatureType ft = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        ListFeatureCollection result = new ListFeatureCollection(ft);
        for (Object value : uniqueValues) {
            fb.add(value);
            result.add(fb.buildFeature(null));
        }
        return result;
    }
}

