/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import org.geotools.geometry.jts.GeometryBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;

public class Cell
implements Comparable<Cell> {
    private static final GeometryBuilder GB = new GeometryBuilder();
    private static final double SQRT2 = 1.4142135623730951;
    private double x;
    private double y;
    private double h;
    private double d;
    private double max;

    Cell(double x, double y, double h, MultiPolygon polygon) {
        this.setX(x);
        this.setY(y);
        this.setH(h);
        Point p = GB.point(x, y);
        this.setD(this.pointToPolygonDist(p, polygon));
        this.setMax(this.getD() + this.getH() * 1.4142135623730951);
    }

    @Override
    public int compareTo(Cell o) {
        return (int)(o.getMax() - this.getMax());
    }

    public Point getPoint() {
        return GB.point(this.x, this.y);
    }

    private double pointToPolygonDist(Point point, MultiPolygon polygon) {
        boolean inside = false;
        double minDistSq = Double.POSITIVE_INFINITY;
        for (int k = 0; k < polygon.getNumGeometries(); ++k) {
            Coordinate[] ring = polygon.getGeometryN(k).getCoordinates();
            int i = 0;
            int len = ring.length;
            int j = len - 1;
            while (i < len) {
                Coordinate a = ring[i];
                Coordinate b = ring[j];
                if (a.y > this.y != b.y > this.y && this.x < (b.x - a.x) * (this.y - a.y) / (b.y - a.y) + a.x) {
                    inside = !inside;
                }
                minDistSq = Math.min(minDistSq, this.getSegDistSq(this.x, this.y, a, b));
                j = i++;
            }
        }
        return (double)(inside ? 1 : -1) * Math.sqrt(minDistSq);
    }

    private double getSegDistSq(double px, double py, Coordinate a, Coordinate b) {
        double x = a.x;
        double y = a.y;
        double dx = b.x - x;
        double dy = b.y - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((px - x) * dx + (py - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = b.x;
                y = b.y;
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = px - x;
        dy = py - y;
        return dx * dx + dy * dy;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getH() {
        return this.h;
    }

    public void setH(double h) {
        this.h = h;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

