/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;

public class Skeletonize {
    private static final GeometryFactory GF = new GeometryFactory();
    private static final Logger LOG = Logger.getLogger("org.geotools.process.geometry.CentreLine");

    static Geometry getSkeleton(Geometry poly, double perc_tolerance) {
        Class<?> clazz = poly.getClass();
        if (MultiPolygon.class.isAssignableFrom(clazz)) {
            MultiPolygon multi = (MultiPolygon)poly;
            ArrayList<LineString> geoms = new ArrayList<LineString>();
            for (int i = 0; i < multi.getNumGeometries(); ++i) {
                Geometry skel = Skeletonize.getSkeleton((Polygon)multi.getGeometryN(i), perc_tolerance);
                if (skel instanceof LineString) {
                    geoms.add((LineString)skel);
                    continue;
                }
                if (skel instanceof MultiLineString) {
                    for (int k = 0; k < skel.getNumGeometries(); ++k) {
                        geoms.add((LineString)skel.getGeometryN(k));
                    }
                    continue;
                }
                LOG.info("Unexpected result type " + skel.getClass());
            }
            return GF.createMultiLineString(GeometryFactory.toLineStringArray(geoms));
        }
        if (Polygon.class.isAssignableFrom(clazz)) {
            return Skeletonize.getSkeleton((Polygon)poly, perc_tolerance);
        }
        LOG.info("Input Geometry was not an expected geometry (" + clazz + ")");
        return poly;
    }

    static Geometry getSkeleton(Geometry poly) {
        return Skeletonize.getSkeleton(poly, 5.0);
    }

    static Geometry getSkeleton(Polygon poly) {
        return Skeletonize.getSkeleton(poly, 5.0);
    }

    static Geometry getSkeleton(Polygon poly, double perc_tolerance) {
        double dist = poly.getLength() * (perc_tolerance / 100.0);
        Polygon vpoly = (Polygon)Densifier.densify((Geometry)poly, (double)dist);
        Geometry triangles = Skeletonize.getVoroni(vpoly);
        HashSet<LineString> edges = new HashSet<LineString>();
        LineMerger merger = new LineMerger();
        for (int i = 0; i < triangles.getNumGeometries(); ++i) {
            Polygon p = (Polygon)triangles.getGeometryN(i);
            LinearRing exteriorRing = p.getExteriorRing();
            for (int j = 1; j < exteriorRing.getNumPoints(); ++j) {
                Coordinate coordinate1 = exteriorRing.getPointN(j - 1).getCoordinate();
                Coordinate coordinate2 = exteriorRing.getPointN(j).getCoordinate();
                LineString edge = GF.createLineString(new Coordinate[]{coordinate1, coordinate2});
                if (!vpoly.contains((Geometry)edge)) continue;
                edges.add((LineString)edge.norm());
            }
        }
        merger.add(edges);
        MultiLineString geom = GF.createMultiLineString(GeometryFactory.toLineStringArray((Collection)merger.getMergedLineStrings()));
        geom = geom.union();
        LOG.fine(geom.toText());
        return geom;
    }

    static Geometry getVoroni(Polygon poly) {
        VoronoiDiagramBuilder builder = new VoronoiDiagramBuilder();
        builder.setSites((Geometry)poly);
        builder.setClipEnvelope(poly.getEnvelopeInternal());
        Geometry triangles = builder.getDiagram(GF);
        return triangles;
    }
}

