/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.io.IOException;
import java.lang.reflect.Array;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.Converters;
import org.opengis.parameter.ParameterValueGroup;

@DescribeProcess(title="Normalize Coverage", description="Normalizes a coverage by dividing values by the max value")
public class NormalizeCoverageProcess
implements RasterProcess {
    private final CoverageProcessor PROCESSOR = new CoverageProcessor();

    @DescribeResult(name="result", description="Normalized raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D coverage) throws IOException {
        ParameterValueGroup param = this.PROCESSOR.getOperation("Extrema").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        GridCoverage2D extrema = (GridCoverage2D)this.PROCESSOR.doOperation(param);
        Object max = extrema.getProperty("maximum");
        boolean allZero = true;
        for (int i = 0; i < Array.getLength(max); ++i) {
            Object num = Array.get(max, i);
            boolean isZero = num instanceof Number && ((Number)num).doubleValue() == 0.0;
            boolean bl = allZero = allZero && isZero;
            if (!isZero) continue;
            Array.set(max, i, Converters.convert((Object)1, num.getClass()));
        }
        if (allZero) {
            return coverage;
        }
        param = this.PROCESSOR.getOperation("DivideByConst").getParameters();
        param.parameter("source").setValue((Object)coverage);
        param.parameter("constants").setValue(max);
        return (GridCoverage2D)this.PROCESSOR.doOperation(param);
    }
}

