/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.process.RenderingProcess;
import org.geotools.process.function.ParameterFunction;
import org.geotools.process.function.ProcessFunction;
import org.geotools.process.function.RenderingProcessFunction;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class ProcessFunctionFactory
implements FunctionFactory {
    public static final String PRIMARY_OUTPUT = "PRIMARY";
    static final Comparator<ProcessFactory> FACTORY_COMPARATOR = (pf1, pf2) -> {
        if (pf1.getTitle() == null) {
            if (pf2.getTitle() == null) {
                return 0;
            }
            return -1;
        }
        if (pf2.getTitle() == null) {
            return 1;
        }
        return pf1.getTitle().compareTo((Object)pf2.getTitle());
    };
    HashMap<Name, FunctionName> processToFunction;
    private ArrayList<FunctionName> functionNames;

    public Function function(String name, List<Expression> args, Literal fallback) {
        return this.function((Name)new NameImpl(name), args, fallback);
    }

    public Function function(Name processName, List<Expression> args, Literal fallback) {
        if (processName.equals((Object)new NameImpl(ParameterFunction.NAME.getName()))) {
            return new ParameterFunction(fallback, args);
        }
        if (this.functionNames == null) {
            this.init();
        }
        if (!this.processToFunction.containsKey(processName)) {
            return null;
        }
        Process process = Processors.createProcess(processName);
        Map<String, Parameter<?>> parameters = Processors.getParameterInfo(processName);
        if (process instanceof RenderingProcess) {
            return new RenderingProcessFunction(processName, args, parameters, (RenderingProcess)process, fallback);
        }
        return new ProcessFunction(processName, args, parameters, process, fallback);
    }

    public List<FunctionName> getFunctionNames() {
        if (this.functionNames == null) {
            this.init();
        }
        return this.functionNames;
    }

    private synchronized void init() {
        if (this.functionNames == null) {
            ArrayList<ProcessFactory> factories = new ArrayList<ProcessFactory>(Processors.getProcessFactories());
            Collections.sort(factories, FACTORY_COMPARATOR);
            this.processToFunction = new HashMap();
            this.functionNames = new ArrayList();
            for (ProcessFactory factory : factories) {
                if (!factory.isAvailable()) continue;
                for (Name processName : factory.getNames()) {
                    try {
                        Map<String, Parameter<?>> resultInfo = factory.getResultInfo(processName, null);
                        Parameter<?> result = this.getPrimary(resultInfo);
                        if (result == null) continue;
                        Map<String, Parameter<?>> parameterInfo = factory.getParameterInfo(processName);
                        ArrayList<String> argumentNames = new ArrayList<String>(parameterInfo.keySet());
                        ArrayList<org.opengis.parameter.Parameter> args = new ArrayList<org.opengis.parameter.Parameter>(argumentNames.size());
                        for (String argumentName : argumentNames) {
                            args.add((org.opengis.parameter.Parameter)parameterInfo.get(argumentName));
                        }
                        FunctionNameImpl functionName = new FunctionNameImpl(processName, result, args);
                        this.functionNames.add((FunctionName)functionName);
                        this.processToFunction.put(processName, (FunctionName)functionName);
                    }
                    catch (Throwable unavailable) {
                        Logger log = Logger.getLogger(factory.getClass().getName());
                        log.finer("Process " + String.valueOf(processName) + " unavailable:" + String.valueOf(unavailable));
                    }
                }
            }
            this.functionNames.add(ParameterFunction.NAME);
        }
    }

    private Parameter<?> getPrimary(Map<String, Parameter<?>> resultInfo) {
        if (resultInfo == null) {
            return null;
        }
        if (resultInfo.size() == 1) {
            return resultInfo.values().iterator().next();
        }
        for (Parameter<?> param : resultInfo.values()) {
            if (!param.isRequired().booleanValue()) continue;
            return param;
        }
        return null;
    }

    public void clear() {
        this.functionNames = null;
        this.processToFunction = null;
    }
}

