/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.IOException;
import java.util.Set;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.property.PropertyFeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;

public class PropertyFeatureStore
extends ContentFeatureStore {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;
    PropertyFeatureSource delegate;

    PropertyFeatureStore(ContentEntry entry, Query query) throws IOException {
        super(entry, query);
        this.delegate = new PropertyFeatureSource(this.entry, this.query){

            public void setTransaction(Transaction transaction) {
                super.setTransaction(transaction);
                PropertyFeatureStore.this.setTransaction(transaction);
            }
        };
        this.store = (PropertyDataStore)entry.getDataStore();
        this.typeName = entry.getTypeName();
    }

    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.FEATURE_DETACHED);
    }

    protected boolean canEvent() {
        return false;
    }

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        return new PropertyFeatureWriter((ContentFeatureSource)this, this.getState(), query, (flags | 1) == 1);
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }

    public PropertyDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public ContentState getState() {
        return this.delegate.getState();
    }

    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }
}

