/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class CrsTest {
    @Test
    public void testSupportedAuthorities() {
        Set withoutAlias = CRS.getSupportedAuthorities((boolean)false);
        Assert.assertTrue((boolean)withoutAlias.contains("CRS"));
        Assert.assertTrue((boolean)withoutAlias.contains("AUTO2"));
        Assert.assertTrue((boolean)withoutAlias.contains("urn:ogc:def"));
        Assert.assertTrue((boolean)withoutAlias.contains("http://www.opengis.net/gml"));
        Assert.assertTrue((boolean)withoutAlias.contains("http://www.opengis.net/def"));
        Assert.assertFalse((boolean)withoutAlias.contains("AUTO"));
        Assert.assertFalse((boolean)withoutAlias.contains("urn:x-ogc:def"));
        Set withAlias = CRS.getSupportedAuthorities((boolean)true);
        Assert.assertTrue((boolean)withAlias.containsAll(withoutAlias));
        Assert.assertFalse((boolean)withoutAlias.containsAll(withAlias));
        Assert.assertTrue((boolean)withAlias.contains("AUTO"));
        Assert.assertTrue((boolean)withAlias.contains("urn:x-ogc:def"));
    }

    @Test
    public void testDecode() throws FactoryException {
        Assert.assertSame((Object)DefaultGeographicCRS.WGS84, (Object)CRS.decode((String)"WGS84(DD)"));
    }

    @Test
    @Ignore
    public void testESRICode() throws Exception {
        String wkt = "PROJCS[\"Albers_Conic_Equal_Area\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n    SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],\n    PRIMEM[\"Greenwich\",0.0],\n    UNIT[\"Degree\",0.0174532925199433]],\n  PROJECTION[\"Equidistant_Conic\"],\n  PARAMETER[\"False_Easting\",0.0],\n  PARAMETER[\"False_Northing\",0.0],\n  PARAMETER[\"Central_Meridian\",-96.0],\n  PARAMETER[\"Standard_Parallel_1\",33.0],\n  PARAMETER[\"Standard_Parallel_2\",45.0],\n  PARAMETER[\"Latitude_Of_Origin\",39.0],\n  UNIT[\"Meter\",1.0]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        MathTransform crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)crs, (boolean)true);
        Assert.assertFalse((boolean)crsTransform.isIdentity());
    }

    @Test
    public void testAxisAliases() throws Exception {
        String wkt1 = "PROJCS[\"NAD_1927_Texas_Statewide_Mapping_System\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.416666666666668],PARAMETER[\"Standard_Parallel_2\",34.916666666666664],PARAMETER[\"Latitude_Of_Origin\",31.166666666666668],UNIT[\"Foot\",0.3048]]";
        String wkt2 = "PROJCS[\"NAD_1927_Texas_Statewide_Mapping_System\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.416666666666668],PARAMETER[\"Standard_Parallel_2\",34.916666666666664],PARAMETER[\"Latitude_Of_Origin\",31.166666666666668],UNIT[\"Foot\",0.3048],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH]]";
        CoordinateReferenceSystem crs1 = CRS.parseWKT((String)wkt1);
        CoordinateReferenceSystem crs2 = CRS.parseWKT((String)wkt2);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2));
    }

    @Test
    public void testTransformationOverPole() throws FactoryException, TransformException {
        CoordinateReferenceSystem mapCRS = CRS.parseWKT((String)"PROJCS[\"WGS 84 / Antarctic Polar Stereographic\",\n  GEOGCS[\"WGS 84\",\n    DATUM[\"World Geodetic System 1984\",\n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295]],\n  PROJECTION[\"Polar Stereographic (variant B)\"],\n  PARAMETER[\"standard_parallel_1\", -71.0],\n  UNIT[\"m\", 1.0]]");
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)false).createOperation(mapCRS, (CoordinateReferenceSystem)WGS84);
        MathTransform transform = operation.getMathTransform();
        Assert.assertTrue((boolean)(transform instanceof MathTransform2D));
        XRectangle2D envelope = XRectangle2D.createFromExtremums((double)-3943612.4042124213, (double)-4078471.954436003, (double)3729092.5890516187, (double)4033483.085688618);
        XRectangle2D expected = XRectangle2D.createFromExtremums((double)-178.49352310409273, (double)-88.99136583196398, (double)137.56220967463082, (double)-40.905775004205864);
        Rectangle2D actual = CRS.transform((MathTransform2D)((MathTransform2D)transform), (Rectangle2D)envelope, null);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
        expected = XRectangle2D.createFromExtremums((double)-180.0, (double)-90.0, (double)180.0, (double)-40.905775004205864);
        actual = CRS.transform((CoordinateOperation)operation, (Rectangle2D)envelope, (Rectangle2D)actual);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
        envelope = XRectangle2D.createFromExtremums((double)-4000000.0, (double)-4000000.0, (double)300000.0, (double)30000.0);
        expected = XRectangle2D.createFromExtremums((double)-180.0, (double)-90.0, (double)180.0, (double)-41.03163170198091);
        actual = CRS.transform((CoordinateOperation)operation, (Rectangle2D)envelope, (Rectangle2D)actual);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
    }

    @Test
    public void testGetHorizontalCrs() {
        Assert.assertEquals((Object)DefaultEngineeringCRS.GENERIC_2D, (Object)CRS.getHorizontalCRS((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D));
    }

    @Test
    public void testGetAxisOrder() throws FactoryException {
        String wkt = "GEOGCS[\"WGS84(DD)\",DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],PRIMEM[\"Greenwich\", 0.0],UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],AXIS[\"Geodetic latitude\", NORTH]]";
        Assert.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt)));
        wkt = "GEOGCS[\"WGS84(DD)\",DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],PRIMEM[\"Greenwich\", 0.0],UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic latitude\", NORTH],AXIS[\"Geodetic longitude\", EAST]]";
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt)));
        Assert.assertEquals((Object)CRS.AxisOrder.INAPPLICABLE, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D)));
        wkt = "PROJCS[\"ED50 / UTM zone 31N\",   GEOGCS[\"ED50\",     DATUM[\"European Datum 1950\",       SPHEROID[\"International 1924\", 6378388.0, 297.0, AUTHORITY[\"EPSG\",\"7022\"]],       TOWGS84[-157.89, -17.16, -78.41, 2.118, 2.697, -1.434, -1.1097046576093785],       AUTHORITY[\"EPSG\",\"6230\"]],     PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],     UNIT[\"degree\", 0.017453292519943295],     AXIS[\"Geodetic latitude\", NORTH],     AXIS[\"Geodetic longitude\", EAST],     AUTHORITY[\"EPSG\",\"4230\"]],   PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],   PARAMETER[\"central_meridian\", 3.0],   PARAMETER[\"latitude_of_origin\", 0.0],   PARAMETER[\"scale_factor\", 0.9996],   PARAMETER[\"false_easting\", 500000.0],   PARAMETER[\"false_northing\", 0.0],   UNIT[\"m\", 1.0],   AXIS[\"Easting\", EAST],   AXIS[\"Northing\", NORTH],   AUTHORITY[\"EPSG\",\"23031\"]]";
        Assert.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt)));
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt), (boolean)true));
        wkt = "COMPD_CS[\"ETRS89 + EVRF2000 height\", GEOGCS[\"ETRS89\", DATUM[\"European Terrestrial Reference System 1989\", SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]], TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], AUTHORITY[\"EPSG\",\"6258\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic latitude\", NORTH], AXIS[\"Geodetic longitude\", EAST], AUTHORITY[\"EPSG\",\"4258\"]], VERT_CS[\"EVRF2000 height\", VERT_DATUM[\"European Vertical Reference Frame 2000\", 2005, AUTHORITY[\"EPSG\",\"5129\"]], UNIT[\"m\", 1.0], AXIS[\"Gravity-related height\", UP], AUTHORITY[\"EPSG\",\"5730\"]], AUTHORITY[\"EPSG\",\"7409\"]]";
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt)));
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.parseWKT((String)wkt), (boolean)true));
    }

    @Test
    public void parseWKT() throws Exception {
        String[] wkts;
        for (String wkt : wkts = new String[]{"PROJCS[\"Wagner_IV\", GEOGCS[\"WGS84\",  DATUM[\"WGS84\",  SPHEROID[\"WGS84\",  6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]], PROJECTION[\"Wagner_IV\"], UNIT[\"m\", 1.0], AXIS[\"Easting\", EAST], AXIS[\"Northing\", NORTH]]", "PROJCS[\"Wagner_V\", GEOGCS[\"WGS84\",  DATUM[\"WGS84\",  SPHEROID[\"WGS84\",  6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]], PROJECTION[\"Wagner_V\"], UNIT[\"m\", 1.0], AXIS[\"Easting\", EAST], AXIS[\"Northing\", NORTH]]"}) {
            Assert.assertNotNull((Object)CRS.parseWKT((String)wkt));
        }
    }

    @Test
    public void parseEsriWebMercator() throws Exception {
        String wkt = "PROJCS[\"WGS_1984_Web_Mercator_Auxiliary_Sphere\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator_Auxiliary_Sphere\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],PARAMETER[\"Auxiliary_Sphere_Type\",0.0],UNIT[\"Meter\",1.0]]";
        ProjectedCRS esriCrs = (ProjectedCRS)CRS.parseWKT((String)wkt);
        Assert.assertEquals((Object)"Popular Visualisation Pseudo Mercator", (Object)esriCrs.getConversionFromBase().getMethod().getName().getCode());
        String wkt3857 = "PROJCS[\"WGS 84 / Pseudo-Mercator\", \n  GEOGCS[\"WGS 84\", \n    DATUM[\"World Geodetic System 1984\", \n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n      AUTHORITY[\"EPSG\",\"6326\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic longitude\", EAST], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AUTHORITY[\"EPSG\",\"4326\"]], \n  PROJECTION[\"Popular Visualisation Pseudo Mercator\", AUTHORITY[\"EPSG\",\"1024\"]], \n  PARAMETER[\"semi_minor\", 6378137.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"central_meridian\", 0.0], \n  PARAMETER[\"scale_factor\", 1.0], \n  PARAMETER[\"false_easting\", 0.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH], \n  AUTHORITY[\"EPSG\",\"3857\"]]";
        CoordinateReferenceSystem epsg3857 = CRS.parseWKT((String)wkt3857);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)esriCrs, (Object)epsg3857));
    }

    @Test
    public void testLambertParsing() throws FactoryException {
        String initialLambertWkt = "PROJCS[\"LAMBERT WKT\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6371200.0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"standard_parallel_1\",25.0],PARAMETER[\"latitude_of_origin\",25.0],PARAMETER[\"central_meridian\",-95.0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],PARAMETER[\"Scale_Factor\",1.0],UNIT[\"m\",1]]";
        CoordinateReferenceSystem lambertCRS = CRS.parseWKT((String)initialLambertWkt);
        String parsedLambertWkt = lambertCRS.toWKT();
        CoordinateReferenceSystem lambertCRS2 = CRS.parseWKT((String)parsedLambertWkt);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)lambertCRS, (Object)lambertCRS2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reprojectEnvelopeRotatedPole() throws Exception {
        try {
            MapProjection.SKIP_SANITY_CHECKS = true;
            String wkt = "PROJCS[\"WGS 84 / North Pole LAEA Alaska\", \n  GEOGCS[\"WGS 84\", \n    DATUM[\"World Geodetic System 1984\", \n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n      AUTHORITY[\"EPSG\",\"6326\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AXIS[\"Geodetic longitude\", EAST], \n    AUTHORITY[\"EPSG\",\"4326\"]], \n  PROJECTION[\"Lambert_Azimuthal_Equal_Area\", AUTHORITY[\"EPSG\",\"9820\"]], \n  PARAMETER[\"latitude_of_center\", 90.0], \n  PARAMETER[\"longitude_of_center\", -150.0], \n  PARAMETER[\"false_easting\", 0.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", \"South along 60 deg West\"], \n  AXIS[\"Northing\", \"South along 30 deg East\"], \n  AUTHORITY[\"EPSG\",\"3572\"]]";
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
            GeneralEnvelope originalEnvelope = new GeneralEnvelope(crs);
            originalEnvelope.setEnvelope(new double[]{-9000000.0, -9000000.0, 900000.0, 9000000.0});
            GeneralEnvelope wgs84Envelope = CRS.transform((Envelope)originalEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            GeneralEnvelope transformed = CRS.transform((Envelope)wgs84Envelope, (CoordinateReferenceSystem)crs);
            Assert.assertTrue((boolean)transformed.contains((Envelope)originalEnvelope, true));
        }
        finally {
            MapProjection.SKIP_SANITY_CHECKS = false;
        }
    }

    @Test
    public void testReprojectionRequiredBasics() throws Exception {
        Assert.assertFalse((boolean)CRS.isTransformationRequired(null, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        Assert.assertFalse((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null));
        Assert.assertFalse((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        Assert.assertFalse((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D));
        Assert.assertTrue((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
    }

    @Test
    public void testReprojectionRequiredDatumAxisSwap() throws Exception {
        CoordinateReferenceSystem lonLatWebMercator = CRS.parseWKT((String)"PROJCS[\"WGS 84 / Pseudo-Mercator\", \n  GEOGCS[\"WGS 84\", \n    DATUM[\"World Geodetic System 1984\", \n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n      AUTHORITY[\"EPSG\",\"6326\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic longitude\", EAST], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AUTHORITY[\"EPSG\",\"4326\"]], \n  PROJECTION[\"Popular Visualisation Pseudo Mercator\", AUTHORITY[\"EPSG\",\"1024\"]], \n  PARAMETER[\"semi_minor\", 6378137.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"central_meridian\", 0.0], \n  PARAMETER[\"scale_factor\", 1.0], \n  PARAMETER[\"false_easting\", 0.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH], \n  AUTHORITY[\"EPSG\",\"3857\"]]");
        CoordinateReferenceSystem latLonWebMercator = CRS.parseWKT((String)"PROJCS[\"WGS 84 / Pseudo-Mercator\", \n  GEOGCS[\"WGS 84\", \n    DATUM[\"World Geodetic System 1984\", \n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n      AUTHORITY[\"EPSG\",\"6326\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AXIS[\"Geodetic longitude\", EAST], \n    AUTHORITY[\"EPSG\",\"4326\"]], \n  PROJECTION[\"Popular Visualisation Pseudo Mercator\", AUTHORITY[\"EPSG\",\"1024\"]], \n  PARAMETER[\"semi_minor\", 6378137.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"central_meridian\", 0.0], \n  PARAMETER[\"scale_factor\", 1.0], \n  PARAMETER[\"false_easting\", 0.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH], \n  AUTHORITY[\"EPSG\",\"3857\"]]");
        Assert.assertFalse((boolean)CRS.isTransformationRequired((CoordinateReferenceSystem)lonLatWebMercator, (CoordinateReferenceSystem)latLonWebMercator));
    }

    @Test
    public void testReprojectAzimuthalEquidistant() throws Exception {
        String wkt = "PROJCS[\"equi7_europe_nofalseXY\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Azimuthal_Equidistant\"],PARAMETER[\"false_easting\",5837287.81977],PARAMETER[\"false_northing\",2121415.69617],PARAMETER[\"central_meridian\",24.0],PARAMETER[\"latitude_of_origin\",53.0],UNIT[\"Meter\",1.0]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        CoordinateOperation op = CRS.getCoordinateOperationFactory((boolean)false).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs);
        GeneralEnvelope envelope = new GeneralEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.setEnvelope(new double[]{-180.0, -90.0, 180.0, 90.0});
        GeneralEnvelope transformed = CRS.transform((CoordinateOperation)op, (Envelope)envelope);
        Assert.assertEquals((double)-1.38E7, (double)transformed.getMinimum(0), (double)1000000.0);
        Assert.assertEquals((double)-1.37E7, (double)transformed.getMinimum(1), (double)1000000.0);
        Assert.assertEquals((double)2.57E7, (double)transformed.getMaximum(0), (double)1000000.0);
        Assert.assertEquals((double)1.41E7, (double)transformed.getMaximum(1), (double)1000000.0);
    }
}

