/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.measure.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.GenericName;
import si.uom.SI;

public final class PredefinedObjectsTest {
    @Test
    public void testAxis() {
        Assert.assertEquals((String)"x", (Object)"AXIS[\"x\", EAST]", (Object)DefaultCoordinateSystemAxis.X.toWKT(0));
        Assert.assertEquals((String)"y", (Object)"AXIS[\"y\", NORTH]", (Object)DefaultCoordinateSystemAxis.Y.toWKT(0));
        Assert.assertEquals((String)"z", (Object)"AXIS[\"z\", UP]", (Object)DefaultCoordinateSystemAxis.Z.toWKT(0));
        Assert.assertEquals((String)"Longitude", (Object)"AXIS[\"Longitude\", EAST]", (Object)DefaultCoordinateSystemAxis.LONGITUDE.toWKT(0));
        Assert.assertEquals((String)"Latitude", (Object)"AXIS[\"Latitude\", NORTH]", (Object)DefaultCoordinateSystemAxis.LATITUDE.toWKT(0));
        Assert.assertEquals((String)"Altitude", (Object)"AXIS[\"Altitude\", UP]", (Object)DefaultCoordinateSystemAxis.ALTITUDE.toWKT(0));
        Assert.assertEquals((String)"Time", (Object)"AXIS[\"Time\", FUTURE]", (Object)DefaultCoordinateSystemAxis.TIME.toWKT(0));
        Assert.assertEquals((String)"Longitude", (Object)"AXIS[\"Geodetic longitude\", EAST]", (Object)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE.toWKT(0));
        Assert.assertEquals((String)"Longitude", (Object)"AXIS[\"Spherical longitude\", EAST]", (Object)DefaultCoordinateSystemAxis.SPHERICAL_LONGITUDE.toWKT(0));
        Assert.assertEquals((String)"Latitude", (Object)"AXIS[\"Geodetic latitude\", NORTH]", (Object)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE.toWKT(0));
        Assert.assertEquals((String)"Latitude", (Object)"AXIS[\"Spherical latitude\", NORTH]", (Object)DefaultCoordinateSystemAxis.SPHERICAL_LATITUDE.toWKT(0));
        Assert.assertEquals((String)"English", (Object)"Time", (Object)((GenericName)DefaultCoordinateSystemAxis.TIME.getAlias().iterator().next()).toInternationalString().toString(Locale.ENGLISH));
        Assert.assertEquals((String)"French", (Object)"Temps", (Object)((GenericName)DefaultCoordinateSystemAxis.TIME.getAlias().iterator().next()).toInternationalString().toString(Locale.FRENCH));
        Assert.assertFalse((String)"X", (boolean)DefaultCoordinateSystemAxis.X.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.GEOCENTRIC_X, false));
        Assert.assertFalse((String)"Longitude", (boolean)DefaultCoordinateSystemAxis.LONGITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, true));
        Assert.assertFalse((String)"Longitude", (boolean)DefaultCoordinateSystemAxis.LONGITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.SPHERICAL_LONGITUDE, true));
        Assert.assertFalse((String)"Longitude", (boolean)DefaultCoordinateSystemAxis.LONGITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.SPHERICAL_LONGITUDE, false));
        Assert.assertTrue((String)"Longitude", (boolean)DefaultCoordinateSystemAxis.LONGITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, false));
        Assert.assertTrue((String)"Latitude", (boolean)DefaultCoordinateSystemAxis.LATITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, false));
        Assert.assertFalse((String)"Lon/Lat", (boolean)DefaultCoordinateSystemAxis.LATITUDE.equals((AbstractIdentifiedObject)DefaultCoordinateSystemAxis.LONGITUDE, false));
    }

    @Test
    public void testCoordinateSystems() {
        Assert.assertEquals((String)"Cartesian 2D", (long)2L, (long)DefaultCartesianCS.PROJECTED.getDimension());
        Assert.assertEquals((String)"Cartesian 3D", (long)3L, (long)DefaultCartesianCS.GEOCENTRIC.getDimension());
        Assert.assertEquals((String)"Ellipsoidal 2D", (long)2L, (long)DefaultEllipsoidalCS.GEODETIC_2D.getDimension());
        Assert.assertEquals((String)"Ellipsoidal 3D", (long)3L, (long)DefaultEllipsoidalCS.GEODETIC_3D.getDimension());
        Assert.assertEquals((String)"Vertical", (long)1L, (long)DefaultVerticalCS.DEPTH.getDimension());
        Assert.assertEquals((String)"Temporal", (long)1L, (long)DefaultTimeCS.DAYS.getDimension());
    }

    @Test
    public void testDatum() {
        Assert.assertEquals((String)"Ellipsoid", (Object)DefaultEllipsoid.WGS84, (Object)DefaultGeodeticDatum.WGS84.getEllipsoid());
        Assert.assertEquals((String)"PrimeMeridian", (Object)DefaultPrimeMeridian.GREENWICH, (Object)DefaultGeodeticDatum.WGS84.getPrimeMeridian());
        Assert.assertNotEquals((String)"VerticalDatum", (Object)DefaultVerticalDatum.GEOIDAL, (Object)DefaultVerticalDatum.ELLIPSOIDAL);
        Assert.assertEquals((String)"Geoidal", (Object)VerticalDatumType.GEOIDAL, (Object)DefaultVerticalDatum.GEOIDAL.getVerticalDatumType());
        Assert.assertEquals((String)"Ellipsoidal", (Object)VerticalDatumType.ELLIPSOIDAL, (Object)DefaultVerticalDatum.ELLIPSOIDAL.getVerticalDatumType());
        Assert.assertEquals((String)"Ellipsoid", (Object)"SPHEROID[\"WGS84\", 6378137.0, 298.257223563]", (Object)DefaultEllipsoid.WGS84.toWKT(0));
        Assert.assertEquals((String)"PrimeMeridian", (Object)"PRIMEM[\"Greenwich\", 0.0]", (Object)DefaultPrimeMeridian.GREENWICH.toWKT(0));
        Assert.assertEquals((String)"VerticalDatum", (Object)"VERT_DATUM[\"Geoidal\", 2005]", (Object)DefaultVerticalDatum.GEOIDAL.toWKT(0));
        Assert.assertEquals((String)"VerticalDatum", (Object)"VERT_DATUM[\"Ellipsoidal\", 2002]", (Object)DefaultVerticalDatum.ELLIPSOIDAL.toWKT(0));
        Assert.assertEquals((String)"GeodeticDatum", (Object)"DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]]", (Object)DefaultGeodeticDatum.WGS84.toWKT(0));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "This is a name");
        properties.put("scope", "This is a scope");
        properties.put("scope_fr", "Valide dans ce domaine");
        properties.put("remarks", "There is remarks");
        properties.put("remarks_fr", "Voici des remarques");
        DefaultGeodeticDatum datum = new DefaultGeodeticDatum(properties, (Ellipsoid)DefaultEllipsoid.createEllipsoid((String)"Test", (double)1000.0, (double)1000.0, (Unit)SI.METRE), (PrimeMeridian)new DefaultPrimeMeridian("Test", 12.0));
        Assert.assertEquals((String)"name", (Object)"This is a name", (Object)datum.getName().getCode());
        Assert.assertEquals((String)"scope", (Object)"This is a scope", (Object)datum.getScope().toString(null));
        Assert.assertEquals((String)"scope_fr", (Object)"Valide dans ce domaine", (Object)datum.getScope().toString(Locale.FRENCH));
        Assert.assertEquals((String)"remarks", (Object)"There is remarks", (Object)datum.getRemarks().toString(null));
        Assert.assertEquals((String)"remarks_fr", (Object)"Voici des remarques", (Object)datum.getRemarks().toString(Locale.FRENCH));
    }

    @Test
    public void testCoordinateReferenceSystems() {
        Assert.assertEquals((String)"WGS84 2D", (long)2L, (long)DefaultGeographicCRS.WGS84.getCoordinateSystem().getDimension());
        Assert.assertEquals((String)"WGS84 3D", (long)3L, (long)DefaultGeographicCRS.WGS84_3D.getCoordinateSystem().getDimension());
        Assert.assertEquals((String)"WGS84", (Object)"GEOGCS[\"WGS84(DD)\", DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic longitude\", EAST], AXIS[\"Geodetic latitude\", NORTH], AUTHORITY[\"EPSG\",\"4326\"]]", (Object)DefaultGeographicCRS.WGS84.toWKT(0));
        Assert.assertEquals((Object)"4327", (Object)DefaultGeographicCRS.WGS84_3D.getIdentifier((Citation)new CitationImpl((CharSequence)"EPSG")).getCode());
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        PredefinedObjectsTest.serialize(DefaultCoordinateSystemAxis.X);
        PredefinedObjectsTest.serialize(DefaultCoordinateSystemAxis.GEOCENTRIC_X);
        PredefinedObjectsTest.serialize(DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE);
        PredefinedObjectsTest.serialize(DefaultCartesianCS.PROJECTED);
        PredefinedObjectsTest.serialize(DefaultCartesianCS.GEOCENTRIC);
        PredefinedObjectsTest.serialize(DefaultEllipsoidalCS.GEODETIC_2D);
        PredefinedObjectsTest.serialize(DefaultEllipsoidalCS.GEODETIC_3D);
        PredefinedObjectsTest.serialize(DefaultPrimeMeridian.GREENWICH);
        PredefinedObjectsTest.serialize(DefaultGeodeticDatum.WGS84);
    }

    private static void serialize(Object object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream outs = new ObjectOutputStream(out);
        outs.writeObject(object);
        outs.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        Object test = in.readObject();
        in.close();
        Assert.assertEquals((String)"Serialization", (Object)object, (Object)test);
        Assert.assertEquals((String)"Serialization", (long)object.hashCode(), (long)test.hashCode());
    }
}

