/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.Console;
import org.geotools.util.TableWriter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;

public final class ScriptRunner
extends Console {
    private int testRun;
    private int testPassed;

    public ScriptRunner(LineNumberReader in) {
        super(in);
        this.setPrompt(null);
    }

    protected void test() throws TransformException, MismatchedDimensionException {
        ++this.testRun;
        super.test();
        ++this.testPassed;
    }

    private void printStatistics() throws IOException {
        NumberFormat f = NumberFormat.getNumberInstance();
        try (TableWriter table = new TableWriter(this.out, 1);){
            table.setMultiLinesCells(true);
            table.writeHorizontalSeparator();
            table.write("Tests:");
            table.nextColumn();
            table.setAlignment(2);
            table.write(f.format(this.testRun));
            table.nextLine();
            table.setAlignment(0);
            table.write("Errors:");
            table.nextColumn();
            table.setAlignment(2);
            table.write(f.format(this.testRun - this.testPassed));
            table.nextLine();
            if (this.testRun != 0) {
                f = NumberFormat.getPercentInstance();
                table.setAlignment(0);
                table.write("Success rate:");
                table.nextColumn();
                table.setAlignment(2);
                table.write(f.format((double)this.testPassed / (double)this.testRun));
                table.nextLine();
            }
            table.writeHorizontalSeparator();
            table.flush();
        }
    }

    public static void main(String[] args) {
        String lineSeparator = System.getProperty("line.separator", "\r");
        try {
            for (String filename : args) {
                try (LineNumberReader in = new LineNumberReader(new FileReader(filename));){
                    ScriptRunner test = new ScriptRunner(in);
                    test.out.write("Running \"");
                    test.out.write(filename);
                    test.out.write(34);
                    test.out.write(lineSeparator);
                    test.out.flush();
                    test.run();
                    test.printStatistics();
                    test.out.write(lineSeparator);
                    test.out.flush();
                }
            }
        }
        catch (IOException exception) {
            Logger.getGlobal().log(Level.INFO, "", exception);
        }
    }
}

