/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.LineNumberReader;
import org.geotools.referencing.ScriptRunner;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.test.TestData;
import org.junit.Ignore;
import org.junit.Test;

public final class ScriptTest {
    private void runScript(String filename) throws Exception {
        try (LineNumberReader in = TestData.openReader((Object)this, (String)filename);){
            ScriptRunner test = new ScriptRunner(in);
            test.executeAll();
        }
    }

    @Test
    public void testAbridgedMolodesky() throws Exception {
        this.runScript("scripts/AbridgedMolodensky.txt");
    }

    @Test
    public void testMolodesky() throws Exception {
        this.runScript("scripts/Molodensky.txt");
    }

    @Test
    public void testSimple() throws Exception {
        this.runScript("scripts/Simple.txt");
    }

    @Test
    public void testProjections() throws Exception {
        this.runScript("scripts/Projections.txt");
    }

    @Test
    public void testMercator() throws Exception {
        this.runScript("scripts/Mercator.txt");
    }

    @Test
    public void testObliqueMercator() throws Exception {
        this.runScript("scripts/ObliqueMercator.txt");
    }

    @Test
    public void testTransverseMercator() throws Exception {
        this.runScript("scripts/TransverseMercator.txt");
    }

    @Test
    public void testAlbersEqualArea() throws Exception {
        this.runScript("scripts/AlbersEqualArea.txt");
    }

    @Test
    public void testLambertAzimuthalEqualArea() throws Exception {
        this.runScript("scripts/LambertAzimuthalEqualArea.txt");
    }

    @Test
    public void testLambertConic() throws Exception {
        this.runScript("scripts/LambertConic.txt");
    }

    @Test
    public void testStereographic() throws Exception {
        this.runScript("scripts/Stereographic.txt");
    }

    @Test
    public void testOrthographic() throws Exception {
        this.runScript("scripts/Orthographic.txt");
    }

    @Test
    public void testNZMG() throws Exception {
        this.runScript("scripts/NZMG.txt");
    }

    @Test
    public void testKrovak() throws Exception {
        this.runScript("scripts/Krovak.txt");
    }

    @Test
    public void testEquidistantConic() throws Exception {
        this.runScript("scripts/EquidistantConic.txt");
    }

    @Test
    public void testPolyconic() throws Exception {
        this.runScript("scripts/Polyconic.txt");
    }

    @Test
    public void testRobinson() throws Exception {
        this.runScript("scripts/Robinson.txt");
    }

    @Test
    public void testWinkelTripel() throws Exception {
        this.runScript("scripts/WinkelTripel.txt");
    }

    @Test
    public void testAitoff() throws Exception {
        this.runScript("scripts/Aitoff.txt");
    }

    @Test
    public void testEckertIV() throws Exception {
        this.runScript("scripts/EckertIV.txt");
    }

    @Test
    public void testMollweide() throws Exception {
        this.runScript("scripts/Mollweide.txt");
    }

    @Test
    public void testWagnerIV() throws Exception {
        this.runScript("scripts/WagnerIV.txt");
    }

    @Test
    public void testGeneralOblique() throws Exception {
        this.runScript("scripts/GeneralOblique.txt");
    }

    @Test
    public void testMeteosatSG() throws Exception {
        this.runScript("scripts/MeteosatSG.txt");
    }

    @Test
    public void testRotatedPole() throws Exception {
        this.runScript("scripts/RotatedPole.txt");
    }

    @Test
    public void testVanDerGrinten() throws Exception {
        this.runScript("scripts/WorldVanDerGrintenI.txt");
    }

    @Test
    public void testSinusoidal() throws Exception {
        this.runScript("scripts/Sinusoidal.txt");
    }

    @Test
    public void testHomolosine() throws Exception {
        this.runScript("scripts/Homolosine.txt");
    }

    @Test
    public void testGnomonic() throws Exception {
        this.runScript("scripts/Gnomonic.txt");
    }

    @Test
    public void testGEOS() throws Exception {
        this.runScript("scripts/GEOS.txt");
    }

    @Test
    @Ignore
    public void testWagnerV() throws Exception {
        this.runScript("scripts/WagnerV.txt");
    }

    @Test
    @Ignore
    public void testOpenGIS() throws Exception {
        this.runScript("scripts/OpenGIS.txt");
    }

    @Test
    @Ignore
    public void testNADCON() throws Exception {
        this.runScript("scripts/NADCON.txt");
    }

    @Test
    public void testCassini() throws Exception {
        try {
            MapProjection.SKIP_SANITY_CHECKS = true;
            this.runScript("scripts/Cassini.txt");
        }
        finally {
            MapProjection.SKIP_SANITY_CHECKS = false;
        }
    }

    @Test
    public void testAzimuthalEquidistant() throws Exception {
        this.runScript("scripts/AzimuthalEquidistant.txt");
    }

    @Test
    public void testEqualEarth() throws Exception {
        this.runScript("scripts/EqualEarth.txt");
    }
}

