/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.factory.AuthorityFactoryProxy;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.datum.GeodeticDatum;

public final class AuthorityFactoryProxyTest {
    @Test
    public void testType() {
        Assert.assertEquals(ProjectedCRS.class, (Object)AuthorityFactoryProxy.getType(ProjectedCRS.class));
        Assert.assertEquals(ProjectedCRS.class, (Object)AuthorityFactoryProxy.getType(DefaultProjectedCRS.class));
        Assert.assertEquals(GeographicCRS.class, (Object)AuthorityFactoryProxy.getType(GeographicCRS.class));
        Assert.assertEquals(GeographicCRS.class, (Object)AuthorityFactoryProxy.getType(DefaultGeographicCRS.class));
        Assert.assertEquals(DerivedCRS.class, (Object)AuthorityFactoryProxy.getType(DefaultDerivedCRS.class));
        Assert.assertEquals(CoordinateReferenceSystem.class, (Object)AuthorityFactoryProxy.getType(AbstractDerivedCRS.class));
        Assert.assertEquals(GeodeticDatum.class, (Object)AuthorityFactoryProxy.getType(DefaultGeodeticDatum.class));
    }

    @Test
    public void testCreate() throws FactoryException {
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"CRS", null);
        CoordinateReferenceSystem expected = factory.createCoordinateReferenceSystem("83");
        AuthorityFactoryProxy proxy = AuthorityFactoryProxy.getInstance((AuthorityFactory)factory, GeographicCRS.class);
        Assert.assertTrue((boolean)proxy.getClass().getName().endsWith("Geographic"));
        Assert.assertSame((Object)expected, (Object)proxy.create("83"));
        Assert.assertSame((Object)expected, (Object)proxy.create("CRS:83"));
        proxy = AuthorityFactoryProxy.getInstance((AuthorityFactory)factory, CoordinateReferenceSystem.class);
        Assert.assertTrue((boolean)proxy.getClass().getName().endsWith("CRS"));
        Assert.assertSame((Object)expected, (Object)proxy.create("83"));
        Assert.assertSame((Object)expected, (Object)proxy.create("CRS:83"));
        proxy = AuthorityFactoryProxy.getInstance((AuthorityFactory)factory, IdentifiedObject.class);
        Assert.assertTrue((boolean)proxy.getClass().getName().endsWith("Default"));
        Assert.assertSame((Object)expected, (Object)proxy.create("83"));
        Assert.assertSame((Object)expected, (Object)proxy.create("CRS:83"));
        proxy = AuthorityFactoryProxy.getInstance((AuthorityFactory)factory, ProjectedCRS.class);
        Assert.assertTrue((boolean)proxy.getClass().getName().endsWith("Projected"));
        try {
            Assert.assertSame((Object)expected, (Object)proxy.create("83"));
            Assert.fail();
        }
        catch (FactoryException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClassCastException));
        }
        proxy = AuthorityFactoryProxy.getInstance((AuthorityFactory)factory, TemporalCRS.class);
        Assert.assertTrue((boolean)proxy.getClass().getName().endsWith("Default"));
        try {
            Assert.assertSame((Object)expected, (Object)proxy.create("83"));
            Assert.fail();
        }
        catch (FactoryException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClassCastException));
        }
    }

    @Test
    public void testCreateFromCodes() throws FactoryException {
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"CRS", null);
        IdentifiedObjectFinder proxy = new IdentifiedObjectFinder((AuthorityFactory)factory, GeographicCRS.class);
        CoordinateReferenceSystem expected = factory.createCoordinateReferenceSystem("84");
        Assert.assertNotSame((Object)expected, (Object)DefaultGeographicCRS.WGS84);
        Assert.assertSame((Object)expected, (Object)proxy.createFromCodes((IdentifiedObject)expected, false));
        Assert.assertSame((Object)expected, (Object)proxy.createFromIdentifiers((IdentifiedObject)expected));
        Assert.assertNull((Object)proxy.createFromNames((IdentifiedObject)expected));
        Assert.assertSame((Object)expected, (Object)proxy.createFromCodes((IdentifiedObject)DefaultGeographicCRS.WGS84, false));
        Assert.assertNull((Object)proxy.createFromIdentifiers((IdentifiedObject)DefaultGeographicCRS.WGS84));
        Assert.assertNull((Object)proxy.createFromNames((IdentifiedObject)DefaultGeographicCRS.WGS84));
        expected = factory.createCoordinateReferenceSystem("83");
        Assert.assertSame((Object)expected, (Object)proxy.createFromCodes((IdentifiedObject)expected, false));
        Assert.assertSame((Object)expected, (Object)proxy.createFromIdentifiers((IdentifiedObject)expected));
        Assert.assertNull((Object)proxy.createFromNames((IdentifiedObject)expected));
    }
}

