/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.HTTP_AuthorityFactory;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.GeographicCRS;

public final class HTTP_AuthorityFactoryTest {
    @Test
    public void testAxisOrderHints() {
        Assert.assertNull((Object)Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        Assert.assertNull((Object)Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING));
        Assert.assertFalse((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
        try {
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            Assert.assertFalse((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
            Assert.assertTrue((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"urn");
            Assert.assertFalse((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http, urn");
            Assert.assertTrue((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"urn, http");
            Assert.assertTrue((boolean)HTTP_AuthorityFactory.defaultAxisOrderHints(null, (String)"http"));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING);
        }
    }

    @Test
    public void testCRS() throws FactoryException {
        GeographicCRS crs;
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"http://www.opengis.net/gml", null);
        try {
            crs = factory.createGeographicCRS("CRS:84");
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException exception) {
            Assert.assertEquals((Object)"CRS:84", (Object)exception.getAuthorityCode());
        }
        crs = factory.createGeographicCRS("http://www.opengis.net/gml/srs/crs.xml#84");
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"http://www.opengis.net/gml/srs/crs.xml#84"));
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"CRS:84"));
        Assert.assertNotSame((Object)crs, (Object)DefaultGeographicCRS.WGS84);
        Assert.assertNotEquals((Object)DefaultGeographicCRS.WGS84, (Object)crs);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
        crs = factory.createGeographicCRS("http://www.opengis.net/gml/srs/crs.xml#83");
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"CRS:83"));
        Assert.assertFalse((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
    }
}

