/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;

public final class URN_AuthorityFactoryTest {
    @Test
    public void testRegistration() {
        String authority = "URN:OGC:DEF";
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)authority, null);
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getCRSAuthorityFactory((String)authority, null));
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getCSAuthorityFactory((String)authority, null));
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getDatumAuthorityFactory((String)authority, null));
        authority = "URN:X-OGC:DEF";
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getCRSAuthorityFactory((String)authority, null));
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getCSAuthorityFactory((String)authority, null));
        Assert.assertSame((Object)factory, (Object)ReferencingFactoryFinder.getDatumAuthorityFactory((String)authority, null));
    }

    @Test
    public void testCRS() throws FactoryException {
        GeographicCRS crs;
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"URN:OGC:DEF", null);
        try {
            crs = factory.createGeographicCRS("CRS:84");
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException exception) {
            Assert.assertEquals((Object)"CRS:84", (Object)exception.getAuthorityCode());
        }
        crs = factory.createGeographicCRS("urn:ogc:def:crs:CRS:WMS1.3:84");
        Assert.assertSame((Object)crs, (Object)factory.createGeographicCRS("urn:ogc:def:crs:CRS:1.3:84"));
        Assert.assertSame((Object)crs, (Object)factory.createGeographicCRS("URN:OGC:DEF:CRS:CRS:1.3:84"));
        Assert.assertSame((Object)crs, (Object)factory.createGeographicCRS("URN:OGC:DEF:CRS:CRS:84"));
        Assert.assertSame((Object)crs, (Object)factory.createGeographicCRS("urn:x-ogc:def:crs:CRS:1.3:84"));
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"urn:ogc:def:crs:CRS:1.3:84"));
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"CRS:84"));
        Assert.assertNotSame((Object)crs, (Object)DefaultGeographicCRS.WGS84);
        Assert.assertNotEquals((Object)DefaultGeographicCRS.WGS84, (Object)crs);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
        crs = factory.createGeographicCRS("urn:ogc:def:crs:CRS:1.3:83");
        Assert.assertSame((Object)crs, (Object)CRS.decode((String)"CRS:83"));
        Assert.assertFalse((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
    }

    @Test
    public void testWhenForceXY() throws FactoryException {
        try {
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            try {
                ReferencingFactoryFinder.getCRSAuthorityFactory((String)"URN:OGC:DEF", null);
                Assert.fail((String)"URN factory should not accept FORCE_LONGITUDE_FIRST_AXIS_ORDER = TRUE");
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                // empty catch block
            }
            CoordinateReferenceSystem crs = CRS.decode((String)"URN:OGC:DEF:CRS:CRS:84", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
            crs = CRS.decode((String)"URN:OGC:DEF:CRS:CRS:84");
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING);
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        }
    }
}

