/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.util.Set;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.geotools.referencing.wkt.Formattable;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CartesianAuthorityFactoryTest {
    static final String CODE = "404000";

    @Test
    public void testCodeInList() {
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        Assert.assertTrue((boolean)supportedCodes.contains(CODE));
    }

    @Test
    public void testDecode() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:404000");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultEngineeringCRS.GENERIC_2D, (Object)crs));
    }

    @Test
    public void testIdentifier() throws NoSuchAuthorityCodeException, FactoryException {
        Set identifiers = CartesianAuthorityFactory.GENERIC_2D.getIdentifiers();
        Assert.assertEquals((long)1L, (long)identifiers.size());
        ReferenceIdentifier id = (ReferenceIdentifier)identifiers.iterator().next();
        Assert.assertEquals((Object)Citations.EPSG, (Object)id.getAuthority());
        Assert.assertEquals((Object)CODE, (Object)id.getCode());
    }

    @Test
    public void testLookup() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:404000");
        Assert.assertEquals((Object)Integer.valueOf(CODE), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true));
        Assert.assertEquals((Object)Integer.valueOf(CODE), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
    }

    @Test
    public void testTransform() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem epsg0 = CRS.decode((String)"EPSG:404000");
        CoordinateReferenceSystem epsg42101 = CRS.decode((String)"EPSG:42101");
        Assert.assertTrue((boolean)CRS.findMathTransform((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D, (CoordinateReferenceSystem)epsg42101).isIdentity());
        Assert.assertTrue((boolean)CRS.findMathTransform((CoordinateReferenceSystem)epsg42101, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D).isIdentity());
        Assert.assertTrue((boolean)CRS.findMathTransform((CoordinateReferenceSystem)epsg0, (CoordinateReferenceSystem)epsg42101).isIdentity());
        Assert.assertTrue((boolean)CRS.findMathTransform((CoordinateReferenceSystem)epsg42101, (CoordinateReferenceSystem)epsg0).isIdentity());
    }

    @Test
    public void testWKT() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:404000");
        Formattable formattable = (Formattable)crs;
        String wkt = formattable.toWKT(Citations.EPSG, 2);
        String lineSep = System.getProperty("line.separator", "\n");
        String expected = "LOCAL_CS[\"Wildcard 2D cartesian plane in metric unit\", " + lineSep + "  LOCAL_DATUM[\"Unknown\", 0], " + lineSep + "  UNIT[\"m\", 1.0], " + lineSep + "  AXIS[\"x\", EAST], " + lineSep + "  AXIS[\"y\", NORTH], " + lineSep + "  AUTHORITY[\"EPSG\",\"404000\"]]";
        Assert.assertEquals((Object)expected, (Object)wkt);
    }
}

