/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.Random;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.operation.builder.BursaWolfTransformBuilder;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.transform.GeocentricTranslation;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public final class BursaWolfTransformBuilderTest {
    @Test
    public void testBursaWolfParamCalculaterXrotation() throws FactoryException, TransformException {
        Random random = new Random(773418718L);
        double R = 6370000.0;
        double angle = random.nextDouble() * 10.0 / 3600.0 * Math.PI / 180.0;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        ArrayList<MappedPosition> vectors = new ArrayList<MappedPosition>();
        vectors.add(new MappedPosition((DirectPosition)new GeneralDirectPosition(R, 0.0, 0.0), (DirectPosition)new GeneralDirectPosition(R, 0.0, 0.0)));
        vectors.add(new MappedPosition((DirectPosition)new GeneralDirectPosition(0.0, cos * R, -sin * R), (DirectPosition)new GeneralDirectPosition(0.0, R, 0.0)));
        vectors.add(new MappedPosition((DirectPosition)new GeneralDirectPosition(0.0, sin * R, cos * R), (DirectPosition)new GeneralDirectPosition(0.0, 0.0, R)));
        double[] points = new double[vectors.size() * 3];
        for (int i = 0; i < vectors.size(); ++i) {
            points[i * 3] = ((MappedPosition)vectors.get(i)).getSource().getCoordinate()[0];
            points[i * 3 + 1] = ((MappedPosition)vectors.get(i)).getSource().getCoordinate()[1];
            points[i * 3 + 2] = ((MappedPosition)vectors.get(i)).getSource().getCoordinate()[2];
        }
        double[] dstPoints = new double[points.length];
        BursaWolfTransformBuilder BWPT = new BursaWolfTransformBuilder(vectors);
        BWPT.getMathTransform().transform(points, 0, dstPoints, 0, points.length / 3);
        for (int i = 0; i < vectors.size(); ++i) {
            Assert.assertEquals((double)dstPoints[i * 3], (double)((MappedPosition)vectors.get(i)).getTarget().getCoordinate()[0], (double)0.01);
            Assert.assertEquals((double)dstPoints[i * 3 + 1], (double)((MappedPosition)vectors.get(i)).getTarget().getCoordinate()[1], (double)0.01);
            Assert.assertEquals((double)dstPoints[i * 3 + 2], (double)((MappedPosition)vectors.get(i)).getTarget().getCoordinate()[2], (double)0.01);
        }
    }

    @Test
    public void test2BursaWolfParamCalculater() throws FactoryException, TransformException {
        double R = 6370000.0;
        Random random = new Random(143477662L);
        ArrayList<MappedPosition> vectors = new ArrayList<MappedPosition>();
        BursaWolfParameters bwp = new BursaWolfParameters(null);
        bwp.dx = random.nextDouble() * 100.0;
        bwp.dy = random.nextDouble() * 100.0;
        bwp.dz = random.nextDouble() * 100.0;
        bwp.ex = random.nextDouble() * 10.0;
        bwp.ey = random.nextDouble() * 10.0;
        bwp.ez = random.nextDouble() * 10.0;
        bwp.ppm = random.nextDouble() * 10.0;
        GeocentricTranslation gt = new GeocentricTranslation(bwp);
        for (int i = 0; i < 30; ++i) {
            double gamma = (45.0 + random.nextDouble() * 10.0) * Math.PI / 180.0;
            double alfa = (45.0 + random.nextDouble() * 10.0) * Math.PI / 180.0;
            GeneralDirectPosition ptSrc = new GeneralDirectPosition(R * Math.sin(gamma) * Math.cos(alfa), R * Math.sin(gamma) * Math.cos(alfa), R * Math.cos(gamma));
            double[] pom = new double[3];
            gt.transform(ptSrc.getCoordinate(), 0, pom, 0, 1);
            GeneralDirectPosition ptDst = new GeneralDirectPosition(pom);
            vectors.add(new MappedPosition((DirectPosition)ptSrc, (DirectPosition)ptDst));
        }
        BursaWolfTransformBuilder BWPT = new BursaWolfTransformBuilder(vectors);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).dx, (double)bwp.dx, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).dy, (double)bwp.dy, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).dz, (double)bwp.dz, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).ex, (double)bwp.ex, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).ey, (double)bwp.ey, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).ez, (double)bwp.ez, (double)0.01);
        Assert.assertEquals((double)BWPT.getBursaWolfParameters(null).ppm, (double)bwp.ppm, (double)0.01);
        Assert.assertEquals((double)BWPT.getErrorStatistics().rms(), (double)0.0, (double)0.01);
    }
}

