/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeostationarySatelliteTest {
    public static final String sphericalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"Custom Geographic CS\",    DATUM[\"Custom Datum\",      SPHEROID[\"Sphere\",6367451.5, 0]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35832548.5],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    UNIT[\"meter\", 1]]";
    public static final String ellipsoidalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"WGS 84\",    DATUM[\"WGS_1984\",      SPHEROID[\"WGS84\",6378137,298.257223563]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.01745329251994328]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35785831.0],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    UNIT[\"meter\", 1]]";
    static CoordinateReferenceSystem sphericalGeosCRS;
    static MathTransform sphericalGeosToGeog;
    static MathTransform geogToSphericalGeos;
    static CoordinateReferenceSystem ellipsoidalGeosCRS;
    static MathTransform ellipsoidalGeosToGeog;
    static MathTransform geogToEllipsoidalGeos;

    @BeforeClass
    public static void setupClass() throws FactoryException, TransformException {
        sphericalGeosCRS = CRS.parseWKT((String)sphericalGeosWKT);
        sphericalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)sphericalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)sphericalGeosCRS).getBaseCRS(), (boolean)true);
        geogToSphericalGeos = sphericalGeosToGeog.inverse();
        ellipsoidalGeosCRS = CRS.parseWKT((String)ellipsoidalGeosWKT);
        ellipsoidalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)ellipsoidalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS).getBaseCRS(), (boolean)true);
        geogToEllipsoidalGeos = ellipsoidalGeosToGeog.inverse();
    }

    @Test
    public void testSpheroidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)sphericalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.58325485E7));
    }

    @Test
    public void testEllipsoidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)ellipsoidalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.5785831E7));
    }

    @Test
    public void testIsGeostationaryCRS() {
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)sphericalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCircumscribeFullDisk_Spheroidal() throws TransformException, FactoryException {
        Envelope2D circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaxX(), circumscribed.getCenterY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinX(), circumscribed.getCenterY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY() + 1.0);
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY() - 1.0);
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX() - 1.0, circumscribed.getCenterY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX() + 1.0, circumscribed.getCenterY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMaxY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMinY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMaxY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMinY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
    }

    @Test
    public void testCircumscribeFullDisk_Ellipsoidal() throws TransformException, FactoryException {
        Envelope2D circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaxX(), circumscribed.getCenterY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinX(), circumscribed.getCenterY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY() + 1.0);
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY() - 1.0);
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX() - 1.0, circumscribed.getCenterY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX() + 1.0, circumscribed.getCenterY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMaxY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMinY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMaxY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMinY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
    }

    @Test
    public void testInscribeFullDiskEstimate_Spheroidal() throws TransformException, FactoryException {
        Envelope2D inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(inscribed.getMaxX(), inscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaxX(), inscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInscribeFullDiskEstimate_Ellipsoidal() throws TransformException, FactoryException {
        Envelope2D inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(inscribed.getMaxX(), inscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaxX(), inscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private void expectProjectionException(Testable testable) {
        this.expectException(ProjectionException.class, testable);
    }

    private <T extends Exception> void expectException(Class<T> clazz, Testable testable) {
        block2: {
            try {
                testable.test();
                Assert.fail((String)String.format("Expected exception, %s, but not thrown", clazz));
            }
            catch (Exception e) {
                if (clazz.isInstance(e)) break block2;
                Assert.fail((String)String.format("Expected exception of %s but got %s", clazz, e.getClass()));
            }
        }
    }

    public static interface Testable {
        public void test() throws Exception;
    }
}

