/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.projection.MapProjection;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public final class MapProjectionTest {
    private static final double[] GEOGRAPHIC = new double[]{47.0, -14.0, 48.38824840214492, -14.967538330290973};
    private static final double[] PROJECTED = new double[]{5232016.067283858, -1574216.548161465, 5386555.1725052055, -1685459.3322153771};

    private static MapProjection createGoogleMercator() throws FactoryException {
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Mercator_1SP");
        parameters.parameter(MapProjection.AbstractProvider.SEMI_MAJOR.getName().getCode()).setValue(6378137.0);
        parameters.parameter(MapProjection.AbstractProvider.SEMI_MINOR.getName().getCode()).setValue(6378137.0);
        return (MapProjection)mtFactory.createParameterizedTransform(parameters);
    }

    @Test
    public void testCheckReciprocal() throws TransformException, FactoryException {
        int i;
        double[] dst = new double[PROJECTED.length];
        MapProjection mt = MapProjectionTest.createGoogleMercator();
        mt.transform(GEOGRAPHIC, 0, dst, 0, PROJECTED.length / 2);
        for (i = 0; i < PROJECTED.length; ++i) {
            Assert.assertEquals((double)PROJECTED[i], (double)dst[i], (double)0.1);
        }
        for (i = 0; i < PROJECTED.length / 2; ++i) {
            Point2D.Double src = new Point2D.Double(GEOGRAPHIC[i * 2 + 0], GEOGRAPHIC[i * 2 + 1]);
            Point2D.Double target = new Point2D.Double(PROJECTED[i * 2 + 0], PROJECTED[i * 2 + 1]);
            Assert.assertTrue((boolean)mt.checkReciprocal((Point2D)src, (Point2D)target, false));
            Assert.assertTrue((boolean)mt.checkReciprocal((Point2D)target, (Point2D)src, true));
        }
        mt.inverse().transform(PROJECTED, 0, dst, 0, PROJECTED.length / 2);
        for (i = 0; i < GEOGRAPHIC.length; ++i) {
            Assert.assertEquals((double)GEOGRAPHIC[i], (double)dst[i], (double)1.0E-4);
        }
    }

    @Test
    public void testOrthodromicDistance() throws FactoryException {
        MapProjection mt = MapProjectionTest.createGoogleMercator();
        Assert.assertEquals((double)111319.49079, (double)mt.orthodromicDistance((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 1.0)), (double)0.001);
        Assert.assertEquals((double)111319.49079, (double)mt.orthodromicDistance((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(1.0, 0.0)), (double)0.001);
        Assert.assertEquals((double)111319.49079, (double)mt.orthodromicDistance((Point2D)new Point2D.Double(0.0, 89.0), (Point2D)new Point2D.Double(0.0, 90.0)), (double)0.001);
        Assert.assertEquals((double)1942.76834, (double)mt.orthodromicDistance((Point2D)new Point2D.Double(0.0, 89.0), (Point2D)new Point2D.Double(1.0, 89.0)), (double)0.001);
        Assert.assertEquals((double)1.001875417139E7, (double)mt.orthodromicDistance((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 90.0)), (double)0.001);
        Point2D.Double src = new Point2D.Double(48.38824840214492, -14.967538330290973);
        Assert.assertEquals((double)0.0, (double)mt.orthodromicDistance((Point2D)src, (Point2D)src), (double)1.0E-9);
        Point2D.Double target = new Point2D.Double(((Point2D)src).getX(), ((Point2D)src).getY() + 1.0E-7);
        Assert.assertEquals((double)0.011131948840096939, (double)mt.orthodromicDistance((Point2D)src, (Point2D)target), (double)1.0E-12);
        Point2D.Double target2 = new Point2D.Double(((Point2D)src).getX(), ((Point2D)src).getY() + 1.0E-12);
        Assert.assertEquals((double)1.1117412E-7, (double)mt.orthodromicDistance((Point2D)src, (Point2D)target2), (double)1.0E-12);
    }
}

