/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.transform.EarthGravitationalModel;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class EarthGravitationalModelTest {
    @Test
    public void testHeightOffsetWGS84() throws Exception {
        EarthGravitationalModel gh = new EarthGravitationalModel();
        gh.load("EGM180.nor");
        Assert.assertEquals((double)1.505, (double)gh.heightOffset(45.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)1.515, (double)gh.heightOffset(45.0, 45.0, 1000.0), (double)0.001);
        Assert.assertEquals((double)46.908, (double)gh.heightOffset(0.0, 45.0, 0.0), (double)0.001);
    }

    @Test
    public void testHeightOffsetWGS72() throws Exception {
        EarthGravitationalModel gh = new EarthGravitationalModel(180, false);
        gh.load("EGM180.nor");
        Assert.assertEquals((double)1.475, (double)gh.heightOffset(45.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)46.879, (double)gh.heightOffset(0.0, 45.0, 0.0), (double)0.001);
        Assert.assertEquals((double)23.324, (double)gh.heightOffset(3.0, 10.0, 10.0), (double)0.001);
        Assert.assertEquals((double)0.38, (double)gh.heightOffset(75.0, -30.0, 0.0), (double)0.001);
    }

    @Test
    public void testMathTransform() throws FactoryException, TransformException {
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup p = mtFactory.getDefaultParameters("Earth gravitational model");
        MathTransform mt = mtFactory.createParameterizedTransform(p);
        GeneralDirectPosition pos = new GeneralDirectPosition(new double[]{45.0, 45.0, 1000.0});
        pos = mt.transform((DirectPosition)pos, (DirectPosition)pos);
        Assert.assertEquals((double)45.0, (double)pos.getOrdinate(0), (double)0.001);
        Assert.assertEquals((double)45.0, (double)pos.getOrdinate(1), (double)0.001);
        Assert.assertEquals((double)1001.515, (double)pos.getOrdinate(2), (double)0.001);
    }
}

