/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.IOException;
import javax.measure.Unit;
import org.geotools.measure.UnitFormatter;
import org.geotools.measure.Units;
import org.geotools.referencing.wkt.EsriUnitFormat;
import org.geotools.referencing.wkt.UnitFormatTest;
import org.junit.Assert;
import org.junit.Test;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;

public class EsriUnitFormatTest {
    private final UnitFormatter esriUnitFormatter = EsriUnitFormat.getInstance();

    @Test
    public void testFormatUnitOfQAppendable() throws IOException {
        UnitFormatTest.doTestNotModifiedUnits(SI.CELSIUS, this.esriUnitFormatter);
    }

    @Test
    public void testFootSurvey() {
        Assert.assertEquals((Object)"Foot_US", (Object)this.esriUnitFormatter.format(USCustomary.FOOT_SURVEY));
        Unit unit = this.esriUnitFormatter.parse((CharSequence)"Foot_US");
        Assert.assertEquals((Object)USCustomary.FOOT_SURVEY, (Object)unit);
    }

    @Test
    public void testGTDefinedFormats() throws IOException {
        UnitFormatTest.doTestFormatForGTDefinedUnits(NonSI.DEGREE_ANGLE, this.esriUnitFormatter, "Degree");
        UnitFormatTest.doTestFormatForGTDefinedUnits(SI.METRE, this.esriUnitFormatter, "Meter");
        UnitFormatTest.doTestFormatForGTDefinedUnits(Units.SEXAGESIMAL_DMS, this.esriUnitFormatter, "D.MS");
    }
}

