/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterList;
import javax.media.jai.RegistryElementDescriptor;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescription;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public final class ImagingParametersTest {
    @Test
    public void testDescriptors() {
        String author = Citations.JAI.getTitle().toString();
        String vendor = "com.sun.media.jai";
        String mode = "rendered";
        RegistryElementDescriptor descriptor = JAI.getDefaultInstance().getOperationRegistry().getDescriptor("rendered", "AddConst");
        ImagingParameterDescriptors parameters = new ImagingParameterDescriptors(descriptor);
        GenericName alias = (GenericName)parameters.getAlias().iterator().next();
        Assert.assertEquals((String)"Name", (Object)"AddConst", (Object)parameters.getName().getCode());
        Assert.assertEquals((String)"Authority", (Object)author, (Object)parameters.getName().getAuthority().getTitle().toString());
        Assert.assertEquals((String)"Vendor", (Object)"com.sun.media.jai", (Object)alias.scope().name().toString());
        Assert.assertNotNull((String)"Version", (Object)parameters.getName().getVersion());
        ImagingParametersTest.assertLocalized("Vendor", (CharSequence)alias.scope().name().toInternationalString());
        ImagingParametersTest.assertLocalized("Remarks", (CharSequence)parameters.getRemarks());
        Assert.assertTrue((String)"Remarks", (parameters.getRemarks().toString().trim().length() > 0 ? 1 : 0) != 0);
        ParameterDescriptor param = (ParameterDescriptor)parameters.descriptor("constants");
        Assert.assertEquals((String)"Name", (Object)"constants", (Object)param.getName().getCode());
        Assert.assertEquals((String)"Type", double[].class, (Object)param.getValueClass());
        Assert.assertEquals((String)"Default", (long)1L, (long)((double[])param.getDefaultValue()).length);
        Assert.assertNull((String)"Minimum", (Object)param.getMinimumValue());
        Assert.assertNull((String)"Maximum", (Object)param.getMaximumValue());
        Assert.assertNull((String)"Valid values", (Object)param.getValidValues());
        ImagingParametersTest.assertLocalized("Remarks", (CharSequence)param.getRemarks());
        Assert.assertFalse((boolean)parameters.getRemarks().toString().trim().equalsIgnoreCase(param.getRemarks().toString().trim()));
        ImagingParameters values = (ImagingParameters)parameters.createValue();
        for (int i = 0; i < 20; ++i) {
            ParameterValue before = values.parameter("constants");
            if (i % 5 == 0) {
                values.parameters.setParameter("constants", (Object)new double[]{i});
            } else {
                values.parameter("constants").setValue((Object)new double[]{i});
            }
            Assert.assertTrue((boolean)Arrays.equals(values.parameter("constants").doubleValueList(), (double[])values.parameters.getObjectParameter("constants")));
            Assert.assertSame((Object)before, (Object)values.parameter("constants"));
        }
        Assert.assertNotNull((Object)values.toString());
        ImagingParameters copy = values.clone();
        Assert.assertNotSame((String)"clone", (Object)values, (Object)copy);
        Assert.assertNotSame((String)"clone", (Object)values.parameters, (Object)copy.parameters);
    }

    private static void assertLocalized(String name, CharSequence title) {
        Assert.assertTrue((String)name, (boolean)(title instanceof ImagingParameterDescription));
    }

    @Test
    public void testExtensions() {
        DefaultParameterDescriptor SPATIAL_SUBSAMPLING_X = new DefaultParameterDescriptor(Citations.OGC, "xPeriod", Double.class, null, null, (Comparable)Double.valueOf(0.0), null, null, false);
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor operation = (OperationDescriptor)registry.getDescriptor("rendered", "Extrema");
        ArrayList<DefaultParameterDescriptor> replacingDescriptors = new ArrayList<DefaultParameterDescriptor>(1);
        replacingDescriptors.add(SPATIAL_SUBSAMPLING_X);
        ImagingParameterDescriptors ripd = new ImagingParameterDescriptors((RegistryElementDescriptor)operation, replacingDescriptors);
        ParameterValueGroup rip = ripd.createValue();
        Assert.assertSame((Object)ripd, (Object)rip.getDescriptor());
        ParameterValue p = rip.parameter("xPeriod");
        Assert.assertSame((Object)SPATIAL_SUBSAMPLING_X, (Object)p.getDescriptor());
        p.setValue((Object)2.3);
        Assert.assertTrue((boolean)p.toString().startsWith("xPeriod = 2.3"));
        ParameterList pl = ((ImagingParameters)rip).parameters;
        Assert.assertSame((Object)pl, (Object)pl.setParameter("xPeriod", 2));
        Assert.assertSame((Object)pl, (Object)pl.setParameter("yPeriod", 2));
        Assert.assertEquals((long)2L, (long)pl.getIntParameter("xPeriod"));
        Assert.assertEquals((long)2L, (long)pl.getIntParameter("yPeriod"));
        Assert.assertEquals((String)"Setting 'xPeriod' on ParameterList should have no effect on ParameterValue.", (double)2.3, (double)p.doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"'yPeriod' should still backed by the ParameterList.", (long)2L, (long)rip.parameter("yPeriod").intValue());
    }
}

