/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.RenderingHints;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractCRSTest
extends OnlineTestCase {
    private static boolean verbose = false;

    protected void tearDownInternal() throws Exception {
        System.clearProperty("org.geotools.referencing.forceXY");
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        CRS.reset((String)"all");
    }

    public void testCorrectAxisOrder() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        CoordinateSystem cs = crs.getCoordinateSystem();
        AbstractCRSTest.assertEquals((int)2, (int)cs.getDimension());
        CoordinateSystemAxis axis0 = cs.getAxis(0);
        AbstractCRSTest.assertEquals((String)"Lat", (String)axis0.getAbbreviation());
        CoordinateSystemAxis axis1 = cs.getAxis(1);
        AbstractCRSTest.assertEquals((String)"Lon", (String)axis1.getAbbreviation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForcedAxisOrder() throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem def;
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        CoordinateSystem cs = crs.getCoordinateSystem();
        AbstractCRSTest.assertEquals((int)2, (int)cs.getDimension());
        CoordinateSystemAxis axis0 = cs.getAxis(0);
        AbstractCRSTest.assertEquals((String)"Lon", (String)axis0.getAbbreviation());
        CoordinateSystemAxis axis1 = cs.getAxis(1);
        AbstractCRSTest.assertEquals((String)"Lat", (String)axis1.getAbbreviation());
        CoordinateReferenceSystem standard = CRS.decode((String)"EPSG:4326");
        AbstractCRSTest.assertFalse((String)"Should not be (long,lat) axis order.", (boolean)CRS.equalsIgnoreMetadata((Object)crs, (Object)standard));
        try {
            AbstractCRSTest.assertNull((Object)Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
            def = CRS.decode((String)"EPSG:4326");
        }
        finally {
            AbstractCRSTest.assertEquals((Object)Boolean.TRUE, (Object)Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        }
        AbstractCRSTest.assertEquals((String)"Expected (long,lat) axis order.", (Object)crs, (Object)def);
        AbstractCRSTest.assertSame((String)"Should be back to (lat,long) axis order.", (Object)standard, (Object)CRS.decode((String)"EPSG:4326"));
    }

    public void testSystemPropertyToForceXY() throws NoSuchAuthorityCodeException, FactoryException {
        AbstractCRSTest.assertNull((Object)System.getProperty("org.geotools.referencing.forceXY"));
        System.setProperty("org.geotools.referencing.forceXY", "true");
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            CoordinateSystem cs = crs.getCoordinateSystem();
            AbstractCRSTest.assertEquals((int)2, (int)cs.getDimension());
            cs.getAxis(0);
            cs.getAxis(1);
        }
        finally {
            System.clearProperty("org.geotools.referencing.forceXY");
        }
    }

    public void testFind() throws FactoryException {
        CoordinateReferenceSystem crs = AbstractCRSTest.getED50("ED50");
        AbstractCRSTest.assertEquals((String)"Should find without scan thanks to the name.", (String)"EPSG:4230", (String)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false));
        AbstractCRSTest.assertEquals((Object)4230, (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        crs = AbstractCRSTest.getED50("ED50 with unknown name");
        if (this.supportsED50QuickScan()) {
            AbstractCRSTest.assertEquals((String)"With scan allowed, should find the CRS.", (String)"EPSG:4230", (String)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false));
            AbstractCRSTest.assertEquals((Object)4230, (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        } else {
            AbstractCRSTest.assertNull((String)"Should not find the CRS without a scan.", (Object)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false));
            AbstractCRSTest.assertEquals(null, (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        }
        AbstractCRSTest.assertEquals((String)"With scan allowed, should find the CRS.", (String)"EPSG:4230", (String)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
        AbstractCRSTest.assertEquals((Object)4230, (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true));
    }

    protected boolean supportsED50QuickScan() {
        return false;
    }

    private static CoordinateReferenceSystem getED50(String name) throws FactoryException {
        String wkt = "GEOGCS[\"" + name + "\",\n  DATUM[\"European Datum 1950\",\n  SPHEROID[\"International 1924\", 6378388.0, 297.0]],\nPRIMEM[\"Greenwich\", 0.0],\nUNIT[\"degree\", 0.017453292519943295]]";
        return CRS.parseWKT((String)wkt);
    }

    public void testWKT() throws FactoryException {
        String wkt = "GEOGCS[\"WGS 84\",\n  DATUM[\"WGS_1984\",\n    SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],\n    TOWGS84[0,0,0,0,0,0,0], AUTHORITY[\"EPSG\",\"6326\"]],\n  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH], AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4326\"]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void testFindMathTransformIdentity() throws FactoryException {
        CoordinateReferenceSystem crs1default = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem crs2default = CRS.decode((String)"EPSG:4326");
        MathTransform tDefault = CRS.findMathTransform((CoordinateReferenceSystem)crs1default, (CoordinateReferenceSystem)crs2default);
        AbstractCRSTest.assertTrue((String)"WSG84 transformed to WSG84 should be Identity", (boolean)tDefault.isIdentity());
        CoordinateReferenceSystem crs1force = CRS.decode((String)"EPSG:4326", (boolean)true);
        CoordinateReferenceSystem crs2force = CRS.decode((String)"EPSG:4326", (boolean)true);
        MathTransform tForce = CRS.findMathTransform((CoordinateReferenceSystem)crs1force, (CoordinateReferenceSystem)crs2force);
        AbstractCRSTest.assertTrue((String)"WSG84 transformed to WSG84 should be Identity", (boolean)tForce.isIdentity());
    }

    public void testAuthority() {
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
        Citation authority = factory.getAuthority();
        AbstractCRSTest.assertNotNull((Object)authority);
        AbstractCRSTest.assertEquals((String)"European Petroleum Survey Group", (String)authority.getTitle().toString(Locale.US));
        AbstractCRSTest.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"EPSG"));
        factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        authority = factory.getAuthority();
        AbstractCRSTest.assertNotNull((Object)authority);
        AbstractCRSTest.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"EPSG"));
    }

    public void testVendor() {
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        Citation vendor = factory.getVendor();
        AbstractCRSTest.assertNotNull((Object)vendor);
        AbstractCRSTest.assertEquals((String)"Geotools", (String)vendor.getTitle().toString(Locale.US));
        AbstractCRSTest.assertFalse((boolean)Citations.identifierMatches((Citation)vendor, (String)"EPSG"));
    }

    public void testCodes() throws FactoryException {
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
        AbstractCRSTest.assertNotNull((Object)codes);
        AbstractCRSTest.assertTrue((codes.size() >= 3000 ? 1 : 0) != 0);
    }

    public void test26910() throws FactoryException {
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("EPSG:26910");
        AbstractCRSTest.assertNotNull((Object)crs);
        AbstractCRSTest.assertSame((Object)crs, (Object)factory.createObject("EPSG:26910"));
    }

    public void test4326() throws FactoryException {
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("EPSG:4326");
        AbstractCRSTest.assertNotNull((Object)crs);
        AbstractCRSTest.assertSame((Object)crs, (Object)factory.createObject("EPSG:4326"));
    }

    public void test4269() throws FactoryException {
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("EPSG:4269");
        AbstractCRSTest.assertNotNull((Object)crs);
        AbstractCRSTest.assertSame((Object)crs, (Object)factory.createObject("EPSG:4269"));
    }

    public void test26910Lower() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"epsg:26910");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void test26986Lower() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"epsg:26986");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void test4326Lower() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"epsg:4326");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void test26742Lower() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"epsg:26742");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void test4269Lower() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"epsg:4269");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void testWestDirection() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3573");
        AbstractCRSTest.assertNotNull((Object)crs);
    }

    public void testPlateCarre() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32662");
        AbstractCRSTest.assertNotNull((Object)crs);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
        double[] source = new double[]{-20.0, 35.0};
        double[] dest = new double[2];
        mt.transform(source, 0, dest, 0, 1);
        AbstractCRSTest.assertEquals((double)-2226389.82, (double)dest[0], (double)0.01);
        AbstractCRSTest.assertEquals((double)3896182.18, (double)dest[1], (double)0.01);
    }

    public void testHorizontalFromCompound() throws FactoryException {
        CoordinateReferenceSystem compound = CRS.decode((String)"EPSG:7401");
        SingleCRS horizontal = CRS.getHorizontalCRS((CoordinateReferenceSystem)compound);
        AbstractCRSTest.assertEquals((Object)CRS.decode((String)"EPSG:27582"), (Object)horizontal);
    }

    public void testHorizontalFromGeodetic() throws FactoryException {
        CoordinateReferenceSystem compound = CRS.decode((String)"EPSG:4327");
        SingleCRS horizontal = CRS.getHorizontalCRS((CoordinateReferenceSystem)compound);
        CoordinateSystem cs = horizontal.getCoordinateSystem();
        AbstractCRSTest.assertEquals((int)2, (int)cs.getDimension());
        AbstractCRSTest.assertEquals((Object)AxisDirection.NORTH, (Object)cs.getAxis(0).getDirection());
        AbstractCRSTest.assertEquals((Object)AxisDirection.EAST, (Object)cs.getAxis(1).getDirection());
    }

    public void testSuccess() throws FactoryException {
        if (!verbose) {
            return;
        }
        OrderedAxisAuthorityFactory factory = new OrderedAxisAuthorityFactory("EPSG", null, null);
        Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
        int total = codes.size();
        int count = 0;
        for (String code : codes) {
            try {
                CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem(code);
                AbstractCRSTest.assertNotNull((Object)crs);
                ++count;
            }
            catch (FactoryException factoryException) {}
        }
    }

    public void testSRSAxisOrder() throws Exception {
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            AbstractCRSTest.assertEquals((String)"EPSG:4326", (String)CRS.toSRS((CoordinateReferenceSystem)crs));
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            CRS.reset((String)"ALL");
            AbstractCRSTest.assertEquals((String)"urn:ogc:def:crs:EPSG::4326", (String)CRS.toSRS((CoordinateReferenceSystem)crs));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        }
    }

    public void testSRSAxisOrder2() throws Exception {
        try {
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            CoordinateReferenceSystem crsEN = CRS.decode((String)"EPSG:4326");
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)crsEN));
            CoordinateReferenceSystem crsNE = CRS.decode((String)"urn:ogc:def:crs:EPSG::4326");
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)crsNE));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        }
    }

    public void testSimilarityTransform() throws Exception {
        CoordinateReferenceSystem tombak = CRS.decode((String)"EPSG:23031", (boolean)true);
        CoordinateReferenceSystem ng39 = CRS.decode((String)"EPSG:25831", (boolean)true);
        double[] src = new double[]{300000.0, 4500000.0};
        double[] dst = new double[2];
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)tombak, (CoordinateReferenceSystem)ng39);
        mt.transform(src, 0, dst, 0, 1);
        AbstractCRSTest.assertEquals((double)299905.06, (double)dst[0], (double)0.001);
        AbstractCRSTest.assertEquals((double)4499796.515, (double)dst[1], (double)0.001);
        mt.inverse().transform(dst, 0, src, 0, 1);
        AbstractCRSTest.assertEquals((double)300000.0, (double)src[0], (double)0.001);
        AbstractCRSTest.assertEquals((double)4500000.0, (double)src[1], (double)0.001);
    }

    public void testOperationSourceTarget() throws Exception {
        CoordinateReferenceSystem source = CRS.decode((String)"EPSG:32638", (boolean)true);
        CoordinateReferenceSystem target = CRS.decode((String)"EPSG:4326", (boolean)false);
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory((boolean)true);
        CoordinateOperation co = coordinateOperationFactory.createOperation(source, target);
        AbstractCRSTest.assertEquals((Object)source, (Object)co.getSourceCRS());
        AbstractCRSTest.assertEquals((Object)target, (Object)co.getTargetCRS());
        source = CRS.decode((String)"EPSG:32638", (boolean)false);
        target = CRS.decode((String)"EPSG:4326", (boolean)true);
        co = coordinateOperationFactory.createOperation(source, target);
        AbstractCRSTest.assertEquals((Object)source, (Object)co.getSourceCRS());
        AbstractCRSTest.assertEquals((Object)target, (Object)co.getTargetCRS());
    }

    public void testNadCon() throws Exception {
        CoordinateReferenceSystem crs4138 = CRS.decode((String)"EPSG:4138");
        CoordinateReferenceSystem crs4326 = CRS.decode((String)"EPSG:4326");
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)crs4138, (CoordinateReferenceSystem)crs4326);
        AbstractCRSTest.assertTrue((boolean)mt.toWKT().contains("NADCON"));
        double[] src = new double[]{56.575, -169.625};
        double[] expected = new double[]{56.576034, -169.62744};
        double[] p = new double[2];
        mt.transform(src, 0, p, 0, 1);
        AbstractCRSTest.assertEquals((double)expected[0], (double)p[0], (double)1.0E-6);
        AbstractCRSTest.assertEquals((double)expected[1], (double)p[1], (double)1.0E-6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSRS() throws Exception {
        try {
            CRS.reset((String)"all");
            System.setProperty("org.geotools.referencing.forceXY", "true");
            AbstractCRSTest.assertEquals((String)"CRS:84", (String)CRS.toSRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            CoordinateReferenceSystem WORLD = CRS.decode((String)"EPSG:4326", (boolean)false);
            AbstractCRSTest.assertEquals((String)"4326", (String)CRS.toSRS((CoordinateReferenceSystem)WORLD, (boolean)true));
            String srs = CRS.toSRS((CoordinateReferenceSystem)WORLD, (boolean)false);
            AbstractCRSTest.assertTrue((String)"EPSG:4326", (srs.contains("EPSG") && srs.contains("4326") ? 1 : 0) != 0);
            CoordinateReferenceSystem WORLD2 = CRS.decode((String)"EPSG:4326", (boolean)true);
            srs = CRS.toSRS((CoordinateReferenceSystem)WORLD2, (boolean)false);
            AbstractCRSTest.assertTrue((String)"EPSG:4326", (srs.contains("EPSG") && srs.contains("4326") ? 1 : 0) != 0);
            CoordinateReferenceSystem WORLD3 = CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)false);
            srs = CRS.toSRS((CoordinateReferenceSystem)WORLD3, (boolean)false);
            AbstractCRSTest.assertTrue((String)"EPSG:4326", (srs.contains("EPSG") && srs.contains("4326") ? 1 : 0) != 0);
            CoordinateReferenceSystem WORLD4 = CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)true);
            srs = CRS.toSRS((CoordinateReferenceSystem)WORLD4, (boolean)false);
            AbstractCRSTest.assertTrue((String)"EPSG:4326", (srs.contains("EPSG") && srs.contains("4326") ? 1 : 0) != 0);
        }
        finally {
            System.getProperties().remove("org.geotools.referencing.forceXY");
        }
        try {
            CRS.reset((String)"all");
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)false)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)true)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)false)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)true)));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        }
        CRS.reset((String)"all");
        AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)false)));
        AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)true)));
        AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)false)));
        AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)true)));
        try {
            CRS.reset((String)"all");
            System.setProperty("org.geotools.referencing.forceXY", "true");
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)false)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326", (boolean)true)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)false)));
            AbstractCRSTest.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:x-ogc:def:crs:EPSG::4326", (boolean)true)));
        }
        finally {
            System.getProperties().remove("org.geotools.referencing.forceXY");
        }
    }

    public void testCRS_CH1903_LV03() throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326", (boolean)false);
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:21781", (boolean)false);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        DirectPosition2D source = new DirectPosition2D(sourceCRS, 46.951082786150465, 7.4386324175389165);
        DirectPosition2D result = new DirectPosition2D();
        transform.transform((DirectPosition)source, (DirectPosition)result);
        AbstractCRSTest.assertEquals((double)600000.0, (double)result.x, (double)0.1);
        AbstractCRSTest.assertEquals((double)200000.0, (double)result.y, (double)0.1);
    }

    public void testGetMapProjection() throws Exception {
        CoordinateReferenceSystem utm32OnLonLat = CRS.decode((String)"EPSG:23032", (boolean)true);
        AbstractCRSTest.assertTrue((boolean)(CRS.getMapProjection((CoordinateReferenceSystem)utm32OnLonLat) instanceof TransverseMercator));
        CoordinateReferenceSystem utm32OnLatLon = CRS.decode((String)"EPSG:23032", (boolean)false);
        AbstractCRSTest.assertTrue((boolean)(CRS.getMapProjection((CoordinateReferenceSystem)utm32OnLatLon) instanceof TransverseMercator));
        CoordinateReferenceSystem nad27Tennessee = CRS.decode((String)"EPSG:2062", (boolean)false);
        AbstractCRSTest.assertTrue((boolean)(CRS.getMapProjection((CoordinateReferenceSystem)nad27Tennessee) instanceof LambertConformal1SP));
    }

    public void testTransformWgs84PolarStereographic() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-180.0, -90.0);
        envelope.add(180.0, 0.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)transformed.getMaximum(0), (double)transformed.getMaximum(1), (double)1.0);
        AbstractCRSTest.assertEquals((double)transformed.getMinimum(0), (double)transformed.getMinimum(1), (double)1.0);
        AbstractCRSTest.assertEquals((double)Math.abs(transformed.getMinimum(0)), (double)transformed.getMaximum(0), (double)1.0);
        AbstractCRSTest.assertEquals((double)transformed.getMaximum(0), (double)1.236739621845986E7, (double)1.0);
    }

    public void testTransformPolarStereographicWgs84() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3031", (boolean)true);
        Envelope2D envelope = new Envelope2D(crs);
        envelope.add(-4223632.8125, -559082.03125);
        envelope.add(5053710.9375, 3347167.96875);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        AbstractCRSTest.assertEquals((double)-180.0, (double)transformed.getMinimum(0), (double)0.0);
        AbstractCRSTest.assertEquals((double)180.0, (double)transformed.getMaximum(0), (double)0.0);
        envelope = new Envelope2D(crs);
        envelope.add(-1.0718812640513E7, -1.0006238053703E7);
        envelope.add(1.2228504561708E7, -344209.75803081);
        transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        AbstractCRSTest.assertEquals((double)-90.0, (double)transformed.getMinimum(1), (double)0.1);
    }

    public void testTransformLambertAzimuthalEqualAreaWgs84() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3574", (boolean)true);
        Envelope2D envelope = new Envelope2D(crs);
        envelope.add(-3142000.0, -3142000.0);
        envelope.add(3142000.0, 3142000.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        AbstractCRSTest.assertEquals((double)-180.0, (double)transformed.getMinimum(0), (double)0.0);
        AbstractCRSTest.assertEquals((double)180.0, (double)transformed.getMaximum(0), (double)0.0);
    }

    public void testTransformLambertAzimuthalEqualAreaWgs84NonPolar() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3035", (boolean)true);
        Envelope2D envelope = new Envelope2D(crs);
        envelope.setFrameFromDiagonal(4029000.0, 2676000.0, 4696500.0, 3567700.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        AbstractCRSTest.assertEquals((double)5.42, (double)transformed.getMinimum(0), (double)0.01);
        AbstractCRSTest.assertEquals((double)15.88, (double)transformed.getMaximum(0), (double)0.01);
    }

    public void testTransformPolarStereographicWgs84FalseOrigin() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3032", (boolean)true);
        Envelope2D envelope = new Envelope2D(crs);
        envelope.add(5900000.0, 5900000.0);
        envelope.add(6100000.0, 6100000.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        AbstractCRSTest.assertEquals((double)-180.0, (double)transformed.getMinimum(0), (double)0.0);
        AbstractCRSTest.assertEquals((double)180.0, (double)transformed.getMaximum(0), (double)0.0);
    }

    public void testTransformPolarStereographicToOther() throws Exception {
        CoordinateReferenceSystem antarcticPs = CRS.decode((String)"EPSG:3031", (boolean)true);
        CoordinateReferenceSystem australianPs = CRS.decode((String)"EPSG:3032", (boolean)true);
        Envelope2D envelope = new Envelope2D(antarcticPs);
        envelope.add(-4223632.8125, -559082.03125);
        envelope.add(5053710.9375, 3347167.96875);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)australianPs);
        AbstractCRSTest.assertEquals((double)transformed.getSpan(0), (double)transformed.getSpan(1), (double)1.0);
        AbstractCRSTest.assertEquals((double)transformed.getMaximum(0), (double)1.2309982175378662E7, (double)1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransformWorldVanDerGrintenI() throws Exception {
        try {
            MapProjection.SKIP_SANITY_CHECKS = true;
            String wkt = "PROJCS[\"World_Van_der_Grinten_I\", \n  GEOGCS[\"GCS_WGS_1984\", \n    DATUM[\"D_WGS_1984\", \n      SPHEROID[\"WGS_1984\", 6378137.0, 298.257223563]], \n    PRIMEM[\"Greenwich\", 0.0], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Longitude\", EAST], \n    AXIS[\"Latitude\", NORTH]], \n  PROJECTION[\"World_Van_der_Grinten_I\"], \n  PARAMETER[\"central_meridian\", 0.0], \n  PARAMETER[\"false_easting\", 0.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"x\", EAST], \n  AXIS[\"y\", NORTH], \n  AUTHORITY[\"EPSG\",\"54029\"]]";
            CoordinateReferenceSystem worldVanDerGrinten = CRS.parseWKT((String)wkt);
            Envelope2D envelope = new Envelope2D(worldVanDerGrinten);
            envelope.add(-3.9842778796051726E7, -4.230655287521737E7);
            envelope.add(4.006116289695589E7, 3.775375660975308E7);
            GeneralEnvelope generalEnvelope = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        finally {
            MapProjection.SKIP_SANITY_CHECKS = false;
        }
    }

    public void testTransformSouthEmisphereToStereographic() throws Exception {
        String wkt = "PROJCS[\"NSIDC Sea Ice Polar Stereographic South\",\n    GEOGCS[\"Unspecified datum based upon the Hughes 1980 ellipsoid\",\n        DATUM[\"Not_specified_based_on_Hughes_1980_ellipsoid\",\n            SPHEROID[\"Hughes 1980\",6378273,298.279411123061,\n                AUTHORITY[\"EPSG\",\"7058\"]],\n            AUTHORITY[\"EPSG\",\"6054\"]],\n        PRIMEM[\"Greenwich\",0,\n            AUTHORITY[\"EPSG\",\"8901\"]],\n        UNIT[\"degree\",0.0174532925199433,\n            AUTHORITY[\"EPSG\",\"9122\"]],\n        AUTHORITY[\"EPSG\",\"4054\"]],\n    PROJECTION[\"Polar_Stereographic\"],\n    PARAMETER[\"latitude_of_origin\",-70],\n    PARAMETER[\"central_meridian\",0],\n    PARAMETER[\"scale_factor\",1],\n    PARAMETER[\"false_easting\",0],\n    PARAMETER[\"false_northing\",0],\n    UNIT[\"metre\",1,\n        AUTHORITY[\"EPSG\",\"9001\"]],\n    AXIS[\"X\",EAST],\n    AXIS[\"Y\",NORTH],\n    AUTHORITY[\"EPSG\",\"3412\"]]";
        CoordinateReferenceSystem polar = CRS.parseWKT((String)wkt);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-180.0, -90.0);
        envelope.add(180.0, 0.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)polar);
        AbstractCRSTest.assertEquals((double)-1.271387435620243E7, (double)transformed.getMinimum(0), (double)1000.0);
        AbstractCRSTest.assertEquals((double)-1.271387435620243E7, (double)transformed.getMinimum(1), (double)1000.0);
        AbstractCRSTest.assertEquals((double)1.271387435620243E7, (double)transformed.getMaximum(0), (double)1000.0);
        AbstractCRSTest.assertEquals((double)1.271387435620243E7, (double)transformed.getMaximum(1), (double)1000.0);
    }

    protected boolean isOnline() throws Exception {
        try {
            CRS.decode((String)"EPSG:4326");
            return true;
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            return false;
        }
    }

    public void testNorthPolarStereographicLeftQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-156.0, 0.0);
        envelope.add(-40.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)-1.236739622E7, (double)transformed.getMinimum(0), (double)1.0);
    }

    public void testNorthPolarStereographicRightQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(40.0, 0.0);
        envelope.add(156.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)1.236739622E7, (double)transformed.getMaximum(0), (double)1.0);
    }

    public void testNorthPolarStereographicLeftRightQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-156.0, 0.0);
        envelope.add(156.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)-1.236739622E7, (double)transformed.getMinimum(0), (double)1.0);
        AbstractCRSTest.assertEquals((double)1.236739622E7, (double)transformed.getMaximum(0), (double)1.0);
    }

    public void testNorthPolarStereographicUpQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-200.0, 0.0);
        envelope.add(-160.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)1.236739622E7, (double)transformed.getMaximum(1), (double)1.0);
    }

    public void testNorthPolarStereographicDownQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-20.0, 0.0);
        envelope.add(20.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)-1.236739622E7, (double)transformed.getMinimum(1), (double)1.0);
    }

    public void testNorthPolarStereographicUpDownQuadrant() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3995", (boolean)true);
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        envelope.add(-200.0, 0.0);
        envelope.add(20.0, 48.0);
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        AbstractCRSTest.assertEquals((double)-1.236739622E7, (double)transformed.getMinimum(1), (double)1.0);
        AbstractCRSTest.assertEquals((double)1.236739622E7, (double)transformed.getMaximum(1), (double)1.0);
    }
}

