/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import com.csvreader.CsvReader;
import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.TransformException;
import si.uom.SI;

public final class GeodeticCalculatorTest {
    @Test
    public void testAzimuth() {
        double EPS = 0.2;
        GeodeticCalculator calculator = new GeodeticCalculator();
        Assert.assertTrue((boolean)(calculator.getCoordinateReferenceSystem() instanceof GeographicCRS));
        calculator.setStartingGeographicPoint(12.0, 20.0);
        calculator.setDestinationGeographicPoint(13.0, 20.0);
        Assert.assertEquals((String)"East", (double)90.0, (double)calculator.getAzimuth(), (double)0.2);
        calculator.setDestinationGeographicPoint(12.0, 21.0);
        Assert.assertEquals((String)"North", (double)0.0, (double)calculator.getAzimuth(), (double)0.2);
        calculator.setDestinationGeographicPoint(11.0, 20.0);
        Assert.assertEquals((String)"West", (double)-90.0, (double)calculator.getAzimuth(), (double)0.2);
        calculator.setDestinationGeographicPoint(12.0, 19.0);
        Assert.assertEquals((String)"South", (double)180.0, (double)calculator.getAzimuth(), (double)0.2);
    }

    @Test
    public void testParallel45() {
        double[] DATA = new double[]{0.0, 0.0, 0.0, 11.25, 883.0, 884.0, 22.5, 1762.0, 1768.0, 33.75, 2632.0, 2652.0, 45.0, 3489.0, 3536.0, 56.25, 4327.0, 4419.0, 67.5, 5140.0, 5303.0, 78.75, 5923.0, 6187.0, 90.0, 6667.0, 7071.0, 101.25, 7363.0, 7955.0, 112.5, 8002.0, 8839.0, 123.75, 8573.0, 9723.0, 135.0, 9064.0, 10607.0, 146.25, 9463.0, 11490.0, 157.5, 9758.0, 12374.0, 168.75, 9939.0, 13258.0, 180.0, 10000.0, 14142.0};
        double R = 6366.197723675814;
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.createEllipsoid((String)"Test", (double)6366.197723675814, (double)6366.197723675814, (Unit)MetricPrefix.KILO((Unit)SI.METRE));
        GeodeticCalculator calculator = new GeodeticCalculator((Ellipsoid)ellipsoid);
        calculator.setStartingGeographicPoint(0.0, 45.0);
        for (int i = 0; i < DATA.length; i += 3) {
            calculator.setDestinationGeographicPoint(DATA[i], 45.0);
            double orthodromic = calculator.getOrthodromicDistance();
            Assert.assertEquals((String)"Orthodromic distance", (double)DATA[i + 1], (double)orthodromic, (double)0.75);
            int count = 0;
            double length = 0.0;
            double lastX = Double.NaN;
            double lastY = Double.NaN;
            Shape path = calculator.getGeodeticCurve(1000);
            PathIterator iterator = path.getPathIterator(null, 0.1);
            double[] buffer = new double[6];
            while (!iterator.isDone()) {
                switch (iterator.currentSegment(buffer)) {
                    case 1: {
                        ++count;
                        length += ellipsoid.orthodromicDistance(lastX, lastY, buffer[0], buffer[1]);
                    }
                    case 0: {
                        lastX = buffer[0];
                        lastY = buffer[1];
                        break;
                    }
                    default: {
                        throw new IllegalPathStateException();
                    }
                }
                iterator.next();
            }
            Assert.assertEquals((String)"Segment count", (long)1001L, (long)count);
            Assert.assertEquals((String)"Orthodromic path length", (double)orthodromic, (double)length, (double)1.0E-4);
        }
    }

    @Test
    public void testUsingTransform() throws FactoryException, TransformException {
        DefaultGeographicCRS crs = new DefaultGeographicCRS("Test", (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)new DefaultEllipsoidalCS("Test", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.LONGITUDE));
        GeodeticCalculator calculator = new GeodeticCalculator((CoordinateReferenceSystem)crs);
        Assert.assertSame((Object)crs, (Object)calculator.getCoordinateReferenceSystem());
        double x = 45.0;
        double y = 30.0;
        calculator.setStartingPosition((Position)new DirectPosition2D(45.0, 30.0));
        Point2D point = calculator.getStartingGeographicPoint();
        Assert.assertEquals((double)30.0, (double)point.getX(), (double)1.0E-5);
        Assert.assertEquals((double)45.0, (double)point.getY(), (double)1.0E-5);
        calculator.setDirection(10.0, 100.0);
        DirectPosition position = calculator.getDestinationPosition();
        point = calculator.getDestinationGeographicPoint();
        Assert.assertEquals((double)point.getX(), (double)position.getOrdinate(1), (double)1.0E-5);
        Assert.assertEquals((double)point.getY(), (double)position.getOrdinate(0), (double)1.0E-5);
    }

    @Test
    public void testEquator() {
        Assert.assertTrue((boolean)GeodeticCalculator.class.desiredAssertionStatus());
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(0.0, 0.0);
        double last = Double.NaN;
        for (double x = 0.0; x <= 180.0; x += 0.125) {
            calculator.setDestinationGeographicPoint(x, 0.0);
            double distance = calculator.getOrthodromicDistance() / 1000.0;
            Assert.assertTrue((boolean)(x == 0.0 ? distance == 0.0 : (x < 179.5 ? Math.abs(distance - last - 13.914936) < 2.0E-6 : distance - last < 13.0)));
            last = distance;
        }
    }

    @Test
    public void testGEOT1535() {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(10.0, 40.0);
        calculator.setDestinationGeographicPoint(-175.0, -30.0);
        calculator.setStartingGeographicPoint(180.0, 40.0);
        calculator.setDestinationGeographicPoint(-5.0, -30.0);
    }

    @Test
    public void testGEOT3826() {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(0.0, 0.0);
        calculator.setDestinationGeographicPoint(0.0, 90.0);
        Assert.assertEquals((double)0.0, (double)calculator.getAzimuth(), (double)0.0);
        Assert.assertEquals((double)1.0001966E7, (double)calculator.getOrthodromicDistance(), (double)1.0);
    }

    @Test
    public void testGEOT4207() {
        Point2D.Double startPoint = new Point2D.Double(-33.56099261594231, 1.480512392340082);
        Point2D.Double destPoint = new Point2D.Double(-33.56099261594231, 1.4805123923400947);
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint((Point2D)startPoint);
        calculator.setDestinationGeographicPoint((Point2D)destPoint);
        Assert.assertEquals((double)0.001, (double)calculator.getOrthodromicDistance(), (double)0.001);
    }

    @Test
    public void testGEOT4604() {
        Point2D.Double startPoint = new Point2D.Double(8.54, 47.38);
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint((Point2D)startPoint);
        calculator.setDirection(0.0, 100000.0);
        Point2D dest = calculator.getDestinationGeographicPoint();
        double len = calculator.getOrthodromicDistance();
        Assert.assertEquals((double)100000.0, (double)len, (double)1.0);
        Assert.assertEquals((double)8.54, (double)dest.getX(), (double)1.0E-5);
        Assert.assertEquals((double)48.27938, (double)dest.getY(), (double)1.0E-5);
        calculator.setStartingGeographicPoint((Point2D)startPoint);
        calculator.setDirection(90.0, 100000.0);
        dest = calculator.getDestinationGeographicPoint();
        len = calculator.getOrthodromicDistance();
        Assert.assertEquals((double)100000.0, (double)len, (double)1.0);
        Assert.assertEquals((double)9.86411116, (double)dest.getX(), (double)1.0E-5);
        Assert.assertEquals((double)47.37235197, (double)dest.getY(), (double)1.0E-5);
    }

    @Test
    public void testGEOT6026() {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(0.0, 90.0);
        calculator.setDirection(10.0, 50000.0);
        Point2D dest = calculator.getDestinationGeographicPoint();
        Assert.assertEquals((double)170.0, (double)dest.getX(), (double)1.0E-5);
        Assert.assertEquals((double)89.5523482, (double)dest.getY(), (double)1.0E-5);
    }

    @Test
    @Ignore
    public void testGEOT6077() {
        long start = System.currentTimeMillis();
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(6.95997388, 50.9383611);
        calculator.setDirection(-156.512, 13.04);
        Point2D dest = calculator.getDestinationGeographicPoint();
        long end = System.currentTimeMillis();
        long timeDelta = end - start;
        Assert.assertTrue((timeDelta < 10L ? 1 : 0) != 0);
    }

    @Test
    public void testGetPathAlongLongitude() {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(0.0, 10.0);
        calculator.setDestinationGeographicPoint(0.0, -10.0);
        List path = calculator.getGeodeticPath(19);
        double y = 10.0;
        for (Point2D p : path) {
            Assert.assertEquals((double)y, (double)p.getY(), (double)0.001);
            y -= 1.0;
        }
    }

    @Test
    public void testGetPathAlongLatitude() {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(10.0, 0.0);
        calculator.setDestinationGeographicPoint(-10.0, 0.0);
        List path = calculator.getGeodeticPath(19);
        double x = 10.0;
        for (Point2D p : path) {
            Assert.assertEquals((double)x, (double)p.getX(), (double)0.001);
            x -= 1.0;
        }
    }

    @Test
    public void testVincentyFails() throws FileNotFoundException, IOException {
        InputStream in = TestData.openStream((Object)this, (String)"vincenty.csv");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        CsvReader creader = new CsvReader((Reader)reader);
        creader.setComment('#');
        creader.setUseComments(true);
        while (creader.readRecord()) {
            double lat1 = Double.parseDouble(creader.get(0));
            double lon1 = Double.parseDouble(creader.get(1));
            double lat2 = Double.parseDouble(creader.get(2));
            double lon2 = Double.parseDouble(creader.get(3));
            GeodeticCalculator calculator = new GeodeticCalculator();
            calculator.setStartingGeographicPoint(lon1, lat1);
            calculator.setDestinationGeographicPoint(lon2, lat2);
            double dist = calculator.getOrthodromicDistance();
            Assert.assertTrue((String)"Bad distance calculation", (dist > 0.0 ? 1 : 0) != 0);
        }
    }
}

