/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import org.geotools.referencing.cs.ComparableAxisWrapper;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import si.uom.SI;

public final class ComparableAxisWrapperTest {
    @Test
    public void testSortAxis() {
        ComparableAxisWrapperTest.assertOrdered(new CoordinateSystemAxis[]{DefaultCoordinateSystemAxis.LONGITUDE, DefaultCoordinateSystemAxis.LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT}, new CoordinateSystemAxis[]{DefaultCoordinateSystemAxis.LONGITUDE, DefaultCoordinateSystemAxis.LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT});
        ComparableAxisWrapperTest.assertOrdered(new CoordinateSystemAxis[]{DefaultCoordinateSystemAxis.LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT, DefaultCoordinateSystemAxis.LONGITUDE}, new CoordinateSystemAxis[]{DefaultCoordinateSystemAxis.LONGITUDE, DefaultCoordinateSystemAxis.LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT});
    }

    @Test
    public void testSortDirections() {
        ComparableAxisWrapperTest.assertOrdered(new AxisDirection[]{AxisDirection.NORTH, AxisDirection.UP, AxisDirection.EAST}, new AxisDirection[]{AxisDirection.EAST, AxisDirection.NORTH, AxisDirection.UP});
        ComparableAxisWrapperTest.assertOrdered(new AxisDirection[]{AxisDirection.GEOCENTRIC_Y, AxisDirection.NORTH_NORTH_WEST, AxisDirection.GEOCENTRIC_X, AxisDirection.NORTH_EAST, AxisDirection.PAST}, new AxisDirection[]{AxisDirection.NORTH_EAST, AxisDirection.NORTH_NORTH_WEST, AxisDirection.GEOCENTRIC_Y, AxisDirection.GEOCENTRIC_X, AxisDirection.PAST});
        ComparableAxisWrapperTest.assertOrdered(new AxisDirection[]{AxisDirection.SOUTH, AxisDirection.DOWN, AxisDirection.WEST}, new AxisDirection[]{AxisDirection.WEST, AxisDirection.SOUTH, AxisDirection.DOWN});
        ComparableAxisWrapperTest.assertOrdered(new AxisDirection[]{AxisDirection.SOUTH, AxisDirection.DOWN, AxisDirection.EAST}, new AxisDirection[]{AxisDirection.SOUTH, AxisDirection.EAST, AxisDirection.DOWN});
    }

    private static void assertOrdered(CoordinateSystemAxis[] toTest, CoordinateSystemAxis[] expected) {
        boolean same = Arrays.equals(toTest, expected);
        Assert.assertEquals((Object)(!same ? 1 : 0), (Object)ComparableAxisWrapper.sort((CoordinateSystemAxis[])toTest));
        Assert.assertTrue((boolean)Arrays.equals(toTest, expected));
    }

    private static void assertOrdered(AxisDirection[] toTest, AxisDirection[] expected) {
        ComparableAxisWrapperTest.assertOrdered(ComparableAxisWrapperTest.toAxis(toTest), ComparableAxisWrapperTest.toAxis(expected));
    }

    private static CoordinateSystemAxis[] toAxis(AxisDirection[] directions) {
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[directions.length];
        for (int i = 0; i < directions.length; ++i) {
            axis[i] = new DefaultCoordinateSystemAxis("Test", directions[i], SI.METRE);
        }
        return axis;
    }
}

