/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.cs.AxisDirection;

public final class DirectionAlongMeridianTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testParse() {
        String name = "South along 180 deg";
        DirectionAlongMeridian dir = DirectionAlongMeridian.parse((String)name);
        Assert.assertNotNull((Object)dir);
        Assert.assertEquals((Object)AxisDirection.SOUTH, (Object)dir.baseDirection);
        Assert.assertEquals((double)180.0, (double)dir.meridian, (double)0.0);
        Assert.assertEquals((Object)name, (Object)dir.toString());
        name = "South along 90 deg East";
        dir = DirectionAlongMeridian.parse((String)name);
        Assert.assertNotNull((Object)dir);
        Assert.assertEquals((Object)AxisDirection.SOUTH, (Object)dir.baseDirection);
        Assert.assertEquals((double)90.0, (double)dir.meridian, (double)0.0);
        Assert.assertEquals((Object)name, (Object)dir.toString());
        name = "South along 90 deg West";
        dir = DirectionAlongMeridian.parse((String)name);
        Assert.assertNotNull((Object)dir);
        Assert.assertEquals((Object)AxisDirection.SOUTH, (Object)dir.baseDirection);
        Assert.assertEquals((double)-90.0, (double)dir.meridian, (double)0.0);
        Assert.assertEquals((Object)name, (Object)dir.toString());
        name = "North along 45 deg East";
        dir = DirectionAlongMeridian.parse((String)name);
        Assert.assertNotNull((Object)dir);
        Assert.assertEquals((Object)AxisDirection.NORTH, (Object)dir.baseDirection);
        Assert.assertEquals((double)45.0, (double)dir.meridian, (double)0.0);
        Assert.assertEquals((Object)name, (Object)dir.toString());
    }

    @Test
    public void testOrdering() {
        DirectionAlongMeridianTest.assertOrdered("North along  90 deg East", "North along   0 deg");
        DirectionAlongMeridianTest.assertOrdered("North along  75 deg West", "North along 165 deg West");
        DirectionAlongMeridianTest.assertOrdered("South along  90 deg West", "South along   0 deg");
        DirectionAlongMeridianTest.assertOrdered("South along 180 deg", "South along  90 deg West");
        DirectionAlongMeridianTest.assertOrdered("North along 130 deg West", "North along 140 deg East");
    }

    private static void assertOrdered(String dir1, String dir2) {
        DirectionAlongMeridian m1 = DirectionAlongMeridian.parse((String)dir1);
        DirectionAlongMeridian m2 = DirectionAlongMeridian.parse((String)dir2);
        Assert.assertEquals((double)90.0, (double)m1.getAngle(m2), (double)1.0E-10);
        Assert.assertEquals((double)-90.0, (double)m2.getAngle(m1), (double)1.0E-10);
        Assert.assertEquals((long)-1L, (long)m1.compareTo(m2));
        Assert.assertEquals((long)1L, (long)m2.compareTo(m1));
        Assert.assertFalse((boolean)m1.equals((Object)m2));
    }
}

