/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.referencing.factory.HTTP_URI_Parser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public final class HTTP_URI_ParserTest {
    @Test
    public void testParseUnversioned() throws NoSuchAuthorityCodeException {
        HTTP_URI_Parser parser = HTTP_URI_Parser.buildParser((String)"http://www.opengis.net/def/crs/EPSG/0/4326");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"EPSG", (Object)parser.authority);
        Assert.assertNull((Object)parser.version);
        Assert.assertEquals((Object)"4326", (Object)parser.code);
        Assert.assertEquals((Object)"EPSG:4326", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testParseVersioned() throws NoSuchAuthorityCodeException {
        HTTP_URI_Parser parser = HTTP_URI_Parser.buildParser((String)"http://www.opengis.net/def/crs/EPSG/6.11.2/4326");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"EPSG", (Object)parser.authority);
        Assert.assertEquals((Object)"6.11.2", (Object)parser.version.toString());
        Assert.assertEquals((Object)"4326", (Object)parser.code);
        Assert.assertEquals((Object)"EPSG:4326", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testParseMissingVersion() {
        String uri = "http://www.opengis.net/def/crs/EPSG/4326";
        try {
            HTTP_URI_Parser.buildParser((String)uri);
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)uri, (Object)e.getAuthorityCode());
        }
    }

    @Test
    public void testParseInvalidType() {
        String uri = "http://www.opengis.net/def/does-not-exist/EPSG/0/4326";
        try {
            HTTP_URI_Parser.buildParser((String)uri);
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)uri, (Object)e.getAuthorityCode());
        }
    }
}

