/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.referencing.factory.URN_Parser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public final class URN_ParserTest {
    @Test
    public void testParse() throws NoSuchAuthorityCodeException {
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:CRS:EPSG:6.11.2:4326");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"EPSG", (Object)parser.authority);
        Assert.assertEquals((Object)"6.11.2", (Object)parser.version.toString());
        Assert.assertEquals((Object)"4326", (Object)parser.code);
        Assert.assertEquals((Object)"EPSG:4326", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testParseWithoutVersion() throws NoSuchAuthorityCodeException {
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:CRS:EPSG:4326");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"EPSG", (Object)parser.authority);
        Assert.assertNull((Object)parser.version);
        Assert.assertEquals((Object)"4326", (Object)parser.code);
        Assert.assertEquals((Object)"EPSG:4326", (Object)parser.getAuthorityCode());
        URN_Parser emptyVersionParser = URN_Parser.buildParser((String)"urn:ogc:def:crs:EPSG::4326");
        emptyVersionParser.toString();
        Assert.assertEquals((Object)"crs", (Object)emptyVersionParser.type.name);
        Assert.assertEquals((Object)"EPSG", (Object)emptyVersionParser.authority);
        Assert.assertNull((Object)emptyVersionParser.version);
        Assert.assertEquals((Object)"4326", (Object)emptyVersionParser.code);
        Assert.assertEquals((Object)"EPSG:4326", (Object)emptyVersionParser.getAuthorityCode());
    }

    @Test
    public void testInvalidParse() {
        String urn = "urn:ogcx:def:CRS:EPSG:6.8:4326";
        try {
            URN_Parser.buildParser((String)"urn:ogcx:def:CRS:EPSG:6.8:4326");
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)"urn:ogcx:def:CRS:EPSG:6.8:4326", (Object)e.getAuthorityCode());
        }
    }

    @Test
    public void testInvalidType() {
        String urn = "urn:ogc:def:dummy:EPSG:6.8:4326";
        try {
            URN_Parser.buildParser((String)"urn:ogc:def:dummy:EPSG:6.8:4326");
            Assert.fail();
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.assertEquals((Object)"dummy", (Object)e.getAuthorityCode());
        }
    }

    @Test
    public void testOgcCRS84() throws NoSuchAuthorityCodeException {
        String urn_crs84 = "urn:ogc:def:crs:OGC:1.3:CRS84";
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:crs:OGC:1.3:CRS84");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"CRS", (Object)parser.authority);
        Assert.assertEquals((Object)"1.3", (Object)parser.version.toString());
        Assert.assertEquals((Object)"84", (Object)parser.code);
        Assert.assertEquals((Object)"CRS:84", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testOgcCRS84NoVersion() throws NoSuchAuthorityCodeException {
        String urn_crs84 = "urn:ogc:def:crs:OGC:CRS84";
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:crs:OGC:CRS84");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"CRS", (Object)parser.authority);
        Assert.assertNull((Object)parser.version);
        Assert.assertEquals((Object)"84", (Object)parser.code);
        Assert.assertEquals((Object)"CRS:84", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testAutoLatLon() throws NoSuchAuthorityCodeException {
        String urn_auto = "urn:ogc:def:crs:OGC:1.3:AUTO42002:180:90";
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:crs:OGC:1.3:AUTO42002:180:90");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"AUTO", (Object)parser.authority);
        Assert.assertEquals((Object)"1.3", (Object)parser.version.toString());
        Assert.assertEquals((Object)"42002,180,90", (Object)parser.code);
        Assert.assertEquals((Object)"AUTO:42002,180,90", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testAuto() throws NoSuchAuthorityCodeException {
        String urn_auto = "urn:ogc:def:crs:OGC:1.3:AUTO42002";
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:crs:OGC:1.3:AUTO42002");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"AUTO", (Object)parser.authority);
        Assert.assertEquals((Object)"1.3", (Object)parser.version.toString());
        Assert.assertEquals((Object)"42002", (Object)parser.code);
        Assert.assertEquals((Object)"AUTO:42002", (Object)parser.getAuthorityCode());
    }

    @Test
    public void testAutoNoVersion() throws NoSuchAuthorityCodeException {
        String urn_auto = "urn:ogc:def:crs:OGC:AUTO42002";
        URN_Parser parser = URN_Parser.buildParser((String)"urn:ogc:def:crs:OGC:AUTO42002");
        Assert.assertEquals((Object)"crs", (Object)parser.type.name);
        Assert.assertEquals((Object)"AUTO", (Object)parser.authority);
        Assert.assertNull((Object)parser.version);
        Assert.assertEquals((Object)"42002", (Object)parser.code);
        Assert.assertEquals((Object)"AUTO:42002", (Object)parser.getAuthorityCode());
    }
}

