/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;

public class TestGridShiftLocator
extends AbstractFactory
implements GridShiftLocator {
    static final Logger LOGGER = Logging.getLogger(TestGridShiftLocator.class);

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL locateGrid(String grid) {
        GZIPInputStream is = null;
        FileOutputStream fos = null;
        try {
            URL compressed = ((Object)((Object)this)).getClass().getResource(grid + ".gz");
            if (compressed != null) {
                int read;
                is = new GZIPInputStream(compressed.openStream());
                File out = new File("./target/" + grid);
                fos = new FileOutputStream(out);
                byte[] buf = new byte[1024];
                while ((read = is.read(buf)) > 0) {
                    fos.write(buf, 0, read);
                }
                URL uRL = out.toURI().toURL();
                return uRL;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to unpack the grid", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

