/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.projection.MapProjection;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

public class TransverseMercatorTest {
    @Test
    public void testEpsgExample() throws Exception {
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
        this.parameter(MapProjection.AbstractProvider.SEMI_MAJOR, parameters).setValue(6377563.396);
        this.parameter(MapProjection.AbstractProvider.SEMI_MINOR, parameters).setValue(6356256.91);
        this.parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN, parameters).setValue(this.dmsToDegree(49.0, 0.0, 0.0));
        this.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN, parameters).setValue(-this.dmsToDegree(2.0, 0.0, 0.0));
        this.parameter(MapProjection.AbstractProvider.SCALE_FACTOR, parameters).setValue(0.9996012717);
        this.parameter(MapProjection.AbstractProvider.FALSE_EASTING, parameters).setValue(400000.0);
        this.parameter(MapProjection.AbstractProvider.FALSE_NORTHING, parameters).setValue(-100000.0);
        MathTransform transform = mtFactory.createParameterizedTransform(parameters);
        double[] point = new double[]{this.dmsToDegree(0.0, 30.0, 0.0), this.dmsToDegree(50.0, 30.0, 0.0)};
        double[] expected = new double[]{577274.99, 69740.5};
        double[] forward = new double[2];
        transform.transform(point, 0, forward, 0, 1);
        Assert.assertEquals((double)expected[0], (double)forward[0], (double)0.1);
        Assert.assertEquals((double)expected[1], (double)forward[1], (double)0.1);
        double[] inverse = new double[2];
        transform.inverse().transform(expected, 0, inverse, 0, 1);
        Assert.assertEquals((double)point[0], (double)inverse[0], (double)1.0E-4);
        Assert.assertEquals((double)inverse[1], (double)inverse[1], (double)1.0E-4);
    }

    ParameterValue<?> parameter(ParameterDescriptor<?> param, ParameterValueGroup group) {
        return group.parameter(param.getName().getCode());
    }

    double dmsToDegree(double degrees, double minutes, double seconds) {
        return degrees + (minutes + seconds / 60.0) / 60.0;
    }
}

