/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.Random;
import org.geotools.referencing.operation.builder.LocalizationGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.operation.TransformException;

public final class LocalizationGridTest {
    private static final Random random = new Random(78421369762L);
    private LocalizationGrid grid;
    private static final double[][] GRID_DATA = new double[][]{{74.27344, -37.882812, 72.69531, -38.375, 71.38281, -38.765625, 70.25, -39.085938, 69.25781, -39.359375, 68.375, -39.585938}, {74.27344, -37.875, 72.69531, -38.367188, 71.375, -38.757812, 70.25, -39.078125, 69.25781, -39.34375, 68.36719, -39.578125}, {74.265625, -37.867188, 72.6875, -38.359375, 71.375, -38.75, 70.24219, -39.070312, 69.25, -39.335938, 68.36719, -39.570312}, {74.25781, -37.859375, 72.6875, -38.351562, 71.36719, -38.742188, 70.234375, -39.0625, 69.24219, -39.328125, 68.359375, -39.5625}, {74.25781, -37.851562, 72.67969, -38.34375, 71.359375, -38.734375, 70.234375, -39.054688, 69.24219, -39.320312, 68.359375, -39.546875}, {74.25, -37.84375, 72.671875, -38.335938, 71.359375, -38.726562, 70.22656, -39.039062, 69.234375, -39.3125, 68.35156, -39.539062}};
    private static final double EPS = 1.0E-9;
    private static final double FIT_TOLERANCE = 0.4;

    @Before
    public void setUp() {
        int width = GRID_DATA[0].length / 2;
        int height = GRID_DATA.length;
        this.grid = new LocalizationGrid(width, height);
        for (int j = 0; j < height; ++j) {
            double[] line = GRID_DATA[j];
            Assert.assertEquals((String)"Grid is not square", (long)(width * 2), (long)line.length);
            int offset = 0;
            for (int i = 0; i < width; ++i) {
                this.grid.setLocalizationPoint(i, j, line[offset++], line[offset++]);
            }
        }
    }

    @Test
    public void testProperties() {
        Assert.assertTrue((boolean)this.grid.isMonotonic(false));
        Assert.assertTrue((!this.grid.isMonotonic(true) ? 1 : 0) != 0);
        Assert.assertTrue((!this.grid.isNaN() ? 1 : 0) != 0);
    }

    private double[] getGridCoordinates(boolean real) {
        int width = GRID_DATA[0].length / 2;
        int height = GRID_DATA.length;
        double[] array = new double[width * height * 2];
        int offset = 0;
        for (int j = 0; j < height; ++j) {
            double[] line = GRID_DATA[j];
            Assert.assertEquals((String)"Grid is not square", (long)(width * 2), (long)line.length);
            for (int i = 0; i < width; ++i) {
                array[offset++] = real ? line[i * 2 + 0] : (double)i;
                array[offset++] = real ? line[i * 2 + 1] : (double)j;
            }
        }
        Assert.assertEquals((String)"Grid is not square", (long)(width * height * 2), (long)offset);
        return array;
    }

    private void compare(double[] array, boolean real, double eps) {
        int width = GRID_DATA[0].length / 2;
        int height = GRID_DATA.length;
        int offset = 0;
        for (int j = 0; j < height; ++j) {
            double[] line = GRID_DATA[j];
            Assert.assertEquals((String)"Grid is not square", (long)(width * 2), (long)line.length);
            for (int i = 0; i < width; ++i) {
                Assert.assertEquals((double)(real ? line[i * 2 + 0] : (double)i), (double)array[offset++], (double)eps);
                Assert.assertEquals((double)(real ? line[i * 2 + 1] : (double)j), (double)array[offset++], (double)eps);
            }
        }
        Assert.assertEquals((String)"Grid is not square", (long)(width * height * 2), (long)offset);
    }

    @Test
    public void testDirectTransform() throws TransformException {
        double[] array = this.getGridCoordinates(false);
        this.grid.getMathTransform().transform(array, 0, array, 0, array.length / 2);
        this.compare(array, true, 1.0E-9);
    }

    @Test
    public void testAffineTransform() {
        double[] array = this.getGridCoordinates(false);
        this.grid.getAffineTransform().transform(array, 0, array, 0, array.length / 2);
        this.compare(array, true, 0.4);
    }

    @Test
    public void testInverseTransform() throws TransformException {
        double[] array = this.getGridCoordinates(true);
        this.grid.getMathTransform().inverse().transform(array, 0, array, 0, array.length / 2);
        this.compare(array, false, 1.0E-9);
    }

    @Test
    public void testMathematicalIdentities() {
        int sum_x = 0;
        int sum_y = 0;
        int sum_xx = 0;
        int sum_yy = 0;
        int sum_xy = 0;
        int width = random.nextInt(100) + 5;
        int height = random.nextInt(100) + 5;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                sum_x += x;
                sum_y += y;
                sum_xx += x * x;
                sum_yy += y * y;
                sum_xy += x * y;
            }
        }
        int n = width * height;
        Assert.assertEquals((String)"sum_x", (long)(n * (width - 1) / 2), (long)sum_x);
        Assert.assertEquals((String)"sum_y", (long)(n * (height - 1) / 2), (long)sum_y);
        Assert.assertEquals((String)"sum_xy", (long)(n * (width - 1) * (height - 1) / 4), (long)sum_xy);
        Assert.assertEquals((String)"sum_xx", (double)((double)n * ((double)width - 0.5) * (double)(width - 1) / 3.0), (double)sum_xx, (double)1.0E-6);
        Assert.assertEquals((String)"sum_yy", (double)((double)n * ((double)height - 0.5) * (double)(height - 1) / 3.0), (double)sum_yy, (double)1.0E-6);
    }
}

