/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.IOException;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.wkt.GeoToolsCRSUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.metadata.citation.Citation;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.format.SimpleUnitFormat;

public class GeoToolsUnitFormatTest {
    private UnitFormat epsgUnitFormat = GeoToolsCRSUnitFormat.getInstance((Citation)Citations.EPSG);
    private UnitFormat esriUnitFormat = GeoToolsCRSUnitFormat.getInstance((Citation)Citations.ESRI);

    @Test
    public void testFormatUnitOfQAppendable() throws IOException {
        this.doTestNotModifiedUnits(SI.CELSIUS, this.epsgUnitFormat);
        this.doTestNotModifiedUnits(SI.CELSIUS, this.esriUnitFormat);
    }

    @Test
    public void testFootSurvey() {
        Assert.assertEquals((Object)"Foot_US", (Object)this.esriUnitFormat.format(USCustomary.FOOT_SURVEY));
        Unit unit = this.esriUnitFormat.parse((CharSequence)"Foot_US");
        Assert.assertEquals((Object)USCustomary.FOOT_SURVEY, (Object)unit);
    }

    @Test
    public void testGTDefinedFormats() throws IOException {
        this.doTestFormatForGTDefinedUnits(NonSI.DEGREE_ANGLE, this.epsgUnitFormat, "degree");
        this.doTestFormatForGTDefinedUnits(NonSI.DEGREE_ANGLE, this.esriUnitFormat, "Degree");
        this.doTestFormatForGTDefinedUnits(SI.METRE, this.esriUnitFormat, "Meter");
        this.doTestFormatForGTDefinedUnits(Units.SEXAGESIMAL_DMS, this.epsgUnitFormat, "D.MS");
        this.doTestFormatForGTDefinedUnits(Units.SEXAGESIMAL_DMS, this.esriUnitFormat, "D.MS");
    }

    @Test
    public void testFormatForGTDefinedUnits() throws IOException {
        SimpleUnitFormat unitFormat = SimpleUnitFormat.getInstance();
        this.doTestFormatForGTDefinedUnits(Units.SEXAGESIMAL_DMS, (UnitFormat)unitFormat, "D.MS");
    }

    protected void doTestFormatForGTDefinedUnits(Unit<?> u, UnitFormat unitFormat, String expected) throws IOException {
        StringBuilder appendable = new StringBuilder();
        unitFormat.format(u, (Appendable)appendable);
        Assert.assertEquals((String)"Missing symbol formats", (Object)expected, (Object)((Object)appendable).toString());
    }

    protected void doTestNotModifiedUnits(Unit<?> u, UnitFormat unitFormat) throws IOException {
        StringBuilder appendable = new StringBuilder();
        unitFormat.format(u, (Appendable)appendable);
        Assert.assertEquals((String)"Missing symbol formats", (Object)u.toString(), (Object)((Object)appendable).toString());
    }
}

