/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.junit.Assert;
import org.junit.Test;

public class MatrixTest {
    @Test
    public void testMatrix1() {
        Matrix1 z = new Matrix1(0.0);
        GeneralMatrix Z = new GeneralMatrix((Matrix)z);
        Assert.assertEquals((double)Z.determinate(), (double)z.determinate(), (double)0.0);
        Assert.assertEquals((Object)Z.isAffine(), (Object)z.isAffine());
        Assert.assertEquals((Object)Z.isIdentity(), (Object)z.isIdentity());
        Matrix1 u = new Matrix1(1.0);
        GeneralMatrix U = new GeneralMatrix((Matrix)u);
        Assert.assertEquals((double)U.determinate(), (double)u.determinate(), (double)0.0);
        Assert.assertEquals((Object)U.isAffine(), (Object)u.isAffine());
        Assert.assertEquals((Object)U.isIdentity(), (Object)u.isIdentity());
        Matrix1 m = new Matrix1(3.0);
        GeneralMatrix M = new GeneralMatrix((Matrix)m);
        Assert.assertEquals((double)M.determinate(), (double)m.determinate(), (double)0.0);
        Assert.assertEquals((Object)M.isAffine(), (Object)m.isAffine());
        Assert.assertEquals((Object)M.isIdentity(), (Object)m.isIdentity());
        Matrix1 a = new Matrix1();
        a.add(2.0, (XMatrix)m);
        Assert.assertEquals((double)5.0, (double)a.m00, (double)0.0);
        a.sub(1.0, (Matrix)m);
        Assert.assertEquals((double)-2.0, (double)a.m00, (double)0.0);
        a.mul(2.0, (Matrix)m);
        Assert.assertEquals((double)6.0, (double)a.m00, (double)0.0);
    }

    @Test
    public void testMatrix2() {
        Matrix2 z = new Matrix2(0.0, 0.0, 0.0, 0.0);
        GeneralMatrix Z = new GeneralMatrix((Matrix)z);
        Assert.assertEquals((double)Z.determinate(), (double)z.determinate(), (double)0.0);
        Assert.assertEquals((Object)Z.isAffine(), (Object)z.isAffine());
        Assert.assertEquals((Object)Z.isIdentity(), (Object)z.isIdentity());
        Matrix2 u = new Matrix2();
        GeneralMatrix U = new GeneralMatrix((Matrix)u);
        Assert.assertEquals((double)U.determinate(), (double)u.determinate(), (double)0.0);
        Assert.assertEquals((Object)U.isAffine(), (Object)u.isAffine());
        Assert.assertEquals((Object)U.isIdentity(), (Object)u.isIdentity());
        Matrix2 m = new Matrix2(1.0, 2.0, 3.0, 4.0);
        GeneralMatrix M = new GeneralMatrix((Matrix)m);
        Assert.assertEquals((double)M.determinate(), (double)m.determinate(), (double)0.0);
        Assert.assertEquals((Object)M.isAffine(), (Object)m.isAffine());
        Assert.assertEquals((Object)M.isIdentity(), (Object)m.isIdentity());
        Matrix2 a = new Matrix2();
        a.add(2.0, (XMatrix)m);
        Assert.assertEquals((double)3.0, (double)a.m00, (double)0.0);
        a.sub(1.0, (Matrix)m);
        Assert.assertEquals((double)0.0, (double)a.m00, (double)0.0);
        a.mul(2.0, (Matrix)m);
        Assert.assertEquals((double)2.0, (double)a.m00, (double)0.0);
        double[] array = new double[2];
        m.getColumn(0, array);
        Assert.assertArrayEquals((double[])array, (double[])new double[]{1.0, 3.0}, (double)0.0);
        m.getRow(1, array);
        Assert.assertArrayEquals((double[])array, (double[])new double[]{3.0, 4.0}, (double)0.0);
    }

    @Test
    public void testMatrix3() {
        Matrix3 z = new Matrix3(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        GeneralMatrix Z = new GeneralMatrix((Matrix)z);
        Assert.assertEquals((double)Z.determinate(), (double)z.determinate(), (double)0.0);
        Assert.assertEquals((Object)Z.isAffine(), (Object)z.isAffine());
        Assert.assertEquals((Object)Z.isIdentity(), (Object)z.isIdentity());
        Matrix3 u = new Matrix3();
        GeneralMatrix U = new GeneralMatrix((Matrix)u);
        Assert.assertEquals((double)U.determinate(), (double)u.determinate(), (double)0.0);
        Assert.assertEquals((Object)U.isAffine(), (Object)u.isAffine());
        Assert.assertEquals((Object)U.isIdentity(), (Object)u.isIdentity());
        Matrix3 m = new Matrix3(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 0.0);
        GeneralMatrix M = new GeneralMatrix((Matrix)m);
        Assert.assertEquals((double)M.determinate(), (double)m.determinate(), (double)0.0);
        Assert.assertEquals((Object)M.isAffine(), (Object)m.isAffine());
        Assert.assertEquals((Object)M.isIdentity(), (Object)m.isIdentity());
        Matrix3 a = new Matrix3();
        a.add(2.0, (XMatrix)m);
        Assert.assertEquals((double)3.0, (double)a.mat.a11, (double)0.0);
        a.sub(1.0, (Matrix)m);
        Assert.assertEquals((double)0.0, (double)a.mat.a11, (double)0.0);
        a.mul(2.0, (Matrix)m);
        Assert.assertEquals((double)2.0, (double)a.mat.a11, (double)0.0);
        double[] array = new double[3];
        m.getColumn(0, array);
        Assert.assertArrayEquals((double[])array, (double[])new double[]{1.0, 4.0, 7.0}, (double)0.0);
        m.getRow(1, array);
        Assert.assertArrayEquals((double[])array, (double[])new double[]{4.0, 5.0, 6.0}, (double)0.0);
    }
}

