/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GeostationarySatelliteTest {
    public static final String sphericalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"Custom Geographic CS\",    DATUM[\"Custom Datum\",      SPHEROID[\"Sphere\",6367451.5, 0]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35832548.5],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    UNIT[\"meter\", 1]]";
    public static final String ellipsoidalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"WGS 84\",    DATUM[\"WGS_1984\",      SPHEROID[\"WGS84\",6378137,298.257223563]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.01745329251994328]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35785831.0],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    PARAMETER[\"sweep\",0],    UNIT[\"meter\", 1]]";
    public static final int DIMENSION_X = 0;
    public static final int DIMENSION_Y = 1;
    static CoordinateReferenceSystem sphericalGeosCRS;
    static MathTransform sphericalGeosToGeog;
    static MathTransform geogToSphericalGeos;
    static CoordinateReferenceSystem ellipsoidalGeosCRS;
    static MathTransform ellipsoidalGeosToGeog;
    static MathTransform geogToEllipsoidalGeos;

    @BeforeClass
    public static void setupClass() throws FactoryException, TransformException {
        sphericalGeosCRS = CRS.parseWKT((String)sphericalGeosWKT);
        sphericalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)sphericalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)sphericalGeosCRS).getBaseCRS(), (boolean)true);
        geogToSphericalGeos = sphericalGeosToGeog.inverse();
        ellipsoidalGeosCRS = CRS.parseWKT((String)ellipsoidalGeosWKT);
        ellipsoidalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)ellipsoidalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS).getBaseCRS(), (boolean)true);
        geogToEllipsoidalGeos = ellipsoidalGeosToGeog.inverse();
    }

    @Test
    public void testSpheroidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)sphericalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.58325485E7));
        double sweep = parameters.parameter("sweep").doubleValue();
        MatcherAssert.assertThat((Object)sweep, (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testEllipsoidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)ellipsoidalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.5785831E7));
        double sweep = parameters.parameter("sweep").doubleValue();
        MatcherAssert.assertThat((Object)sweep, (Matcher)CoreMatchers.is((Object)0.0));
    }

    @Test
    public void testEllipsoidProjection() throws Exception {
        double allowedError = 1.0E-10;
        double[] wsg84 = new double[]{-71.391245, 41.766279, -80.452193, -5.547325};
        double[] geos = new double[]{3778584.7403456536, 3762727.556421232, 4779926.185724244, -569498.6040787804};
        double[] actual = new double[wsg84.length];
        geogToEllipsoidalGeos.transform(wsg84, 0, actual, 0, actual.length / 2);
        Assert.assertArrayEquals((double[])geos, (double[])actual, (double)allowedError);
        ellipsoidalGeosToGeog.transform(geos, 0, actual, 0, actual.length / 2);
        Assert.assertArrayEquals((double[])wsg84, (double[])actual, (double)allowedError);
    }

    @Test
    public void testIsGeostationaryCRS() {
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)sphericalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCircumscribeFullDisk_Spheroidal() throws TransformException, FactoryException {
        Bounds circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((String)"Median dim 0 is wrong", (double)0.0, (double)circumscribed.getMedian(0), (double)1.0E-5);
        Assert.assertEquals((String)"Median dim 1 is wrong", (double)0.0, (double)circumscribed.getMedian(1), (double)1.0E-5);
        Position2D p = new Position2D();
        p.setLocation(circumscribed.getMedian(0), circumscribed.getMaximum(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMedian(0), circumscribed.getMinimum(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaximum(0), circumscribed.getMedian(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinimum(0), circumscribed.getMedian(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMedian(0), circumscribed.getMaximum(0) + 1.0);
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMedian(0), circumscribed.getMinimum(1) - 1.0);
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0) - 1.0, circumscribed.getMedian(1));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0) + 1.0, circumscribed.getMedian(1));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0), circumscribed.getMaximum(0));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0), circumscribed.getMinimum(1));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0), circumscribed.getMaximum(0));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0), circumscribed.getMinimum(1));
            sphericalGeosToGeog.transform((Position)p, (Position)p);
        });
    }

    @Test
    public void testCircumscribeFullDisk_Ellipsoidal() throws TransformException, FactoryException {
        Bounds circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Position2D p = new Position2D();
        p.setLocation(circumscribed.getMedian(0), circumscribed.getMaximum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMedian(0), circumscribed.getMinimum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaximum(0), circumscribed.getMedian(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinimum(0), circumscribed.getMedian(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMedian(0), circumscribed.getMaximum(0) + 1.0);
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMedian(0), circumscribed.getMinimum(1) - 1.0);
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0) - 1.0, circumscribed.getMedian(1));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0) + 1.0, circumscribed.getMedian(1));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0), circumscribed.getMaximum(0));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaximum(0), circumscribed.getMinimum(1));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0), circumscribed.getMaximum(0));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinimum(0), circumscribed.getMinimum(1));
            ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        });
    }

    @Test
    public void testInscribeFullDiskEstimate_Spheroidal() throws TransformException, FactoryException {
        Bounds inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Position2D p = new Position2D();
        p.setLocation(inscribed.getMaximum(0), inscribed.getMaximum(0));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaximum(0), inscribed.getMinimum(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinimum(0), inscribed.getMaximum(0));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinimum(0), inscribed.getMinimum(1));
        sphericalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInscribeFullDiskEstimate_Ellipsoidal() throws TransformException, FactoryException {
        Bounds inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((String)"Median dim 0 is wrong", (double)0.0, (double)inscribed.getMedian(0), (double)1.0E-5);
        Assert.assertEquals((String)"Median dim 1 is wrong", (double)0.0, (double)inscribed.getMedian(1), (double)1.0E-5);
        Position2D p = new Position2D();
        p.setLocation(inscribed.getMaximum(0), inscribed.getMaximum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaximum(0), inscribed.getMinimum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinimum(0), inscribed.getMaximum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinimum(0), inscribed.getMinimum(1));
        ellipsoidalGeosToGeog.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((Position)p, (Position)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private void expectProjectionException(Testable testable) {
        this.expectException(ProjectionException.class, testable);
    }

    private <T extends Exception> void expectException(Class<T> clazz, Testable testable) {
        block2: {
            try {
                testable.test();
                Assert.fail((String)String.format("Expected exception, %s, but not thrown", clazz));
            }
            catch (Exception e) {
                if (clazz.isInstance(e)) break block2;
                Assert.fail((String)String.format("Expected exception of %s but got %s", clazz, e.getClass()));
            }
        }
    }

    public static interface Testable {
        public void test() throws Exception;
    }
}

