/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.HashSet;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ScriptRunner;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.projection.CylindricalEqualArea;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.MathTransformParser;
import org.geotools.referencing.wkt.Parser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;

public final class ParserTest {
    @Test
    public void testHardCoded() throws ParseException {
        Parser parser = new Parser();
        String wkt1 = "PROJCS[\"Mercator test\",\n  GEOGCS[\"WGS84\",\n    DATUM[\"WGS84\",\n      SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Longitude\", EAST],\n    AXIS[\"Latitude\", NORTH]],\n  PROJECTION[\"Mercator_1SP\"],\n  PARAMETER[\"central_meridian\", -20.0],\n  PARAMETER[\"scale_factor\", 1.0],\n  PARAMETER[\"false_easting\", 500000.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"m\", 1.0],\n  AXIS[\"x\", EAST],\n  AXIS[\"y\", NORTH]]\n";
        Assert.assertTrue((boolean)Symbols.DEFAULT.containsAxis((CharSequence)wkt1));
        DefaultProjectedCRS crs1 = (DefaultProjectedCRS)parser.parseObject(wkt1);
        String wkt2 = parser.format((Object)crs1);
        DefaultProjectedCRS crs2 = (DefaultProjectedCRS)parser.parseObject(wkt2);
        ParameterValueGroup param = crs1.getConversionFromBase().getParameterValues();
        Assert.assertEquals((Object)crs1, (Object)crs2);
        Assert.assertEquals((Object)"Mercator_1SP", (Object)crs1.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)crs1.getConversionFromBase().getMathTransform().toWKT().startsWith("PARAM_MT[\"Mercator_1SP\""));
        Assert.assertFalse((boolean)wkt2.contains("semi_major"));
        Assert.assertFalse((boolean)wkt2.contains("semi_minor"));
        Assert.assertEquals((String)"semi_major", (double)6378137.0, (double)param.parameter("semi_major").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"semi_minor", (double)6356752.3, (double)param.parameter("semi_minor").doubleValue(), (double)0.1);
        Assert.assertEquals((String)"central_meridian", (double)-20.0, (double)param.parameter("central_meridian").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"scale_factor", (double)1.0, (double)param.parameter("scale_factor").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_easting", (double)500000.0, (double)param.parameter("false_easting").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"false_northing", (double)0.0, (double)param.parameter("false_northing").doubleValue(), (double)1.0E-4);
        wkt1 = "PROJCS[\"Mercator test\",\n  GEOGCS[\"WGS84\",\n    DATUM[\"WGS84\",\n      SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Latitude\", NORTH],\n    AXIS[\"Longitude\", EAST]],\n  PROJECTION[\"Mercator_1SP\"],\n  PARAMETER[\"central_meridian\", -20.0],\n  PARAMETER[\"scale_factor\", 1.0],\n  PARAMETER[\"false_easting\", 500000.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"m\", 1.0],\n  AXIS[\"x\", EAST],\n  AXIS[\"y\", NORTH]]\n";
        Assert.assertTrue((boolean)Symbols.DEFAULT.containsAxis((CharSequence)wkt1));
        crs1 = (DefaultProjectedCRS)parser.parseObject(wkt1);
        wkt2 = parser.format((Object)crs1);
        crs2 = (DefaultProjectedCRS)parser.parseObject(wkt2);
        param = crs1.getConversionFromBase().getParameterValues();
        Assert.assertEquals((Object)crs1, (Object)crs2);
        Assert.assertEquals((Object)"Mercator_1SP", (Object)crs1.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)crs1.getConversionFromBase().getMathTransform().toWKT().startsWith("CONCAT_MT[PARAM_MT["));
        Assert.assertFalse((boolean)wkt2.contains("semi_major"));
        Assert.assertFalse((boolean)wkt2.contains("semi_minor"));
        Assert.assertEquals((String)"semi_major", (double)6378137.0, (double)param.parameter("semi_major").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"semi_minor", (double)6356752.3, (double)param.parameter("semi_minor").doubleValue(), (double)0.1);
        Assert.assertEquals((String)"central_meridian", (double)-20.0, (double)param.parameter("central_meridian").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"scale_factor", (double)1.0, (double)param.parameter("scale_factor").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_easting", (double)500000.0, (double)param.parameter("false_easting").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"false_northing", (double)0.0, (double)param.parameter("false_northing").doubleValue(), (double)1.0E-4);
        wkt1 = "PROJCS[\"OSGB 1936 / British National Grid\",\n  GEOGCS[\"OSGB 1936\",\n    DATUM[\"OSGB_1936\",\n      SPHEROID[\"Airy 1830\", 6377563.396, 299.3249646, AUTHORITY[\"EPSG\",\"7001\"]],\n      TOWGS84[375.0, -111.0, 431.0, 0.0, 0.0, 0.0, 0.0],\n      AUTHORITY[\"EPSG\",\"6277\"]],\n    PRIMEM[\"Greenwich\",0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n    AXIS[\"Lat\",NORTH],AXIS[\"Long\",EAST], AUTHORITY[\"EPSG\",\"4277\"]],\n  PROJECTION[\"Transverse_Mercator\"],\n  PARAMETER[\"latitude_of_origin\", 49.0],\n  PARAMETER[\"central_meridian\", -2.0],\n  PARAMETER[\"scale_factor\", 0.999601272],\n  PARAMETER[\"false_easting\", 400000.0],\n  PARAMETER[\"false_northing\", -100000.0],\n  UNIT[\"metre\", 1.0, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"E\",EAST],\n  AXIS[\"N\",NORTH],\n  AUTHORITY[\"EPSG\",\"27700\"]]\n";
        Assert.assertTrue((boolean)Symbols.DEFAULT.containsAxis((CharSequence)wkt1));
        crs1 = (DefaultProjectedCRS)parser.parseObject(wkt1);
        wkt2 = parser.format((Object)crs1);
        crs2 = (DefaultProjectedCRS)parser.parseObject(wkt2);
        param = crs1.getConversionFromBase().getParameterValues();
        Assert.assertEquals((Object)crs1, (Object)crs2);
        Assert.assertFalse((boolean)wkt2.contains("semi_major"));
        Assert.assertFalse((boolean)wkt2.contains("semi_minor"));
        Assert.assertEquals((Object)"Transverse_Mercator", (Object)crs1.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertEquals((String)"semi_major", (double)6377563.396, (double)param.parameter("semi_major").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"semi_minor", (double)6356256.909, (double)param.parameter("semi_minor").doubleValue(), (double)0.001);
        Assert.assertEquals((String)"latitude_of_origin", (double)49.0, (double)param.parameter("latitude_of_origin").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"central_meridian", (double)-2.0, (double)param.parameter("central_meridian").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"scale_factor", (double)0.9996, (double)param.parameter("scale_factor").doubleValue(), (double)1.0E-5);
        Assert.assertEquals((String)"false_easting", (double)400000.0, (double)param.parameter("false_easting").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"false_northing", (double)-100000.0, (double)param.parameter("false_northing").doubleValue(), (double)1.0E-4);
        wkt1 = "PROJCS[\"TransverseMercator\",\n  GEOGCS[\"Sphere\",\n    DATUM[\"Sphere\",\n      SPHEROID[\"Sphere\", 6370997.0, 0.0],\n      TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Longitude\", EAST],\n    AXIS[\"Latitude\", NORTH]],\n  PROJECTION[\"Transverse_Mercator\",\n    AUTHORITY[\"OGC\",\"Transverse_Mercator\"]],\n  PARAMETER[\"central_meridian\", 170.0],\n  PARAMETER[\"latitude_of_origin\", 50.0],\n  PARAMETER[\"scale_factor\", 0.95],\n  PARAMETER[\"false_easting\", 0.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"feet\", 0.304800609601219],\n  AXIS[\"x\", EAST],\n  AXIS[\"y\", NORTH]]\n";
        Assert.assertTrue((boolean)Symbols.DEFAULT.containsAxis((CharSequence)wkt1));
        crs1 = (DefaultProjectedCRS)parser.parseObject(wkt1);
        wkt2 = parser.format((Object)crs1);
        crs2 = (DefaultProjectedCRS)parser.parseObject(wkt2);
        param = crs1.getConversionFromBase().getParameterValues();
        Assert.assertEquals((Object)crs1, (Object)crs2);
        Assert.assertFalse((boolean)wkt2.contains("semi_major"));
        Assert.assertFalse((boolean)wkt2.contains("semi_minor"));
        Assert.assertEquals((Object)"Transverse_Mercator", (Object)crs1.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertEquals((String)"semi_major", (double)6370997.0, (double)param.parameter("semi_major").doubleValue(), (double)1.0E-5);
        Assert.assertEquals((String)"semi_minor", (double)6370997.0, (double)param.parameter("semi_minor").doubleValue(), (double)1.0E-5);
        Assert.assertEquals((String)"latitude_of_origin", (double)50.0, (double)param.parameter("latitude_of_origin").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"central_meridian", (double)170.0, (double)param.parameter("central_meridian").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"scale_factor", (double)0.95, (double)param.parameter("scale_factor").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_easting", (double)0.0, (double)param.parameter("false_easting").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_northing", (double)0.0, (double)param.parameter("false_northing").doubleValue(), (double)1.0E-8);
        wkt1 = "GEOGCS[\"NAD83 / NFIS Seconds\",DATUM[\"North_American_Datum_1983\",\n  SPHEROID[\"GRS 1980\", 6378137, 298.257222101]],\n  PRIMEM[\"Greenwich\", 0],\n  UNIT[\"Decimal_Second\", 4.84813681109536e-06],\n  AUTHORITY[\"EPSG\", \"100001\"]]";
        Assert.assertFalse((boolean)Symbols.DEFAULT.containsAxis((CharSequence)wkt1));
        wkt2 = parser.format(parser.parseObject(wkt1));
        Assert.assertFalse((boolean)wkt2.contains("semi_major"));
        Assert.assertFalse((boolean)wkt2.contains("semi_minor"));
    }

    @Test
    public void testOracleWKT() throws ParseException {
        String wkt = "PROJCS[\"Datum 73 / Modified Portuguese Grid\", GEOGCS [ \"Datum 73\", DATUM[\"Datum 73 (EPSG ID 6274)\", SPHEROID [\"International 1924 (EPSG ID 7022)\", 6378388, 297], -231, 102.6, 29.8, .6149999999999993660366746131394108039579, -.1979999999999997958947342656936639661522, .8809999999999990918346509498793836069706, .99999821], PRIMEM [ \"Greenwich\", 0.000000 ], UNIT [\"Decimal Degree\", 0.01745329251994328]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"Latitude_Of_Origin\", 39.66666666666666666666666666666666666667], PARAMETER[\"Central_Meridian\", -8.13190611111111111111111111111111111111], PARAMETER[\"Scale_Factor\", 1], PARAMETER [\"False_Easting\", 180.598], PARAMETER[\"False_Northing\", -86.99], UNIT [\"Meter\", 1]]";
        Assert.assertFalse((boolean)Symbols.DEFAULT.containsAxis((CharSequence)"PROJCS[\"Datum 73 / Modified Portuguese Grid\", GEOGCS [ \"Datum 73\", DATUM[\"Datum 73 (EPSG ID 6274)\", SPHEROID [\"International 1924 (EPSG ID 7022)\", 6378388, 297], -231, 102.6, 29.8, .6149999999999993660366746131394108039579, -.1979999999999997958947342656936639661522, .8809999999999990918346509498793836069706, .99999821], PRIMEM [ \"Greenwich\", 0.000000 ], UNIT [\"Decimal Degree\", 0.01745329251994328]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"Latitude_Of_Origin\", 39.66666666666666666666666666666666666667], PARAMETER[\"Central_Meridian\", -8.13190611111111111111111111111111111111], PARAMETER[\"Scale_Factor\", 1], PARAMETER [\"False_Easting\", 180.598], PARAMETER[\"False_Northing\", -86.99], UNIT [\"Meter\", 1]]"));
        Parser parser = new Parser();
        CoordinateReferenceSystem crs1 = parser.parseCoordinateReferenceSystem("PROJCS[\"Datum 73 / Modified Portuguese Grid\", GEOGCS [ \"Datum 73\", DATUM[\"Datum 73 (EPSG ID 6274)\", SPHEROID [\"International 1924 (EPSG ID 7022)\", 6378388, 297], -231, 102.6, 29.8, .6149999999999993660366746131394108039579, -.1979999999999997958947342656936639661522, .8809999999999990918346509498793836069706, .99999821], PRIMEM [ \"Greenwich\", 0.000000 ], UNIT [\"Decimal Degree\", 0.01745329251994328]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"Latitude_Of_Origin\", 39.66666666666666666666666666666666666667], PARAMETER[\"Central_Meridian\", -8.13190611111111111111111111111111111111], PARAMETER[\"Scale_Factor\", 1], PARAMETER [\"False_Easting\", 180.598], PARAMETER[\"False_Northing\", -86.99], UNIT [\"Meter\", 1]]");
        String check = parser.format((Object)crs1);
        Assert.assertTrue((check.indexOf("TOWGS84[-231") >= 0 ? 1 : 0) != 0);
        CoordinateReferenceSystem crs2 = parser.parseCoordinateReferenceSystem(check);
        Assert.assertEquals((Object)crs1, (Object)crs2);
        Assert.assertFalse((boolean)check.contains("semi_major"));
        Assert.assertFalse((boolean)check.contains("semi_minor"));
    }

    @Test
    public void testCustomAxisLength() throws FactoryException, ParseException {
        DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
        ParameterValueGroup parameters = factory.getDefaultParameters("Lambert_Conformal_Conic_2SP");
        double majorAxis = 6371200.0;
        double minorAxis = 6371200.0;
        parameters.parameter("semi_major").setValue(6371200.0);
        parameters.parameter("semi_minor").setValue(6371200.0);
        parameters.parameter("latitude_of_origin").setValue(25.0);
        parameters.parameter("standard_parallel_1").setValue(25.0);
        parameters.parameter("standard_parallel_2").setValue(25.0);
        parameters.parameter("longitude_of_origin").setValue(-95.0);
        parameters.parameter("false_easting").setValue(0.0);
        parameters.parameter("false_northing").setValue(0.0);
        DefaultGeographicCRS base = DefaultGeographicCRS.WGS84;
        MathTransform mt = factory.createParameterizedTransform(parameters);
        DefaultCartesianCS cs = DefaultCartesianCS.PROJECTED;
        DefaultProjectedCRS crs = new DefaultProjectedCRS("Lambert", (GeographicCRS)base, mt, (CartesianCS)cs);
        String wkt = crs.toWKT();
        Assert.assertTrue((boolean)wkt.contains("semi_major"));
        Assert.assertTrue((boolean)wkt.contains("semi_minor"));
        Parser parser = new Parser();
        CoordinateReferenceSystem check = parser.parseCoordinateReferenceSystem(wkt);
        Assert.assertEquals((Object)wkt, (Object)check.toWKT());
    }

    @Test
    public void testCylindricalEqualAreaStandardParallel() throws FactoryException {
        CylindricalEqualArea.LambertCylindricalEqualAreaProvider lambertCylindricalEqualAreaProvider = new CylindricalEqualArea.LambertCylindricalEqualAreaProvider();
        DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
        ParameterDescriptorGroup parameterDescriptorGroup = lambertCylindricalEqualAreaProvider.getParameters();
        ParameterValueGroup parameters = parameterDescriptorGroup.createValue();
        double majorAxis = 6371200.0;
        double minorAxis = 6371200.0;
        parameters.parameter("semi_major").setValue(6371200.0);
        parameters.parameter("semi_minor").setValue(6371200.0);
        parameters.parameter("longitude_of_origin").setValue(25.0);
        parameters.parameter("standard_parallel_1").setValue(22.2);
        parameters.parameter("false_easting").setValue(0.0);
        parameters.parameter("false_northing").setValue(0.0);
        DefaultGeographicCRS base = DefaultGeographicCRS.WGS84;
        MathTransform mt = factory.createParameterizedTransform(parameters);
        DefaultCartesianCS cs = DefaultCartesianCS.PROJECTED;
        DefaultProjectedCRS crs = new DefaultProjectedCRS("Cylindrical_Equal_Area", (GeographicCRS)base, mt, (CartesianCS)cs);
        String wkt = crs.toWKT();
        Assert.assertTrue((boolean)wkt.contains("standard_parallel_1"));
        Assert.assertTrue((boolean)wkt.contains("22.2"));
    }

    @Test
    public void testMathTransform() throws IOException, ParseException {
        this.testParsing((AbstractParser)new MathTransformParser(), "wkt/MathTransform.txt");
    }

    @Test
    public void testCoordinateReferenceSystem() throws IOException, ParseException {
        this.testParsing((AbstractParser)new Parser(), "wkt/CoordinateReferenceSystem.txt");
    }

    private void testParsing(AbstractParser parser, String filename) throws IOException, ParseException {
        try (LineNumberReader reader = TestData.openReader(ScriptRunner.class, (String)filename);){
            String line;
            HashSet<Object> pool = new HashSet<Object>();
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                Object parsed = parser.parseObject(line);
                Assert.assertNotNull((String)"Parsing returns null.", (Object)parsed);
                Assert.assertEquals((String)"Inconsistent equals method", (Object)parsed, (Object)parsed);
                Assert.assertSame((String)"Parsing twice returns different objects.", (Object)parsed, (Object)parser.parseObject(line));
                Assert.assertTrue((String)"An identical object already exists.", (boolean)pool.add(parsed));
                Assert.assertTrue((String)"Inconsistent hashCode or equals method.", (boolean)pool.contains(parsed));
                String formatted = parser.format(parsed);
                Object again = parser.parseObject(formatted);
                Assert.assertEquals((String)"Second parsing produced different objects", (Object)parsed, (Object)again);
                Assert.assertTrue((String)"Inconsistent hashCode or equals method.", (boolean)pool.contains(again));
            }
        }
    }

    @Test
    public void testAuthorityCodeParsing() throws IOException, ParseException {
        this.testParsing((AbstractParser)new Parser(), "wkt/AuthorityCode.txt");
    }

    @Test
    public void test404000Parsing() throws IOException, ParseException, NoSuchAuthorityCodeException, FactoryException {
        String wkt = "LOCAL_CS[\"Wildcard 2D cartesian plane in metric unit\", \n  LOCAL_DATUM[\"Unknown\", 0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"x\", EAST], \n  AXIS[\"y\", NORTH], \n  AUTHORITY[\"EPSG\",\"404000\"]]";
        Parser parser = new Parser();
        CoordinateReferenceSystem observed = parser.parseCoordinateReferenceSystem("LOCAL_CS[\"Wildcard 2D cartesian plane in metric unit\", \n  LOCAL_DATUM[\"Unknown\", 0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"x\", EAST], \n  AXIS[\"y\", NORTH], \n  AUTHORITY[\"EPSG\",\"404000\"]]");
        String check = parser.format((Object)observed);
        CoordinateReferenceSystem expected = CRS.decode((String)"EPSG:404000");
        Assert.assertTrue((String)"Internal CS", (boolean)CRS.equalsIgnoreMetadata((Object)expected.getCoordinateSystem(), (Object)observed.getCoordinateSystem()));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)expected, (Object)observed));
        Assert.assertEquals((Object)expected, (Object)observed);
        Assert.assertEquals((String)"Incorrect reading", (Object)expected, (Object)observed);
        Assert.assertFalse((boolean)check.contains("semi_major"));
        Assert.assertFalse((boolean)check.contains("semi_minor"));
    }

    @Test
    public void testExtension() throws IOException, ParseException {
        this.testParsing((AbstractParser)new Parser(), "wkt/Extension.txt");
    }
}

