/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public final class GeneralBoundsTest {
    @Test
    public void testConstruction() {
        GeneralBounds empty = new GeneralBounds((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertTrue((boolean)empty.isEmpty());
        GeneralBounds empty2d = new GeneralBounds((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertTrue((boolean)empty2d.isEmpty());
        GeneralBounds world = new GeneralBounds(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        world.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeneralBounds copyWorld = new GeneralBounds((Bounds)world);
        Assert.assertEquals((Object)world, (Object)copyWorld);
        GeneralBounds copyEmpty = new GeneralBounds((Bounds)empty);
        Assert.assertEquals((Object)empty, (Object)copyEmpty);
        GeneralBounds nil = new GeneralBounds((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        nil.setToNull();
        Assert.assertTrue((boolean)nil.isNull());
        GeneralBounds copyNil = new GeneralBounds((Bounds)nil);
        Assert.assertTrue((boolean)copyNil.isNull());
        Assert.assertEquals((Object)nil, (Object)copyNil);
        GeneralBounds nil2 = new GeneralBounds((Bounds)nil);
        GeneralBounds copyNil2 = new GeneralBounds((Bounds)nil2);
        Assert.assertTrue((boolean)copyNil2.isNull());
        GeneralBounds geot3045 = new GeneralBounds(new double[]{0.0, 0.0}, new double[]{-1.0, -1.0});
        Assert.assertTrue((boolean)geot3045.isEmpty());
        GeneralBounds geot4261 = new GeneralBounds(2);
        GeneralPosition dp = new GeneralPosition(new double[]{100.0, 200.0});
        Assert.assertTrue((boolean)geot4261.isEmpty());
        geot4261.add((Position)dp);
        Assert.assertEquals((Object)new GeneralBounds(dp, dp), (Object)geot4261);
    }

    @Test
    public void testEquals() {
        GeneralBounds e1 = new GeneralBounds(4);
        Assert.assertTrue((boolean)e1.isEmpty());
        Assert.assertTrue((boolean)e1.isNull());
        Assert.assertEquals((Object)e1.getLowerCorner(), (Object)e1.getUpperCorner());
        int i = e1.getDimension();
        while (--i >= 0) {
            e1.setRange(i, (double)(i * 5 + 2), (double)(i * 6 + 5));
        }
        Assert.assertFalse((boolean)e1.isNull());
        Assert.assertFalse((boolean)e1.isEmpty());
        Assert.assertNotEquals((Object)e1.getLowerCorner(), (Object)e1.getUpperCorner());
        GeneralBounds e2 = new GeneralBounds((Bounds)e1);
        GeneralBoundsTest.assertPositionEquals(e1.getLowerCorner(), e2.getLowerCorner());
        GeneralBoundsTest.assertPositionEquals(e1.getUpperCorner(), e2.getUpperCorner());
        Assert.assertTrue((boolean)e1.contains((Bounds)e2, true));
        Assert.assertFalse((boolean)e1.contains((Bounds)e2, false));
        Assert.assertNotSame((Object)e1, (Object)e2);
        Assert.assertEquals((Object)e1, (Object)e2);
        Assert.assertTrue((boolean)e1.equals((Bounds)e2, 1.0E-4, true));
        Assert.assertTrue((boolean)e1.equals((Bounds)e2, 1.0E-4, false));
        Assert.assertEquals((long)e1.hashCode(), (long)e2.hashCode());
        e2.setRange(2, e2.getMinimum(2) + 3.0E-5, e2.getMaximum(2) - 3.0E-5);
        Assert.assertTrue((boolean)e1.contains((Bounds)e2, true));
        Assert.assertFalse((boolean)e1.contains((Bounds)e2, false));
        Assert.assertNotEquals((Object)e1, (Object)e2);
        Assert.assertTrue((boolean)e1.equals((Bounds)e2, 1.0E-4, true));
        Assert.assertTrue((boolean)e1.equals((Bounds)e2, 1.0E-4, false));
        Assert.assertNotEquals((long)e1.hashCode(), (long)e2.hashCode());
        e2.setRange(1, e2.getMinimum(1) + 3.0, e2.getMaximum(1) - 3.0);
        Assert.assertTrue((boolean)e1.contains((Bounds)e2, true));
        Assert.assertFalse((boolean)e1.contains((Bounds)e2, false));
        Assert.assertNotEquals((Object)e1, (Object)e2);
        Assert.assertFalse((boolean)e1.equals((Bounds)e2, 1.0E-4, true));
        Assert.assertFalse((boolean)e1.equals((Bounds)e2, 1.0E-4, false));
        Assert.assertNotEquals((long)e1.hashCode(), (long)e2.hashCode());
    }

    private static void assertPositionEquals(Position p1, Position p2) {
        Assert.assertNotSame((Object)p1, (Object)p2);
        Assert.assertEquals((Object)p1, (Object)p2);
        Assert.assertEquals((long)p1.hashCode(), (long)p2.hashCode());
    }

    @Test
    public void testMedian() {
        double delta = 1.0E-5;
        GeneralBounds bounds = new GeneralBounds((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        bounds.setEnvelope(new double[]{-10.0, -10.0, 10.0, 10.0});
        Assert.assertEquals((double)0.0, (double)bounds.getMedian(0), (double)delta);
        Assert.assertEquals((double)0.0, (double)bounds.getMedian(1), (double)delta);
    }
}

