/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.measure.Units;
import org.junit.Assert;
import org.junit.Test;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.TransformedUnit;

public class UnitsTest {
    private static double US_SURVEY_FOOT_FACTORY = 0.3048006096012192;
    private static final double US_SURVEY_FOOT_COMPARISON_EPSILON = 1.0E-10;
    private static final double RADIAN_TO_DEGREE_RATIO = Math.PI / 180;
    private static final double DEEGREE_RATIO_COMPARISON_EPSILON = 1.0E-15;

    private static <Q extends Quantity<Q>> void checkConversion(double expected, Unit<Q> unitExpected, double actual, Unit<Q> unitActual) {
        UnitConverter converter = unitActual.getConverterTo(unitExpected);
        Assert.assertEquals((double)expected, (double)converter.convert(actual), (double)1.0E-6);
        converter = converter.inverse();
        Assert.assertEquals((double)actual, (double)converter.convert(expected), (double)1.0E-6);
    }

    @Test
    public void testSexagesimal() {
        UnitsTest.checkConversion(10.0, NonSI.DEGREE_ANGLE, 10.0, Units.SEXAGESIMAL_DMS);
        UnitsTest.checkConversion(10.01, NonSI.DEGREE_ANGLE, 10.0036, Units.SEXAGESIMAL_DMS);
        UnitsTest.checkConversion(10.5, NonSI.DEGREE_ANGLE, 10.3, Units.SEXAGESIMAL_DMS);
        UnitsTest.checkConversion(10.99, NonSI.DEGREE_ANGLE, 10.5924, Units.SEXAGESIMAL_DMS);
    }

    private static Object serialize(Object object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(object);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object read = in.readObject();
        in.close();
        return read;
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        Assert.assertEquals((Object)NonSI.DEGREE_ANGLE, (Object)UnitsTest.serialize(NonSI.DEGREE_ANGLE));
        Assert.assertEquals((Object)Units.SEXAGESIMAL_DMS, (Object)UnitsTest.serialize(Units.SEXAGESIMAL_DMS));
        Assert.assertEquals((Object)Units.DEGREE_MINUTE_SECOND, (Object)UnitsTest.serialize(Units.DEGREE_MINUTE_SECOND));
        Assert.assertEquals((Object)Units.PPM, (Object)UnitsTest.serialize(Units.PPM));
    }

    @Test
    public void testUnitsMatch1() {
        Unit degree = Units.autoCorrect((Unit)new TransformedUnit(SI.RADIAN, MultiplyConverter.ofPiExponent((int)1).concatenate((UnitConverter)MultiplyConverter.ofRational((long)1L, (long)180L))));
        Assert.assertEquals((String)"auto correction of degree definition from JSR 385", (Object)NonSI.DEGREE_ANGLE, (Object)degree);
        Assert.assertTrue((String)"JSR 385 degree definition", (boolean)UnitsTest.isDegreeAngle(degree));
    }

    @Test
    public void testUnitsMatch2() {
        Unit degree = Units.autoCorrect((Unit)new TransformedUnit(SI.RADIAN, (UnitConverter)MultiplyConverter.of((double)(Math.PI / 180))));
        Assert.assertEquals((String)"auto correction of degree definition from EsriLookupTest", (Object)NonSI.DEGREE_ANGLE, (Object)degree);
        Assert.assertTrue((String)"degree definition from EsriLookupTest", (boolean)UnitsTest.isDegreeAngle(degree));
    }

    @Test
    public void testUnitsMatch3() {
        Unit feet = Units.autoCorrect((Unit)SI.METRE.multiply(1200.0).divide(3937.0));
        Assert.assertEquals((String)"auto correction of US Survey definition from EsriLookupTest", (Object)USCustomary.FOOT_SURVEY, (Object)feet);
        Assert.assertTrue((String)"survey foot definition from EsriLookupTest", (boolean)UnitsTest.isUSSurveyFoot(feet));
    }

    public static final boolean isUSSurveyFoot(Unit<?> unit) {
        MultiplyConverter multiplyConverter;
        double factor;
        TransformedUnit transformed;
        UnitConverter converter;
        if (unit == null) {
            return false;
        }
        if (USCustomary.FOOT_SURVEY.equals(unit)) {
            return true;
        }
        return unit.getSystemUnit() == SI.METRE && unit instanceof TransformedUnit && (converter = (transformed = (TransformedUnit)unit).getConverter()) instanceof MultiplyConverter && Math.abs(US_SURVEY_FOOT_FACTORY - (factor = (multiplyConverter = (MultiplyConverter)converter).getFactor().doubleValue())) < 1.0E-10;
    }

    public static final boolean isDegreeAngle(Unit<?> unit) {
        MultiplyConverter multiplyConverter;
        double factor;
        TransformedUnit transformed;
        UnitConverter converter;
        if (unit == null) {
            return false;
        }
        if (NonSI.DEGREE_ANGLE.equals(unit)) {
            return true;
        }
        return unit.getSystemUnit() == SI.RADIAN && unit instanceof TransformedUnit && (converter = (transformed = (TransformedUnit)unit).getConverter()) instanceof MultiplyConverter && Math.abs(Math.PI / 180 - (factor = (multiplyConverter = (MultiplyConverter)converter).getFactor().doubleValue())) < 1.0E-15;
    }
}

