/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.epsg.CoordinateOperationFactoryUsingWKT;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinateOperationFactoryUsingWKTTest {
    CoordinateOperationFactoryUsingWKT factory;
    private static final String DEFINITIONS_FILE_NAME = "epsg_operations.properties";
    private static Properties properties;
    private static final String SOURCE_CRS = "EPSG:TEST1";
    private static final String TARGET_CRS = "EPSG:TEST2";
    private static final String CRS_PAIR = "EPSG:TEST1,EPSG:TEST2";
    private static final String INVERSE_CRS_PAIR = "EPSG:TEST2,EPSG:TEST1";
    private static final String INVALID_CRS = "nonexistent";
    private static final double[] SRC_TEST_POINT;
    private static final double[] DST_TEST_POINT;

    @Before
    public void setUp() throws Exception {
        ReferencingFactoryFinder.addAuthorityFactory((AuthorityFactory)new FactoryUsingWKT(null, 100));
        this.factory = (CoordinateOperationFactoryUsingWKT)ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, CoordinateOperationFactoryUsingWKT.class));
        properties = new Properties();
        properties.load(this.getClass().getResourceAsStream(DEFINITIONS_FILE_NAME));
    }

    @Test
    public void testExtraDirectoryHint() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, CoordinateOperationFactoryUsingWKT.class);
        try {
            hints.put((Object)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, (Object)"invalid");
            Assert.fail((String)"Should of been tossed out as an invalid hint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String directory = new File(".").getAbsolutePath();
        hints = new Hints((RenderingHints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, CoordinateOperationFactoryUsingWKT.class);
        hints.put((Object)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, (Object)directory);
        CoordinateOperationFactoryUsingWKT fact = (CoordinateOperationFactoryUsingWKT)ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, CoordinateOperationFactoryUsingWKT.class));
        CoordinateOperation co = fact.createCoordinateOperation(INVERSE_CRS_PAIR);
        CoordinateReferenceSystem crs = CRS.decode((String)TARGET_CRS);
        Assert.assertSame((Object)crs, (Object)co.getSourceCRS());
        crs = CRS.decode((String)SOURCE_CRS);
        Assert.assertSame((Object)crs, (Object)co.getTargetCRS());
        Assert.assertTrue((boolean)(co.getMathTransform() instanceof MathTransform));
        double[] p = new double[2];
        co.getMathTransform().transform(DST_TEST_POINT, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)SRC_TEST_POINT[0], (double)1.0E-8);
        Assert.assertEquals((double)p[1], (double)SRC_TEST_POINT[1], (double)1.0E-8);
    }

    @Test
    public void testGetAuthority() {
        Assert.assertEquals((Object)this.factory.getAuthority(), (Object)Citations.EPSG);
    }

    @Test
    public void testCreateCoordinateOperation() throws TransformException {
        try {
            Assert.assertNull((Object)this.factory.createCoordinateOperation(INVALID_CRS));
        }
        catch (FactoryException e) {
            Assert.fail((String)(this.factory.getClass().getSimpleName() + " threw a FactoryException when requestinga nonexistent operation. Instead, a NoSuchAuthorityCodeException was expected."));
        }
        try {
            CoordinateOperation co = this.factory.createCoordinateOperation(CRS_PAIR);
            Assert.assertNotNull((Object)co);
            CoordinateReferenceSystem crs = CRS.decode((String)SOURCE_CRS);
            Assert.assertSame((Object)crs, (Object)co.getSourceCRS());
            crs = CRS.decode((String)TARGET_CRS);
            Assert.assertSame((Object)crs, (Object)co.getTargetCRS());
            Assert.assertTrue((boolean)(co.getMathTransform() instanceof MathTransform));
            double[] p = new double[2];
            co.getMathTransform().transform(SRC_TEST_POINT, 0, p, 0, 1);
            Assert.assertEquals((double)p[0], (double)DST_TEST_POINT[0], (double)1.0E-8);
            Assert.assertEquals((double)p[1], (double)DST_TEST_POINT[1], (double)1.0E-8);
        }
        catch (FactoryException e) {
            Assert.fail((String)(this.factory.getClass().getSimpleName() + " threw a FactoryException when creating coordinate operation from an existing code."));
        }
    }

    @Test
    public void testCreateFromCoordinateReferenceSystemCodes() throws TransformException {
        Set cos;
        try {
            cos = this.factory.createFromCoordinateReferenceSystemCodes(INVALID_CRS, INVALID_CRS);
            Assert.assertTrue((boolean)cos.isEmpty());
        }
        catch (FactoryException e) {
            Assert.fail((String)(this.factory.getClass().getSimpleName() + " threw a FactoryException when requestinga nonexistent operation. Instead, a NoSuchAuthorityCodeException was expected."));
        }
        try {
            cos = this.factory.createFromCoordinateReferenceSystemCodes(SOURCE_CRS, TARGET_CRS);
            Assert.assertEquals((long)1L, (long)cos.size());
            CoordinateOperation co = (CoordinateOperation)cos.iterator().next();
            Assert.assertNotNull((Object)co);
            CoordinateReferenceSystem crs = CRS.decode((String)SOURCE_CRS);
            Assert.assertSame((Object)crs, (Object)co.getSourceCRS());
            crs = CRS.decode((String)TARGET_CRS);
            Assert.assertSame((Object)crs, (Object)co.getTargetCRS());
            Assert.assertTrue((boolean)(co.getMathTransform() instanceof MathTransform));
            double[] p = new double[2];
            co.getMathTransform().transform(SRC_TEST_POINT, 0, p, 0, 1);
            Assert.assertEquals((double)p[0], (double)DST_TEST_POINT[0], (double)1.0E-8);
            Assert.assertEquals((double)p[1], (double)DST_TEST_POINT[1], (double)1.0E-8);
        }
        catch (FactoryException e) {
            Assert.fail((String)(this.factory.getClass().getSimpleName() + " threw a FactoryException when creating coordinate operation from an existing code."));
        }
    }

    static {
        SRC_TEST_POINT = new double[]{3.084896111, 39.592654167};
        DST_TEST_POINT = new double[]{3.0844689951999427, 39.594235744481225};
    }
}

