/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.io.File;
import java.util.Set;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class FactoryUsingWktTest {
    private FactoryUsingWKT factory;

    @Before
    public void setUp() {
        this.factory = (FactoryUsingWKT)ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, FactoryUsingWKT.class));
    }

    @Test
    public void testCrsAuthorityExtraDirectoryHint() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, FactoryUsingWKT.class);
        try {
            hints.put((Object)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, (Object)"invalid");
            Assert.fail((String)"Should of been tossed out as an invalid hint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String directory = new File(".").getAbsolutePath();
        hints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, FactoryUsingWKT.class);
        hints.put((Object)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, (Object)directory);
    }

    @Test
    public void testAuthority() {
        Citation authority = this.factory.getAuthority();
        Assert.assertNotNull((Object)authority);
        Assert.assertEquals((Object)"European Petroleum Survey Group", (Object)authority.getTitle().toString());
        Assert.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"EPSG"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"ESRI"));
        Assert.assertTrue((boolean)(this.factory instanceof FactoryUsingWKT));
    }

    @Test
    public void testVendor() {
        Citation vendor = this.factory.getVendor();
        Assert.assertNotNull((Object)vendor);
        Assert.assertEquals((Object)"Geotools", (Object)vendor.getTitle().toString());
    }

    @Test
    public void test42101() throws FactoryException {
        CoordinateReferenceSystem expected = this.factory.createCoordinateReferenceSystem("42101");
        CoordinateReferenceSystem actual = CRS.decode((String)"EPSG:42101");
        Assert.assertSame((Object)expected, (Object)actual);
        Assert.assertTrue((boolean)(actual instanceof ProjectedCRS));
        Set ids = actual.getIdentifiers();
        Assert.assertTrue((boolean)ids.contains(new NamedIdentifier(Citations.EPSG, "42101")));
        Assert.assertFalse((boolean)ids.contains(new NamedIdentifier(Citations.ESRI, "42101")));
    }
}

