/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Set;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.wms.AutoCRSFactory;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.EquatorialOrthographic;
import org.geotools.referencing.operation.projection.EquidistantCylindrical;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.Gnomonic;
import org.geotools.referencing.operation.projection.ObliqueOrthographic;
import org.geotools.referencing.operation.projection.PolarOrthographic;
import org.geotools.referencing.operation.projection.Stereographic;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class AUTOTest {
    private CRSAuthorityFactory factory;

    @Before
    public void setUp() {
        this.factory = new AutoCRSFactory();
    }

    @Test
    public void testFactoryFinder() {
        Set authorities = ReferencingFactoryFinder.getAuthorityNames();
        Assert.assertTrue((boolean)authorities.contains("AUTO"));
        Assert.assertTrue((boolean)authorities.contains("AUTO2"));
        this.factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"AUTO", null);
        Assert.assertTrue((boolean)(this.factory instanceof AutoCRSFactory));
        Assert.assertSame((Object)this.factory, (Object)ReferencingFactoryFinder.getCRSAuthorityFactory((String)"AUTO2", null));
    }

    @Test
    public void testAuthority() {
        Citation authority = this.factory.getAuthority();
        Assert.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"AUTO"));
        Assert.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"AUTO2"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"EPSG"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"CRS"));
    }

    @Test
    public void test42001() throws FactoryException {
        ProjectedCRS utm = this.factory.createProjectedCRS("AUTO:42001,0.0,0.0");
        Assert.assertNotNull((String)"auto-utm", (Object)utm);
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("AUTO :42001 ,0,0"));
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("AUTO2:42001 ,0,0"));
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("42001 ,0,0"));
        Assert.assertNotSame((Object)utm, (Object)this.factory.createObject("AUTO :42001 ,30,0"));
        Assert.assertEquals((Object)"Transverse_Mercator", (Object)utm.getConversionFromBase().getMethod().getName().getCode());
    }

    @Test
    public void test42001Units() throws FactoryException {
        ProjectedCRS utm = this.factory.createProjectedCRS("AUTO:42001,9001,0.0,0.0");
        Assert.assertNotNull((String)"auto-utm", (Object)utm);
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("AUTO :42001, 9001,0,0"));
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("AUTO2:42001, 9001,0,0"));
        Assert.assertSame((Object)utm, (Object)this.factory.createObject("42001, 9001,0,0"));
        Assert.assertNotSame((Object)utm, (Object)this.factory.createObject("AUTO :42001, 9001,30,0"));
        Assert.assertEquals((Object)"Transverse_Mercator", (Object)utm.getConversionFromBase().getMethod().getName().getCode());
    }

    @Test
    public void test42003() throws FactoryException {
        ProjectedCRS eqc = this.factory.createProjectedCRS("AUTO:42003,9001,0.0,0");
        Assert.assertEquals((Object)"Orthographic", (Object)eqc.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(eqc.getConversionFromBase().getMathTransform() instanceof EquatorialOrthographic));
        eqc = this.factory.createProjectedCRS("AUTO:42003,9001,0.0,90");
        Assert.assertEquals((Object)"Orthographic", (Object)eqc.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(eqc.getConversionFromBase().getMathTransform() instanceof PolarOrthographic));
        eqc = this.factory.createProjectedCRS("AUTO:42003,9001,0.0,45");
        Assert.assertEquals((Object)"Orthographic", (Object)eqc.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(eqc.getConversionFromBase().getMathTransform() instanceof ObliqueOrthographic));
    }

    @Test
    public void test42004() throws FactoryException {
        ProjectedCRS eqc = this.factory.createProjectedCRS("AUTO:42004,9001,0.0,35");
        Assert.assertEquals((Object)"Equidistant_Cylindrical", (Object)eqc.getConversionFromBase().getMethod().getName().getCode());
        String stdParallel1Code = EquidistantCylindrical.Provider.STANDARD_PARALLEL_1.getName().getCode();
        double stdParallel1 = eqc.getConversionFromBase().getParameterValues().parameter(stdParallel1Code).doubleValue();
        Assert.assertEquals((double)35.0, (double)stdParallel1, (double)1.0E-9);
    }

    @Test
    public void test97001() throws FactoryException {
        ProjectedCRS crs = this.factory.createProjectedCRS("AUTO:97001,9001,-17.0,23.0");
        Assert.assertEquals((Object)"Gnomonic", (Object)crs.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(crs.getConversionFromBase().getMathTransform() instanceof Gnomonic));
        String centreLatCode = Gnomonic.Provider.LATITUDE_OF_CENTRE.getName().getCode();
        double centreLat = crs.getConversionFromBase().getParameterValues().parameter(centreLatCode).doubleValue();
        Assert.assertEquals((double)23.0, (double)centreLat, (double)1.0E-9);
        String centreLongCode = Gnomonic.Provider.LONGITUDE_OF_CENTRE.getName().getCode();
        double centreLong = crs.getConversionFromBase().getParameterValues().parameter(centreLongCode).doubleValue();
        Assert.assertEquals((double)-17.0, (double)centreLong, (double)1.0E-9);
    }

    @Test
    public void test97002() throws FactoryException {
        ProjectedCRS crs = this.factory.createProjectedCRS("AUTO:97002,9001,-17.0,23.0");
        Assert.assertEquals((Object)"Stereographic", (Object)crs.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(crs.getConversionFromBase().getMathTransform() instanceof Stereographic));
        String centreLatCode = Stereographic.Provider.LATITUDE_OF_ORIGIN.getName().getCode();
        double centreLat = crs.getConversionFromBase().getParameterValues().parameter(centreLatCode).doubleValue();
        Assert.assertEquals((double)23.0, (double)centreLat, (double)1.0E-9);
        String centreLongCode = Stereographic.Provider.CENTRAL_MERIDIAN.getName().getCode();
        double centreLong = crs.getConversionFromBase().getParameterValues().parameter(centreLongCode).doubleValue();
        Assert.assertEquals((double)-17.0, (double)centreLong, (double)1.0E-9);
        String semiMajorString = Stereographic.Provider.SEMI_MAJOR.getName().getCode();
        double semiMajor = crs.getConversionFromBase().getParameterValues().parameter(semiMajorString).doubleValue();
        String semiMinorString = Stereographic.Provider.SEMI_MINOR.getName().getCode();
        double semiMinor = crs.getConversionFromBase().getParameterValues().parameter(semiMinorString).doubleValue();
        Assert.assertEquals((double)semiMajor, (double)semiMinor, (double)1.0E-9);
    }

    @Test
    public void test97003() throws Exception {
        ProjectedCRS crs = this.factory.createProjectedCRS("AUTO:97003,9001,-71.43,42.56");
        Assert.assertEquals((Object)"Azimuthal_Equidistant", (Object)crs.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(crs.getConversionFromBase().getMathTransform() instanceof AzimuthalEquidistant.Ellipsoidal));
        String centreLongCode = Stereographic.Provider.CENTRAL_MERIDIAN.getName().getCode();
        double centreLong = crs.getConversionFromBase().getParameterValues().parameter(centreLongCode).doubleValue();
        Assert.assertEquals((double)-71.43, (double)centreLong, (double)1.0E-9);
        String centreLatCode = Stereographic.Provider.LATITUDE_OF_ORIGIN.getName().getCode();
        double centreLat = crs.getConversionFromBase().getParameterValues().parameter(centreLatCode).doubleValue();
        Assert.assertEquals((double)42.56, (double)centreLat, (double)1.0E-9);
    }

    @Test
    public void test97004() throws Exception {
        ProjectedCRS crs = this.factory.createProjectedCRS("AUTO:97004,9001,20,0");
        Assert.assertEquals((Object)"GEOS", (Object)crs.getConversionFromBase().getMethod().getName().getCode());
        Assert.assertTrue((boolean)(crs.getConversionFromBase().getMathTransform() instanceof GeostationarySatellite.Ellipsoidal));
        String centreLongCode = GeostationarySatellite.Provider.CENTRAL_MERIDIAN.getName().getCode();
        double centreLong = crs.getConversionFromBase().getParameterValues().parameter(centreLongCode).doubleValue();
        Assert.assertEquals((double)20.0, (double)centreLong, (double)1.0E-9);
        String heightCode = GeostationarySatellite.Provider.SATELLITE_HEIGHT.getName().getCode();
        double height = crs.getConversionFromBase().getParameterValues().parameter(heightCode).doubleValue();
        Assert.assertEquals((double)3.5785831E7, (double)height, (double)1.0E-9);
    }
}

